/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.sqlserver;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.orm.CompilationManager;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.testutil.SeqFileReader;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.util.ClassLoaderStack;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.manager.sqlserver.MSSQLTestUtils;

public class SQLServerQueryManualTest
extends ImportJobTestCase {
    @Override
    public void setUp() {
        super.setUp();
        MSSQLTestUtils utils = new MSSQLTestUtils();
        try {
            utils.createTableFromSQL("CREATE TABLE TPCH1M_LINEITEM( [L_ORDERKEY] [int] NULL, [L_PARTKEY] [int] NULL, [L_SUPPKEY] [int] NULL, [L_LINENUMBER] [int] NULL, [L_QUANTITY] [int] NULL, [L_EXTENDEDPRICE] [decimal](15, 2) NULL, [L_DISCOUNT] [decimal](15, 2) NULL, [L_TAX] [decimal](15, 2) NULL, [L_RETURNFLAG] [varchar](max) NULL, [L_LINESTATUS] [varchar](max) NULL, [L_SHIPDATE] [varchar](max) NULL, [L_COMMITDATE] [varchar](max) NULL, [L_RECEIPTDATE] [varchar](max) NULL, [L_SHIPINSTRUCT] [varchar](max) NULL, [L_SHIPMODE] [varchar](max) NULL, [L_COMMENT] [varchar](max) NULL) ");
            utils.populateLineItem();
        }
        catch (SQLException e) {
            LOG.error((Object)("Setup fail with SQLException: " + StringUtils.stringifyException((Throwable)e)));
            SQLServerQueryManualTest.fail((String)("Setup fail with SQLException: " + e.toString()));
        }
    }

    @Override
    public void tearDown() {
        super.tearDown();
        MSSQLTestUtils utils = new MSSQLTestUtils();
        try {
            utils.dropTableIfExists("TPCH1M_LINEITEM");
        }
        catch (SQLException e) {
            LOG.error((Object)("TearDown fail with SQLException: " + StringUtils.stringifyException((Throwable)e)));
            SQLServerQueryManualTest.fail((String)("TearDown fail with SQLException: " + e.toString()));
        }
    }

    protected String[] getArgv(boolean includeHadoopFlags, String query, String targetDir, boolean allowParallel) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        String username = MSSQLTestUtils.getDBUserName();
        String password = MSSQLTestUtils.getDBPassWord();
        args.add("--query");
        args.add(query);
        args.add("--split-by");
        args.add("L_ORDERKEY");
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--username");
        args.add(username);
        args.add("--password");
        args.add(password);
        args.add("--as-sequencefile");
        args.add("--target-dir");
        args.add(targetDir);
        args.add("--class-name");
        args.add(this.getTableName());
        if (allowParallel) {
            args.add("--num-mappers");
            args.add("2");
        } else {
            args.add("--num-mappers");
            args.add("1");
        }
        return args.toArray(new String[0]);
    }

    private int getFirstInt(String str) {
        String[] parts = str.split(",");
        return Integer.parseInt(parts[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runQueryTest(String query, String firstValStr, int numExpectedResults, int expectedSum, String targetDir) throws IOException {
        ClassLoader prevClassLoader = null;
        SequenceFile.Reader reader = null;
        String[] argv = this.getArgv(true, query, targetDir, false);
        this.runImport(argv);
        try {
            SqoopOptions opts = new ImportTool().parseArguments(this.getArgv(false, query, targetDir, false), null, null, true);
            CompilationManager compileMgr = new CompilationManager(opts);
            String jarFileName = compileMgr.getJarFilename();
            prevClassLoader = ClassLoaderStack.addJarFile((String)jarFileName, (String)this.getTableName());
            reader = SeqFileReader.getSeqFileReader(this.getDataFilePath().toString());
            Configuration conf = new Configuration();
            Object key = ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Object val = ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            if (reader.next(key) == null) {
                SQLServerQueryManualTest.fail((String)"Empty SequenceFile during import");
            }
            reader.getCurrentValue(val);
            SQLServerQueryManualTest.assertEquals((String)"Invalid ordering within sorted SeqFile", (String)firstValStr, (String)val.toString());
            int curSum = this.getFirstInt(val.toString());
            int totalResults = 1;
            while (reader.next(key) != null) {
                reader.getCurrentValue(val);
                curSum += this.getFirstInt(val.toString());
                ++totalResults;
            }
            SQLServerQueryManualTest.assertEquals((String)"Total sum of first db column mismatch", (int)expectedSum, (int)curSum);
            SQLServerQueryManualTest.assertEquals((String)"Incorrect number of results for query", (int)numExpectedResults, (int)totalResults);
            IOUtils.closeStream((Closeable)reader);
            if (null == prevClassLoader) return;
        }
        catch (SqoopOptions.InvalidOptionsException ioe) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)ioe));
            SQLServerQueryManualTest.fail((String)ioe.toString());
            return;
        }
        catch (ParseException pe) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)pe));
            SQLServerQueryManualTest.fail((String)pe.toString());
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeStream(reader);
            if (null != prevClassLoader) {
                ClassLoaderStack.setCurrentClassLoader(prevClassLoader);
            }
        }
        ClassLoaderStack.setCurrentClassLoader((ClassLoader)prevClassLoader);
        return;
    }

    public void testSelectStar() throws IOException {
        this.runQueryTest("SELECT * FROM " + this.getTableName() + " WHERE L_ORDERKEY > 0 AND $CONDITIONS", "1,2,3,4,5,6.00,7.00,8.00,AB,CD,abcd,efgh,hijk,dothis,likethis,nocomments\n", 4, 10, this.getTablePath().toString());
    }

    public void testCompoundWhere() throws IOException {
        this.runQueryTest("SELECT * FROM " + this.getTableName() + " WHERE L_ORDERKEY > 1 AND L_PARTKEY < 4 AND $CONDITIONS", "2,3,4,5,6,7.00,8.00,9.00,AB,CD,abcd,efgh,hijk,dothis,likethis,nocomments\n", 1, 2, this.getTablePath().toString());
    }

    public void testFailNoConditions() throws IOException {
        String[] argv = this.getArgv(true, "SELECT * FROM " + this.getTableName(), this.getTablePath().toString() + "where $CONDITIONS", true);
        try {
            this.runImport(argv);
            SQLServerQueryManualTest.fail((String)"Expected exception running import without $CONDITIONS");
        }
        catch (Exception e) {
            LOG.info((Object)("Got exception " + e + " running job (expected; ok)"));
        }
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getConnectString() {
        return System.getProperty("sqoop.test.sqlserver.connectstring.host_url", "jdbc:sqlserver://sqlserverhost:1433");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTableIfExists(String table) throws SQLException {
        Connection conn = this.getManager().getConnection();
        String sqlStmt = "IF OBJECT_ID('" + table + "') IS NOT NULL  DROP TABLE " + table;
        PreparedStatement statement = conn.prepareStatement(sqlStmt, 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    @Override
    protected SqoopOptions getSqoopOptions(Configuration conf) {
        SqoopOptions opt = new SqoopOptions(conf);
        String username = MSSQLTestUtils.getDBUserName();
        String password = MSSQLTestUtils.getDBPassWord();
        SqoopOptions opts = new SqoopOptions(conf);
        opts.setUsername(username);
        opts.setPassword(password);
        return opt;
    }

    @Override
    protected String getTableName() {
        return "tpch1m_lineitem";
    }
}

