/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.sqlserver;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.manager.sqlserver.MSSQLTestData;

public class MSSQLTestDataFileParser {
    public static final Log LOG = LogFactory.getLog((String)MSSQLTestDataFileParser.class.getName());
    private String filename;
    private String delim;
    private List records;

    MSSQLTestDataFileParser(String filename) throws Exception {
        this.filename = filename;
    }

    public void parse() throws Exception {
        if (this.filename == null) {
            throw new Exception("No test data file specified.");
        }
        BufferedReader br = new BufferedReader(new FileReader(this.filename));
        if (br != null) {
            String tmp;
            this.records = new ArrayList();
            String del = this.getDelim();
            int offset = 0;
            while ((tmp = br.readLine()) != null) {
                ++offset;
                String[] splits = tmp.split(del);
                if (splits.length != 5 && splits.length != 6 && splits.length != 7) continue;
                System.out.println(Integer.toString(offset));
                MSSQLTestData td = new MSSQLTestData(splits[0]);
                td.setData(MSSQLTestData.KEY_STRINGS.OFFSET, Integer.toString(offset));
                if (splits[0].equals(DATATYPES.DECIMAL.toString()) || splits[0].equals(DATATYPES.NUMERIC.toString())) {
                    td.setData(MSSQLTestData.KEY_STRINGS.TO_INSERT, splits[1]);
                    td.setData(MSSQLTestData.KEY_STRINGS.DB_READBACK, splits[2]);
                    td.setData(MSSQLTestData.KEY_STRINGS.HDFS_READBACK, splits[3]);
                    td.setData(MSSQLTestData.KEY_STRINGS.SCALE, splits[4]);
                    td.setData(MSSQLTestData.KEY_STRINGS.PREC, splits[5]);
                    td.setData(MSSQLTestData.KEY_STRINGS.NEG_POS_FLAG, splits[6]);
                    this.records.add(td);
                    continue;
                }
                if (splits[0].equals(DATATYPES.NCHAR.toString()) || splits[0].equals(DATATYPES.VARBINARY.toString()) || splits[0].equals(DATATYPES.NVARCHAR.toString()) || splits[0].equals(DATATYPES.CHAR.toString()) || splits[0].equals(DATATYPES.VARCHAR.toString()) || splits[0].equals(DATATYPES.BINARY.toString())) {
                    td.setData(MSSQLTestData.KEY_STRINGS.TO_INSERT, splits[1]);
                    td.setData(MSSQLTestData.KEY_STRINGS.DB_READBACK, splits[2]);
                    td.setData(MSSQLTestData.KEY_STRINGS.HDFS_READBACK, splits[3]);
                    td.setData(MSSQLTestData.KEY_STRINGS.SCALE, splits[4]);
                    td.setData(MSSQLTestData.KEY_STRINGS.NEG_POS_FLAG, splits[5]);
                    this.records.add(td);
                    continue;
                }
                td.setData(MSSQLTestData.KEY_STRINGS.TO_INSERT, splits[1]);
                td.setData(MSSQLTestData.KEY_STRINGS.DB_READBACK, splits[2]);
                td.setData(MSSQLTestData.KEY_STRINGS.HDFS_READBACK, splits[3]);
                td.setData(MSSQLTestData.KEY_STRINGS.NEG_POS_FLAG, splits[4]);
                this.records.add(td);
            }
            System.out.println("\n\n Records" + this.records.size() + "\n\n");
        }
    }

    public List getRecords() {
        return this.records;
    }

    public List getTestdata(DATATYPES dt) {
        ArrayList<MSSQLTestData> l = new ArrayList<MSSQLTestData>();
        if (this.records != null) {
            for (MSSQLTestData tmp : this.records) {
                if (!tmp.getDatatype().equals(dt.toString())) continue;
                l.add(tmp);
            }
        }
        return l;
    }

    private void trim(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].trim();
        }
    }

    public String getDelim() {
        return this.delim;
    }

    public void setDelim(String delim1) {
        this.delim = delim1;
    }

    static enum DATATYPES {
        DECIMAL,
        NUMERIC,
        VARBINARY,
        TIME,
        SMALLDATETIME,
        DATETIME,
        DATETIME2,
        DATETIMEOFFSET,
        BIGINT,
        INT,
        MONEY,
        SMALLMONEY,
        TEXT,
        NTEXT,
        NCHAR,
        NVARCHAR,
        IMAGE,
        SMALLINT,
        FLOAT,
        REAL,
        DATE,
        CHAR,
        VARCHAR,
        BINARY,
        TINYINT;

    }
}

