/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.credentials;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import com.cloudera.sqoop.testutil.CommonArgs;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.tool.ImportTool;

public class TestPassingSecurePassword
extends BaseSqoopTestCase {
    @Override
    public void setUp() {
        super.setUp();
        Path warehousePath = new Path(this.getWarehouseDir());
        try {
            FileSystem fs = FileSystem.get((Configuration)this.getConf());
            fs.create(warehousePath, true);
        }
        catch (IOException e) {
            System.out.println("Could not create warehouse dir!");
        }
    }

    public void testPasswordFilePathInOptionIsEnabled() throws Exception {
        String passwordFilePath = TEMP_BASE_DIR + ".pwd";
        this.createTempFile(passwordFilePath);
        try {
            ArrayList<String> extraArgs = new ArrayList<String>();
            extraArgs.add("--username");
            extraArgs.add("username");
            extraArgs.add("--password-file");
            extraArgs.add(passwordFilePath);
            String[] commonArgs = this.getCommonArgs(false, extraArgs);
            ArrayList argsList = new ArrayList();
            Collections.addAll(argsList, commonArgs);
            TestPassingSecurePassword.assertTrue((String)"passwordFilePath option missing.", (boolean)argsList.contains("--password-file"));
        }
        catch (Exception e) {
            TestPassingSecurePassword.fail((String)"passwordPath option is missing.");
        }
    }

    public void testPasswordFileDoesNotExist() throws Exception {
        try {
            ArrayList<String> extraArgs = new ArrayList<String>();
            extraArgs.add("--password-file");
            extraArgs.add(TEMP_BASE_DIR + "unknown");
            String[] argv = this.getCommonArgs(false, extraArgs);
            Configuration conf = this.getConf();
            SqoopOptions opts = this.getSqoopOptions(conf);
            ImportTool importTool = new ImportTool();
            importTool.parseArguments(argv, conf, opts, true);
            TestPassingSecurePassword.fail((String)"The password file does not exist! ");
        }
        catch (Exception e) {
            TestPassingSecurePassword.assertTrue((boolean)e.getMessage().contains("The password file does not exist!"));
        }
    }

    public void testPasswordFileIsADirectory() throws Exception {
        try {
            ArrayList<String> extraArgs = new ArrayList<String>();
            extraArgs.add("--password-file");
            extraArgs.add(TEMP_BASE_DIR);
            String[] argv = this.getCommonArgs(false, extraArgs);
            Configuration conf = this.getConf();
            SqoopOptions opts = this.getSqoopOptions(conf);
            ImportTool importTool = new ImportTool();
            importTool.parseArguments(argv, conf, opts, true);
            TestPassingSecurePassword.fail((String)"The password file cannot be a directory! ");
        }
        catch (Exception e) {
            TestPassingSecurePassword.assertTrue((boolean)e.getMessage().contains("The password file cannot be a directory!"));
        }
    }

    public void testBothPasswordOptions() throws Exception {
        String passwordFilePath = TEMP_BASE_DIR + ".pwd";
        this.createTempFile(passwordFilePath);
        try {
            ArrayList<String> extraArgs = new ArrayList<String>();
            extraArgs.add("--username");
            extraArgs.add("username");
            extraArgs.add("--password");
            extraArgs.add("password");
            extraArgs.add("--password-file");
            extraArgs.add(passwordFilePath);
            String[] argv = this.getCommonArgs(false, extraArgs);
            Configuration conf = this.getConf();
            SqoopOptions in = this.getSqoopOptions(conf);
            ImportTool importTool = new ImportTool();
            SqoopOptions out = importTool.parseArguments(argv, conf, in, true);
            TestPassingSecurePassword.assertNotNull((Object)out.getPassword());
            importTool.validateOptions(out);
            TestPassingSecurePassword.fail((String)"Either password or passwordPath must be specified but not both.");
        }
        catch (Exception e) {
            TestPassingSecurePassword.assertTrue((boolean)e.getMessage().contains("Either password or path to a password file must be specified but not both"));
        }
    }

    public void testPasswordFilePath() throws Exception {
        String passwordFilePath = TEMP_BASE_DIR + ".pwd";
        this.createTempFile(passwordFilePath);
        this.writeToFile(passwordFilePath, "password");
        try {
            ArrayList<String> extraArgs = new ArrayList<String>();
            extraArgs.add("--username");
            extraArgs.add("username");
            extraArgs.add("--password-file");
            extraArgs.add(passwordFilePath);
            String[] commonArgs = this.getCommonArgs(false, extraArgs);
            Configuration conf = this.getConf();
            SqoopOptions in = this.getSqoopOptions(conf);
            ImportTool importTool = new ImportTool();
            SqoopOptions out = importTool.parseArguments(commonArgs, conf, in, true);
            TestPassingSecurePassword.assertNotNull((Object)out.getPasswordFilePath());
            TestPassingSecurePassword.assertNotNull((Object)out.getPassword());
            TestPassingSecurePassword.assertEquals((String)"password", (String)out.getPassword());
        }
        catch (Exception e) {
            TestPassingSecurePassword.fail((String)"passwordPath option is missing.");
        }
    }

    public void testPasswordInDBConfiguration() throws Exception {
        JobConf jobConf = new JobConf(this.getConf());
        DBConfiguration.configureDB((Configuration)jobConf, (String)"org.hsqldb.jdbcDriver", (String)this.getConnectString(), (String)"username", (String)"password", null, null);
        TestPassingSecurePassword.assertNotNull((Object)jobConf.getCredentials().getSecretKey(new Text("mapreduce.jdbc.password")));
        TestPassingSecurePassword.assertEquals((String)"password", (String)new String(jobConf.getCredentials().getSecretKey(new Text("mapreduce.jdbc.password"))));
        jobConf = new JobConf();
        DBConfiguration.configureDB((Configuration)jobConf, (String)"org.hsqldb.jdbcDriver", (String)this.getConnectString(), null, null, null, null);
        DBConfiguration dbConfiguration = new DBConfiguration((Configuration)jobConf);
        Connection connection = dbConfiguration.getConnection();
        TestPassingSecurePassword.assertNotNull((Object)connection);
    }

    public void testPasswordNotInJobConf() throws Exception {
        JobConf jobConf = new JobConf(this.getConf());
        DBConfiguration.configureDB((Configuration)jobConf, (String)"org.hsqldb.jdbcDriver", (String)this.getConnectString(), (String)"username", (String)"password", null, null);
        TestPassingSecurePassword.assertNull((Object)jobConf.get("mapreduce.jdbc.password", null));
    }

    public void testPasswordInMetastoreWithRecordEnabledAndSecureOption() throws Exception {
        String passwordFilePath = TEMP_BASE_DIR + ".pwd";
        this.createTempFile(passwordFilePath);
        ArrayList<String> extraArgs = new ArrayList<String>();
        extraArgs.add("--username");
        extraArgs.add("username");
        extraArgs.add("--password-file");
        extraArgs.add(passwordFilePath);
        String[] argv = this.getCommonArgs(false, extraArgs);
        Configuration conf = this.getConf();
        SqoopOptions in = this.getSqoopOptions(conf);
        ImportTool importTool = new ImportTool();
        SqoopOptions out = importTool.parseArguments(argv, conf, in, true);
        TestPassingSecurePassword.assertNotNull((Object)out.getPassword());
        conf.set("sqoop.metastore.client.record.password", "true");
        Properties propertiesIntoMetastore = out.writeProperties();
        TestPassingSecurePassword.assertNull((Object)propertiesIntoMetastore.getProperty("db.password"));
        TestPassingSecurePassword.assertNotNull((Object)propertiesIntoMetastore.getProperty("db.password.file"));
        SqoopOptions optionsFromMetastore = new SqoopOptions();
        optionsFromMetastore.loadProperties(propertiesIntoMetastore);
        TestPassingSecurePassword.assertNotNull((Object)optionsFromMetastore.getPassword());
        TestPassingSecurePassword.assertNotNull((Object)optionsFromMetastore.getPasswordFilePath());
        TestPassingSecurePassword.assertEquals((String)passwordFilePath, (String)optionsFromMetastore.getPasswordFilePath());
    }

    public void testPasswordInMetastoreWithRecordDisabledAndSecureOption() throws Exception {
        String passwordFilePath = TEMP_BASE_DIR + ".pwd";
        this.createTempFile(passwordFilePath);
        ArrayList<String> extraArgs = new ArrayList<String>();
        extraArgs.add("--username");
        extraArgs.add("username");
        extraArgs.add("--password-file");
        extraArgs.add(passwordFilePath);
        String[] argv = this.getCommonArgs(false, extraArgs);
        Configuration conf = this.getConf();
        SqoopOptions in = this.getSqoopOptions(conf);
        ImportTool importTool = new ImportTool();
        SqoopOptions out = importTool.parseArguments(argv, conf, in, true);
        TestPassingSecurePassword.assertNotNull((Object)out.getPassword());
        conf.set("sqoop.metastore.client.record.password", "false");
        Properties propertiesIntoMetastore = out.writeProperties();
        TestPassingSecurePassword.assertNull((Object)propertiesIntoMetastore.getProperty("db.password"));
        TestPassingSecurePassword.assertNotNull((Object)propertiesIntoMetastore.getProperty("db.password.file"));
        SqoopOptions optionsFromMetastore = new SqoopOptions();
        optionsFromMetastore.loadProperties(propertiesIntoMetastore);
        TestPassingSecurePassword.assertNotNull((Object)optionsFromMetastore.getPassword());
        TestPassingSecurePassword.assertNotNull((Object)optionsFromMetastore.getPasswordFilePath());
        TestPassingSecurePassword.assertEquals((String)passwordFilePath, (String)optionsFromMetastore.getPasswordFilePath());
    }

    public void testPasswordInMetastoreWithRecordEnabledAndNonSecureOption() throws Exception {
        ArrayList<String> extraArgs = new ArrayList<String>();
        extraArgs.add("--username");
        extraArgs.add("username");
        extraArgs.add("--password");
        extraArgs.add("password");
        String[] argv = this.getCommonArgs(false, extraArgs);
        Configuration conf = this.getConf();
        SqoopOptions in = this.getSqoopOptions(conf);
        ImportTool importTool = new ImportTool();
        SqoopOptions out = importTool.parseArguments(argv, conf, in, true);
        TestPassingSecurePassword.assertNotNull((Object)out.getPassword());
        conf.set("sqoop.metastore.client.record.password", "true");
        Properties propertiesIntoMetastore = out.writeProperties();
        TestPassingSecurePassword.assertNotNull((Object)propertiesIntoMetastore.getProperty("db.password"));
        TestPassingSecurePassword.assertNull((Object)propertiesIntoMetastore.getProperty("db.password.file"));
        SqoopOptions optionsFromMetastore = new SqoopOptions();
        optionsFromMetastore.loadProperties(propertiesIntoMetastore);
        TestPassingSecurePassword.assertNotNull((Object)optionsFromMetastore.getPassword());
        TestPassingSecurePassword.assertNull((Object)optionsFromMetastore.getPasswordFilePath());
    }

    private String[] getCommonArgs(boolean includeHadoopFlags, ArrayList<String> extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--table");
        args.add(this.getTableName());
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--as-textfile");
        args.add("--num-mappers");
        args.add("2");
        args.addAll(extraArgs);
        return args.toArray(new String[0]);
    }

    private void createTempFile(String filePath) throws IOException {
        File pwdFile = new File(filePath);
        pwdFile.createNewFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String filePath, String contents) throws IOException {
        File pwdFile = new File(filePath);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(pwdFile);
            fos.write(contents.getBytes());
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }
}

