/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.io;

import com.cloudera.sqoop.io.LobFile;
import com.cloudera.sqoop.io.UnsupportedCodecException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class TestLobFile
extends TestCase {
    public static final Log LOG = LogFactory.getLog((String)TestLobFile.class.getName());
    public static final Path TEMP_BASE_DIR;
    private Configuration conf;
    private FileSystem fs;

    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.set("fs.default.name", "file:///");
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.fs.mkdirs(TEMP_BASE_DIR);
    }

    private long[] writeClobFile(Path p, String codec, String ... records) throws Exception {
        if (this.fs.exists(p)) {
            this.fs.delete(p, false);
        }
        long[] offsets = new long[records.length];
        LobFile.Writer writer = LobFile.create((Path)p, (Configuration)this.conf, (boolean)true, (String)codec, (int)4);
        int i = 0;
        for (String r : records) {
            offsets[i++] = writer.tell();
            Writer w = writer.writeClobRecord((long)r.length());
            w.write(r);
            w.close();
        }
        writer.close();
        return offsets;
    }

    private void verifyClobFile(Path p, String ... expectedRecords) throws Exception {
        LobFile.Reader reader = LobFile.open((Path)p, (Configuration)this.conf);
        int recNum = 0;
        while (reader.next()) {
            int bytesRead;
            int thisRead;
            String expected = expectedRecords[recNum];
            TestLobFile.assertTrue((boolean)reader.isRecordAvailable());
            TestLobFile.assertEquals((long)expected.length(), (long)reader.getRecordLen());
            Reader r = reader.readClobRecord();
            CharBuffer buf = CharBuffer.allocate(expected.length());
            for (bytesRead = 0; bytesRead < expected.length(); bytesRead += thisRead) {
                thisRead = r.read(buf);
                LOG.info((Object)("performed read of " + thisRead + " chars"));
                if (-1 == thisRead) break;
            }
            LOG.info((Object)("Got record of " + bytesRead + " chars"));
            TestLobFile.assertEquals((int)expected.length(), (int)bytesRead);
            char[] charData = buf.array();
            String finalRecord = new String(charData);
            TestLobFile.assertEquals((String)expected, (String)finalRecord);
            ++recNum;
        }
        TestLobFile.assertEquals((int)expectedRecords.length, (int)recNum);
        reader.close();
        try {
            reader.next();
            TestLobFile.fail((String)"Expected IOException calling next after close");
        }
        catch (IOException ioe) {
            // empty catch block
        }
        reader.close();
    }

    private void runClobFileTest(Path p, String codec, String ... records) throws Exception {
        this.writeClobFile(p, codec, records);
        this.verifyClobFile(p, records);
        this.fs.delete(p, false);
    }

    public void testEmptyRecord() throws Exception {
        this.runClobFileTest(new Path(TEMP_BASE_DIR, "empty.lob"), null, new String[0]);
    }

    public void testSingleRecord() throws Exception {
        this.runClobFileTest(new Path(TEMP_BASE_DIR, "single.lob"), null, "this is a single record!");
    }

    public void testMultiRecords() throws Exception {
        this.runClobFileTest(new Path(TEMP_BASE_DIR, "multi.lob"), "none", "this is the first record", "this is the second record. I assure you that this record is long.", "yet one more record graces this file.");
    }

    public void testMultiIndexSegments() throws Exception {
        this.runClobFileTest(new Path(TEMP_BASE_DIR, "multi-index.lob"), null, "this is the first record", "this is the second record. I assure you that this record is long.", "record number three", "last one in first index segment", "first in the second index segment", "yet one more record graces this file.");
    }

    private void runLineAndRecordTest(Path p, String firstLine, String ... records) throws Exception {
        TestLobFile.assertTrue((String)"This test requires 3+ records", (records.length > 2 ? 1 : 0) != 0);
        this.writeClobFile(p, null, records);
        LobFile.Reader reader = LobFile.open((Path)p, (Configuration)this.conf);
        TestLobFile.assertFalse((boolean)reader.isRecordAvailable());
        TestLobFile.assertTrue((boolean)reader.next());
        TestLobFile.assertTrue((boolean)reader.isRecordAvailable());
        Reader r = reader.readClobRecord();
        BufferedReader br = new BufferedReader(r);
        String line = br.readLine();
        TestLobFile.assertEquals((String)firstLine, (String)line);
        br.close();
        r.close();
        TestLobFile.assertFalse((boolean)reader.isRecordAvailable());
        TestLobFile.assertTrue((boolean)reader.next());
        r = reader.readClobRecord();
        CharBuffer buf = CharBuffer.allocate(records[1].length());
        r.read(buf);
        r.close();
        char[] chars = buf.array();
        String s = new String(chars);
        TestLobFile.assertEquals((String)records[1], (String)s);
        reader.close();
        TestLobFile.assertFalse((boolean)reader.isRecordAvailable());
    }

    public void testVeryShortRead() throws Exception {
        Path p = new Path(TEMP_BASE_DIR, "shortread.lob");
        String FIRST_LINE = "line1";
        String SECOND_LINE = "This contains much more in the record than just one line.";
        String RECORD2 = "here is the second record.";
        String RECORD3 = "The 3rd record, which we won't actually read.";
        this.runLineAndRecordTest(p, "line1", "line1\nThis contains much more in the record than just one line.", "here is the second record.", "The 3rd record, which we won't actually read.");
    }

    public void testIncompleteOverread() throws Exception {
        Path p = new Path(TEMP_BASE_DIR, "longread.lob");
        String FIRST_LINE = "this is a really long line of text to read!";
        String SECOND_LINE = "not this.";
        String RECORD2 = "Here is yet another record to verify.";
        String RECORD3 = "Nobody cares about record 3.";
        this.runLineAndRecordTest(p, "this is a really long line of text to read!", "this is a really long line of text to read!\nnot this.", "Here is yet another record to verify.", "Nobody cares about record 3.");
    }

    public void testSeekToRecord() throws Exception {
        Path p = new Path(TEMP_BASE_DIR, "seek.lob");
        String[] records = new String[]{"this is the first record!", "here comes record number two. It is a bit longer.", "this is the third record. we can read it."};
        LobFile.Writer writer = LobFile.create((Path)p, (Configuration)this.conf, (boolean)true);
        int recNum = 0;
        long rec3Start = 0L;
        for (String r : records) {
            Writer w = writer.writeClobRecord((long)r.length());
            w.write(r);
            w.close();
            writer.finishRecord();
            if (recNum == 1) {
                rec3Start = writer.tell();
                LOG.info((Object)("Record three start: " + rec3Start));
            }
            ++recNum;
        }
        writer.close();
        LobFile.Reader reader = LobFile.open((Path)p, (Configuration)this.conf);
        reader.seek(rec3Start);
        TestLobFile.assertTrue((boolean)reader.next());
        TestLobFile.assertTrue((boolean)reader.isRecordAvailable());
        TestLobFile.assertEquals((long)rec3Start, (long)reader.getRecordOffset());
        Reader r = reader.readClobRecord();
        CharBuffer buf = CharBuffer.allocate(records[2].length());
        r.read(buf);
        r.close();
        char[] chars = buf.array();
        String s = new String(chars);
        TestLobFile.assertEquals((String)records[2], (String)s);
        r.close();
        reader.close();
    }

    private void verifyNextRecord(LobFile.Reader reader, long expectedId, String expectedRecord) throws Exception {
        int bytesRead;
        int thisRead;
        TestLobFile.assertTrue((boolean)reader.next());
        TestLobFile.assertTrue((boolean)reader.isRecordAvailable());
        TestLobFile.assertEquals((long)expectedId, (long)reader.getRecordId());
        Reader r = reader.readClobRecord();
        CharBuffer buf = CharBuffer.allocate(expectedRecord.length());
        for (bytesRead = 0; bytesRead < expectedRecord.length() && -1 != (thisRead = r.read(buf)); bytesRead += thisRead) {
        }
        LOG.info((Object)("Got record of " + bytesRead + " chars"));
        TestLobFile.assertEquals((int)expectedRecord.length(), (int)bytesRead);
        char[] charData = buf.array();
        String finalRecord = new String(charData);
        TestLobFile.assertEquals((String)expectedRecord, (String)finalRecord);
    }

    public void testManySeeks() throws Exception {
        Path p = new Path(TEMP_BASE_DIR, "manyseeks.lob");
        String[] records = new String[]{"first record", "second record", "the third record", "rec4 is the last in IndexSeg 0", "rec5 is first in IndexSeg 1", "rec6 is yet another record", "rec7 is starting to feel boring", "rec8 is at the end of seg 1", "rec9 is all by itself in seg 2"};
        long[] offsets = this.writeClobFile(p, null, records);
        this.verifyClobFile(p, records);
        LobFile.Reader reader = LobFile.open((Path)p, (Configuration)this.conf);
        reader.seek(0L);
        this.verifyNextRecord(reader, 0L, records[0]);
        reader.seek(offsets[3]);
        this.verifyNextRecord(reader, 3L, records[3]);
        reader.seek(offsets[3] - 10L);
        this.verifyNextRecord(reader, 3L, records[3]);
        reader.seek(offsets[0]);
        this.verifyNextRecord(reader, 0L, records[0]);
        reader.seek(offsets[4]);
        this.verifyNextRecord(reader, 4L, records[4]);
        reader.seek(0L);
        reader.seek(offsets[4] - 10L);
        this.verifyNextRecord(reader, 4L, records[4]);
        reader.seek(offsets[8] + 4L);
        TestLobFile.assertFalse((String)"Found a record past last record start.", (boolean)reader.next());
        reader.seek(offsets[2]);
        this.verifyNextRecord(reader, 2L, records[2]);
        reader.seek(offsets[3] - 1L);
        this.verifyNextRecord(reader, 3L, records[3]);
        this.verifyNextRecord(reader, 4L, records[4]);
        reader.seek(50000000L);
        TestLobFile.assertFalse((String)"Found a record past expected end-of-file", (boolean)reader.next());
        reader.seek(offsets[8] + 32L);
        TestLobFile.assertFalse((String)"Found a record past beginning of index", (boolean)reader.next());
        reader.seek(offsets[8]);
        this.verifyNextRecord(reader, 8L, records[8]);
        reader.seek(offsets[8] - 3L);
        this.verifyNextRecord(reader, 8L, records[8]);
        reader.close();
    }

    private void verifyBlobRecord(LobFile.Reader reader, long expectedDeclaredLen, long expectedActualLen, int offset) throws Exception {
        TestLobFile.assertTrue((boolean)reader.next());
        TestLobFile.assertTrue((boolean)reader.isRecordAvailable());
        TestLobFile.assertEquals((long)expectedDeclaredLen, (long)reader.getRecordLen());
        InputStream is = reader.readBlobRecord();
        byte[] bytes = new byte[(int)expectedActualLen];
        int numRead = is.read(bytes);
        TestLobFile.assertEquals((long)expectedActualLen, (long)numRead);
        for (int i = 0; i < numRead; ++i) {
            TestLobFile.assertEquals((int)(i + offset), (int)bytes[i]);
        }
        is.close();
    }

    private void writeBlobRecord(LobFile.Writer writer, long declaredLen, long actualLen, int offset) throws Exception {
        OutputStream os = writer.writeBlobRecord(declaredLen);
        int i = 0;
        while ((long)i < actualLen) {
            os.write(i + offset);
            ++i;
        }
        os.close();
        writer.finishRecord();
    }

    private void verifyBlobRecords(Path p, int numRecords, long declaredLen, long actualLen) throws Exception {
        LobFile.Reader reader = LobFile.open((Path)p, (Configuration)this.conf);
        for (int i = 0; i < numRecords; ++i) {
            this.verifyBlobRecord(reader, declaredLen, actualLen, i);
        }
        TestLobFile.assertFalse((boolean)reader.next());
        reader.close();
    }

    public void testBinaryRecords() throws Exception {
        long RECORD_LEN = 32L;
        int NUM_RECORDS = 2;
        Path p = new Path(TEMP_BASE_DIR, "binary.lob");
        LobFile.Writer writer = LobFile.create((Path)p, (Configuration)this.conf);
        for (int i = 0; i < 2; ++i) {
            this.writeBlobRecord(writer, 32L, 32L, i);
        }
        writer.close();
        this.verifyBlobRecords(p, 2, 32L, 32L);
    }

    public void testOverLengthBinaryRecord() throws Exception {
        long ACTUAL_RECORD_LEN = 48L;
        long DECLARED_RECORD_LEN = 32L;
        int NUM_RECORDS = 2;
        Path p = new Path(TEMP_BASE_DIR, "overlength.lob");
        LobFile.Writer writer = LobFile.create((Path)p, (Configuration)this.conf);
        for (int i = 0; i < 2; ++i) {
            this.writeBlobRecord(writer, 32L, 48L, i);
        }
        writer.close();
        this.verifyBlobRecords(p, 2, 32L, 48L);
    }

    private void runCompressedTest(String codec) throws Exception {
        LOG.info((Object)("Testing with codec: " + codec));
        Path p = new Path(TEMP_BASE_DIR, "compressed-" + codec + ".lob");
        String[] records = new String[]{"this is the first record, It should be compressed a lot!", "record 2 record 2 record 2 record 2 2 2 2 2 2 2 2 2 2 2 2", "and a third and a third yes this is the third"};
        this.runClobFileTest(p, codec, records);
    }

    public void testCompressedFile() throws Exception {
        this.runCompressedTest(null);
        this.runCompressedTest("none");
        this.runCompressedTest("deflate");
        try {
            this.runCompressedTest("lzo");
            TestLobFile.fail((String)"Expected unsupported codec exception for lzo");
        }
        catch (UnsupportedCodecException uce) {
            LOG.info((Object)"Got unsupported codec exception for lzo; expected -- good.");
        }
    }

    static {
        String tmpDir = System.getProperty("test.build.data", "/tmp/");
        if (!tmpDir.endsWith(File.separator)) {
            tmpDir = tmpDir + File.separator;
        }
        TEMP_BASE_DIR = new Path(new Path(tmpDir), "lobtest");
    }
}

