/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.hbase;

import com.cloudera.sqoop.hbase.HBaseTestCase;
import java.io.IOException;
import org.junit.Test;

public class HBaseImportNullTest
extends HBaseTestCase {
    @Test
    public void testNullRow() throws IOException {
        String[] argv = this.getArgv(true, "nullRowT", "nullRowF", true, null);
        String[] types = new String[]{"INT", "INT"};
        String[] vals = new String[]{"0", "null"};
        this.createTableWithColTypes(types, vals);
        this.runImport(argv);
        this.verifyHBaseCell("nullRowT", "0", "nullRowF", this.getColName(1), null);
        int rowCount = this.countHBaseTable("nullRowT", "nullRowF");
        HBaseImportNullTest.assertEquals((int)0, (int)rowCount);
    }

    @Test
    public void testNulls() throws IOException {
        String[] argv = this.getArgv(true, "nullT", "nullF", true, null);
        String[] types = new String[]{"INT", "INT", "INT"};
        String[] vals = new String[]{"0", "42", "null"};
        this.createTableWithColTypes(types, vals);
        this.runImport(argv);
        this.verifyHBaseCell("nullT", "0", "nullF", this.getColName(1), "42");
        this.verifyHBaseCell("nullT", "0", "nullF", this.getColName(2), null);
    }
}

