/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.tool.ImportTool;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.lang.ArrayUtils;

public class TestSqoopOptions
extends TestCase {
    public void testNormalChar() throws Exception {
        TestSqoopOptions.assertEquals((char)'a', (char)SqoopOptions.toChar((String)"a"));
    }

    public void testEmptyString() throws Exception {
        try {
            SqoopOptions.toChar((String)"");
            TestSqoopOptions.fail((String)"Expected exception");
        }
        catch (SqoopOptions.InvalidOptionsException invalidOptionsException) {
            // empty catch block
        }
    }

    public void testNullString() throws Exception {
        try {
            SqoopOptions.toChar(null);
            TestSqoopOptions.fail((String)"Expected exception");
        }
        catch (SqoopOptions.InvalidOptionsException invalidOptionsException) {
            // empty catch block
        }
    }

    public void testTooLong() throws Exception {
        TestSqoopOptions.assertEquals((char)'x', (char)SqoopOptions.toChar((String)"xyz"));
    }

    public void testHexChar1() throws Exception {
        TestSqoopOptions.assertEquals((int)15, (int)SqoopOptions.toChar((String)"\\0xf"));
    }

    public void testHexChar2() throws Exception {
        TestSqoopOptions.assertEquals((int)15, (int)SqoopOptions.toChar((String)"\\0xF"));
    }

    public void testHexChar3() throws Exception {
        TestSqoopOptions.assertEquals((int)240, (int)SqoopOptions.toChar((String)"\\0xf0"));
    }

    public void testHexChar4() throws Exception {
        TestSqoopOptions.assertEquals((int)240, (int)SqoopOptions.toChar((String)"\\0Xf0"));
    }

    public void testEscapeChar1() throws Exception {
        TestSqoopOptions.assertEquals((char)'\n', (char)SqoopOptions.toChar((String)"\\n"));
    }

    public void testEscapeChar2() throws Exception {
        TestSqoopOptions.assertEquals((char)'\\', (char)SqoopOptions.toChar((String)"\\\\"));
    }

    public void testEscapeChar3() throws Exception {
        TestSqoopOptions.assertEquals((char)'\\', (char)SqoopOptions.toChar((String)"\\"));
    }

    public void testWhitespaceToChar() throws Exception {
        TestSqoopOptions.assertEquals((char)' ', (char)SqoopOptions.toChar((String)" "));
        TestSqoopOptions.assertEquals((char)' ', (char)SqoopOptions.toChar((String)"   "));
        TestSqoopOptions.assertEquals((char)'\t', (char)SqoopOptions.toChar((String)"\t"));
    }

    public void testUnknownEscape1() throws Exception {
        try {
            SqoopOptions.toChar((String)"\\Q");
            TestSqoopOptions.fail((String)"Expected exception");
        }
        catch (SqoopOptions.InvalidOptionsException invalidOptionsException) {
            // empty catch block
        }
    }

    public void testUnknownEscape2() throws Exception {
        try {
            SqoopOptions.toChar((String)"\\nn");
            TestSqoopOptions.fail((String)"Expected exception");
        }
        catch (SqoopOptions.InvalidOptionsException invalidOptionsException) {
            // empty catch block
        }
    }

    public void testEscapeNul1() throws Exception {
        TestSqoopOptions.assertEquals((char)'\u0000', (char)SqoopOptions.toChar((String)"\\0"));
    }

    public void testEscapeNul2() throws Exception {
        TestSqoopOptions.assertEquals((char)'\u0000', (char)SqoopOptions.toChar((String)"\\00"));
    }

    public void testEscapeNul3() throws Exception {
        TestSqoopOptions.assertEquals((char)'\u0000', (char)SqoopOptions.toChar((String)"\\0000"));
    }

    public void testEscapeNul4() throws Exception {
        TestSqoopOptions.assertEquals((char)'\u0000', (char)SqoopOptions.toChar((String)"\\0x0"));
    }

    public void testOctalChar1() throws Exception {
        TestSqoopOptions.assertEquals((int)4, (int)SqoopOptions.toChar((String)"\\04"));
    }

    public void testOctalChar2() throws Exception {
        TestSqoopOptions.assertEquals((int)37, (int)SqoopOptions.toChar((String)"\\045"));
    }

    public void testErrOctalChar() throws Exception {
        try {
            SqoopOptions.toChar((String)"\\095");
            TestSqoopOptions.fail((String)"Expected exception");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testErrHexChar() throws Exception {
        try {
            SqoopOptions.toChar((String)"\\0x9K5");
            TestSqoopOptions.fail((String)"Expected exception");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private SqoopOptions parse(String[] argv) throws Exception {
        ImportTool importTool = new ImportTool();
        return importTool.parseArguments(argv, null, null, false);
    }

    public void testDelimitersInherit() throws Exception {
        String[] args = new String[]{"--fields-terminated-by", "|"};
        SqoopOptions opts = this.parse(args);
        TestSqoopOptions.assertEquals((char)'|', (char)opts.getInputFieldDelim());
        TestSqoopOptions.assertEquals((char)'|', (char)opts.getOutputFieldDelim());
    }

    public void testDelimOverride1() throws Exception {
        String[] args = new String[]{"--fields-terminated-by", "|", "--input-fields-terminated-by", "*"};
        SqoopOptions opts = this.parse(args);
        TestSqoopOptions.assertEquals((char)'*', (char)opts.getInputFieldDelim());
        TestSqoopOptions.assertEquals((char)'|', (char)opts.getOutputFieldDelim());
    }

    public void testDelimOverride2() throws Exception {
        String[] args = new String[]{"--input-fields-terminated-by", "*", "--fields-terminated-by", "|"};
        SqoopOptions opts = this.parse(args);
        TestSqoopOptions.assertEquals((char)'*', (char)opts.getInputFieldDelim());
        TestSqoopOptions.assertEquals((char)'|', (char)opts.getOutputFieldDelim());
    }

    public void testBadNumMappers1() throws Exception {
        String[] args = new String[]{"--num-mappers", "x"};
        try {
            this.parse(args);
            TestSqoopOptions.fail((String)"Expected InvalidOptionsException");
        }
        catch (SqoopOptions.InvalidOptionsException invalidOptionsException) {
            // empty catch block
        }
    }

    public void testBadNumMappers2() throws Exception {
        String[] args = new String[]{"-m", "x"};
        try {
            this.parse(args);
            TestSqoopOptions.fail((String)"Expected InvalidOptionsException");
        }
        catch (SqoopOptions.InvalidOptionsException invalidOptionsException) {
            // empty catch block
        }
    }

    public void testGoodNumMappers() throws Exception {
        String[] args = new String[]{"-m", "4"};
        SqoopOptions opts = this.parse(args);
        TestSqoopOptions.assertEquals((int)4, (int)opts.getNumMappers());
    }

    public void testHivePartitionParams() throws Exception {
        String[] args = new String[]{"--hive-partition-key", "ds", "--hive-partition-value", "20110413"};
        SqoopOptions opts = this.parse(args);
        TestSqoopOptions.assertEquals((String)"ds", (String)opts.getHivePartitionKey());
        TestSqoopOptions.assertEquals((String)"20110413", (String)opts.getHivePartitionValue());
    }

    public void testBoundaryQueryParams() throws Exception {
        String[] args = new String[]{"--boundary-query", "select 1, 2"};
        SqoopOptions opts = this.parse(args);
        TestSqoopOptions.assertEquals((String)"select 1, 2", (String)opts.getBoundaryQuery());
    }

    public void testMapColumnHiveParams() throws Exception {
        String[] args = new String[]{"--map-column-hive", "id=STRING"};
        SqoopOptions opts = this.parse(args);
        Properties mapping = opts.getMapColumnHive();
        TestSqoopOptions.assertTrue((boolean)mapping.containsKey("id"));
        TestSqoopOptions.assertEquals((Object)"STRING", (Object)mapping.get("id"));
    }

    public void testMapColumnJavaParams() throws Exception {
        String[] args = new String[]{"--map-column-java", "id=String"};
        SqoopOptions opts = this.parse(args);
        Properties mapping = opts.getMapColumnJava();
        TestSqoopOptions.assertTrue((boolean)mapping.containsKey("id"));
        TestSqoopOptions.assertEquals((Object)"String", (Object)mapping.get("id"));
    }

    public void testPropertySerialization1() {
        SqoopOptions out = new SqoopOptions();
        out.setUsername("user");
        out.setConnectString("bla");
        out.setNumMappers(4);
        out.setAppendMode(true);
        out.setHBaseTable("hbasetable");
        out.setWarehouseDir("Warehouse");
        out.setClassName("someclass");
        out.setSplitByCol("somecol");
        out.setSqlQuery("the query");
        out.setPackageName("a.package");
        out.setHiveImport(true);
        out.setFetchSize(null);
        Properties connParams = new Properties();
        connParams.put("conn.timeout", "3000");
        connParams.put("conn.buffer_size", "256");
        connParams.put("conn.dummy", "dummy");
        connParams.put("conn.foo", "bar");
        out.setConnectionParams(connParams);
        Properties outProps = out.writeProperties();
        SqoopOptions in = new SqoopOptions();
        in.loadProperties(outProps);
        Properties inProps = in.writeProperties();
        TestSqoopOptions.assertEquals((String)"properties don't match", (Object)outProps, (Object)inProps);
        TestSqoopOptions.assertEquals((String)"connection params don't match", (Object)connParams, (Object)out.getConnectionParams());
        TestSqoopOptions.assertEquals((String)"connection params don't match", (Object)connParams, (Object)in.getConnectionParams());
    }

    public void testPropertySerialization2() {
        SqoopOptions out = new SqoopOptions();
        out.setUsername("user");
        out.setConnectString("bla");
        out.setNumMappers(4);
        out.setAppendMode(true);
        out.setHBaseTable("hbasetable");
        out.setWarehouseDir("Warehouse");
        out.setClassName("someclass");
        out.setSplitByCol("somecol");
        out.setSqlQuery("the query");
        out.setPackageName("a.package");
        out.setHiveImport(true);
        out.setFetchSize(Integer.valueOf(42));
        Properties connParams = new Properties();
        connParams.setProperty("a", "value-a");
        connParams.setProperty("b", "value-b");
        connParams.setProperty("a.b", "value-a.b");
        connParams.setProperty("a.b.c", "value-a.b.c");
        connParams.setProperty("aaaaaaaaaa.bbbbbbb.cccccccc", "value-abc");
        out.setConnectionParams(connParams);
        Properties outProps = out.writeProperties();
        SqoopOptions in = new SqoopOptions();
        in.loadProperties(outProps);
        Properties inProps = in.writeProperties();
        TestSqoopOptions.assertEquals((String)"properties don't match", (Object)outProps, (Object)inProps);
        TestSqoopOptions.assertEquals((String)"connection params don't match", (Object)connParams, (Object)out.getConnectionParams());
        TestSqoopOptions.assertEquals((String)"connection params don't match", (Object)connParams, (Object)in.getConnectionParams());
    }

    public void testHadoopHome() throws Exception {
        String[] args = new String[]{"--hadoop-home", "/usr/lib/hadoop"};
        SqoopOptions opts = this.parse(args);
        TestSqoopOptions.assertEquals((String)"/usr/lib/hadoop", (String)opts.getHadoopMapRedHome());
    }

    public void testHadoopMapRedOverridesHadoopHome() throws Exception {
        String[] args = new String[]{"--hadoop-home", "/usr/lib/hadoop-ignored", "--hadoop-mapred-home", "/usr/lib/hadoop"};
        SqoopOptions opts = this.parse(args);
        TestSqoopOptions.assertEquals((String)"/usr/lib/hadoop", (String)opts.getHadoopMapRedHome());
    }

    private void validateImportOptions(String[] extraArgs) throws Exception {
        Object[] args = new String[]{"--connect", HsqldbTestServer.getUrl(), "--table", "test", "-m", "1"};
        ImportTool importTool = new ImportTool();
        SqoopOptions opts = importTool.parseArguments((String[])ArrayUtils.addAll((Object[])args, (Object[])extraArgs), null, null, false);
        importTool.validateOptions(opts);
    }

    public void testDeteleTargetDir() throws Exception {
        String[] extraArgs = new String[]{"--delete-target-dir"};
        try {
            this.validateImportOptions(extraArgs);
        }
        catch (SqoopOptions.InvalidOptionsException ioe) {
            TestSqoopOptions.fail((String)("Unexpected InvalidOptionsException" + (Object)((Object)ioe)));
        }
    }

    public void testDeleteTargetDirWithAppend() throws Exception {
        String[] extraArgs = new String[]{"--append", "--delete-target-dir"};
        try {
            this.validateImportOptions(extraArgs);
            TestSqoopOptions.fail((String)"Expected InvalidOptionsException");
        }
        catch (SqoopOptions.InvalidOptionsException invalidOptionsException) {
            // empty catch block
        }
    }

    public void testDeleteWithIncrementalImport() throws Exception {
        String[] extraArgs = new String[]{"--incremental", "append", "--delete-target-dir"};
        try {
            this.validateImportOptions(extraArgs);
            TestSqoopOptions.fail((String)"Expected InvalidOptionsException");
        }
        catch (SqoopOptions.InvalidOptionsException invalidOptionsException) {
            // empty catch block
        }
    }
}

