/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.ConnFactory;
import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.manager.ManagerFactory;
import com.cloudera.sqoop.metastore.JobData;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.tool.SqoopTool;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;

public class TestConnFactory
extends TestCase {
    public void testCustomFactory() throws IOException {
        Configuration conf = new Configuration();
        conf.set("sqoop.connection.factories", AlwaysDummyFactory.class.getName());
        ConnFactory factory = new ConnFactory(conf);
        ConnManager manager = factory.getManager(new JobData(new SqoopOptions(), (SqoopTool)new ImportTool()));
        TestConnFactory.assertNotNull((String)"No manager returned", (Object)manager);
        TestConnFactory.assertTrue((String)"Expected a DummyManager", (boolean)(manager instanceof DummyManager));
    }

    public void testExceptionForNoManager() {
        Configuration conf = new Configuration();
        conf.set("sqoop.connection.factories", EmptyFactory.class.getName());
        ConnFactory factory = new ConnFactory(conf);
        try {
            factory.getManager(new JobData(new SqoopOptions(), (SqoopTool)new ImportTool()));
            TestConnFactory.fail((String)"factory.getManager() expected to throw IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testMultipleManagers() throws IOException {
        Configuration conf = new Configuration();
        String classNames = EmptyFactory.class.getName() + "," + AlwaysDummyFactory.class.getName();
        conf.set("sqoop.connection.factories", classNames);
        ConnFactory factory = new ConnFactory(conf);
        ConnManager manager = factory.getManager(new JobData(new SqoopOptions(), (SqoopTool)new ImportTool()));
        TestConnFactory.assertNotNull((String)"No manager returned", (Object)manager);
        TestConnFactory.assertTrue((String)"Expected a DummyManager", (boolean)(manager instanceof DummyManager));
    }

    public static class DummyManager
    extends ConnManager {
        public void close() {
        }

        public String[] listDatabases() {
            return null;
        }

        public String[] listTables() {
            return null;
        }

        public String[] getColumnNames(String tableName) {
            return null;
        }

        public String[] getColumnNamesForProcedure(String procedureName) {
            return null;
        }

        public String getPrimaryKey(String tableName) {
            return null;
        }

        public String toJavaType(int sqlType) {
            return null;
        }

        public String toHiveType(int sqlType) {
            return null;
        }

        public Map<String, Integer> getColumnTypes(String tableName) {
            return null;
        }

        public Map<String, Integer> getColumnTypesForProcedure(String procedureName) {
            return null;
        }

        public ResultSet readTable(String tableName, String[] columns) {
            return null;
        }

        public Connection getConnection() {
            return null;
        }

        public String getDriverClass() {
            return null;
        }

        public void execAndPrint(String s) {
        }

        public void importTable(ImportJobContext context) {
        }

        public void release() {
        }
    }

    public static class EmptyFactory
    extends ManagerFactory {
        public ConnManager accept(JobData data) {
            return null;
        }
    }

    public static class AlwaysDummyFactory
    extends ManagerFactory {
        public ConnManager accept(JobData data) {
            return new DummyManager();
        }
    }
}

