/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.Sqoop;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.tool.ExportTool;
import com.cloudera.sqoop.tool.SqoopTool;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;

public class TestAvroImportExportRoundtrip
extends ImportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)TestAvroImportExportRoundtrip.class.getName());

    public void testRoundtripQuery() throws IOException, SQLException {
        String[] argv = new String[]{};
        this.runImport(this.getOutputArgvForQuery(true));
        this.deleteTableData();
        this.runExport(this.getExportArgvForQuery(true, 10, 10, this.newStrArray(argv, "-m", "1")));
        this.checkFirstColumnSum();
    }

    public void testRoundtrip() throws IOException, SQLException {
        String[] argv = new String[]{};
        this.runImport(this.getOutputArgv(true));
        this.deleteTableData();
        this.runExport(this.getExportArgv(true, 10, 10, this.newStrArray(argv, "-m", "1")));
        this.checkFirstColumnSum();
    }

    protected String[] getOutputArgv(boolean includeHadoopFlags) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--table");
        args.add(HsqldbTestServer.getTableName());
        args.add("--connect");
        args.add(HsqldbTestServer.getUrl());
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--split-by");
        args.add("INTFIELD1");
        args.add("--as-avrodatafile");
        return args.toArray(new String[0]);
    }

    protected String[] getOutputArgvForQuery(boolean includeHadoopFlags) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--query");
        args.add("select * from " + HsqldbTestServer.getTableName() + " where $CONDITIONS");
        args.add("--connect");
        args.add(HsqldbTestServer.getUrl());
        args.add("--target-dir");
        args.add(this.getWarehouseDir() + "/query_result");
        args.add("--split-by");
        args.add("INTFIELD1");
        args.add("--as-avrodatafile");
        return args.toArray(new String[0]);
    }

    protected String[] getExportArgv(boolean includeHadoopFlags, int rowsPerStmt, int statementsPerTx, String ... additionalArgv) {
        ArrayList<String> args = this.formatAdditionalArgs(additionalArgv);
        args.add("--table");
        args.add(this.getTableName());
        args.add("--export-dir");
        args.add(this.getTablePath().toString());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("-m");
        args.add("1");
        LOG.debug((Object)"args:");
        for (String a : args) {
            LOG.debug((Object)("  " + a));
        }
        return args.toArray(new String[0]);
    }

    protected String[] getExportArgvForQuery(boolean includeHadoopFlags, int rowsPerStmt, int statementsPerTx, String ... additionalArgv) {
        ArrayList<String> args = this.formatAdditionalArgs(additionalArgv);
        args.add("--table");
        args.add(this.getTableName());
        args.add("--export-dir");
        args.add(this.getWarehouseDir() + "/query_result");
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("-m");
        args.add("1");
        LOG.debug((Object)"args:");
        for (String a : args) {
            LOG.debug((Object)("  " + a));
        }
        return args.toArray(new String[0]);
    }

    protected ArrayList<String> formatAdditionalArgs(String ... additionalArgv) {
        boolean prevIsFlag;
        ArrayList<String> args = new ArrayList<String>();
        if (null != additionalArgv) {
            prevIsFlag = false;
            for (String arg : additionalArgv) {
                if (arg.equals("-D")) {
                    args.add(arg);
                    prevIsFlag = true;
                    continue;
                }
                if (!prevIsFlag) continue;
                args.add(arg);
                prevIsFlag = false;
            }
        }
        if (null != additionalArgv) {
            prevIsFlag = false;
            for (String arg : additionalArgv) {
                if (arg.equals("-D")) {
                    prevIsFlag = true;
                    continue;
                }
                if (prevIsFlag) {
                    prevIsFlag = false;
                    continue;
                }
                args.add(arg);
            }
        }
        return args;
    }

    @Override
    protected String getTableName() {
        return HsqldbTestServer.getTableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTableData() throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement statement = conn.prepareStatement("DELETE FROM " + this.getTableName(), 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    protected List<String> runExport(String[] argv) throws IOException {
        int ret;
        List generatedJars = null;
        try {
            ExportTool exporter = new ExportTool();
            Sqoop sqoop = new Sqoop((SqoopTool)exporter);
            ret = Sqoop.runSqoop((Sqoop)sqoop, (String[])argv);
            generatedJars = exporter.getGeneratedJarFiles();
        }
        catch (Exception e) {
            LOG.error((Object)("Got exception running Sqoop: " + StringUtils.stringifyException((Throwable)e)));
            ret = 1;
        }
        if (0 != ret) {
            throw new IOException("Failure during job; return status " + ret);
        }
        return generatedJars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFirstColumnSum() throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement statement = conn.prepareStatement("SELECT SUM(INTFIELD1) FROM " + this.getTableName(), 1003, 1007);
        int actualVal = 0;
        try {
            ResultSet rs = statement.executeQuery();
            try {
                rs.next();
                actualVal = rs.getInt(1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            statement.close();
        }
        TestAvroImportExportRoundtrip.assertEquals((String)"First column column sum", (int)HsqldbTestServer.getFirstColSum(), (int)actualVal);
    }
}

