/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.sqlserver;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.testutil.ManagerCompatTestCase;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.manager.sqlserver.MSSQLTestData;
import org.apache.sqoop.manager.sqlserver.MSSQLTestDataFileParser;
import org.apache.sqoop.manager.sqlserver.MSSQLTestUtils;
import org.junit.Test;

public class SQLServerDatatypeImportSequenceFileManualTest
extends ManagerCompatTestCase {
    public static final Log LOG = LogFactory.getLog((String)SQLServerDatatypeImportSequenceFileManualTest.class.getName());
    private static MSSQLTestDataFileParser tdfs;
    private static Map report;

    @Override
    protected String getDbFriendlyName() {
        return "MSSQL";
    }

    @Override
    protected Log getLogger() {
        return LOG;
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getConnectString() {
        return System.getProperty("sqoop.test.sqlserver.connectstring.host_url", "jdbc:sqlserver://sqlserverhost:1433");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTableIfExists(String table) throws SQLException {
        Connection conn = this.getManager().getConnection();
        String sqlStmt = "IF OBJECT_ID('" + table + "') IS NOT NULL  DROP TABLE " + table;
        PreparedStatement statement = conn.prepareStatement(sqlStmt, 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    @Override
    protected SqoopOptions getSqoopOptions(Configuration conf) {
        String username = MSSQLTestUtils.getDBUserName();
        String password = MSSQLTestUtils.getDBPassWord();
        SqoopOptions opts = new SqoopOptions(conf);
        opts.setUsername(username);
        opts.setPassword(password);
        return opts;
    }

    @Override
    public void setUp() {
        try {
            super.setUp();
        }
        catch (Exception e) {
            try {
                FileWriter fr = new FileWriter(this.getResportFileName(), true);
                String res = SQLServerDatatypeImportSequenceFileManualTest.removeNewLines(e.getMessage());
                fr.append("Error\t" + res + "\n");
                fr.close();
            }
            catch (Exception e2) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e2));
                SQLServerDatatypeImportSequenceFileManualTest.fail((String)e2.toString());
            }
        }
        catch (Error e) {
            try {
                FileWriter fr = new FileWriter(this.getResportFileName(), true);
                String res = SQLServerDatatypeImportSequenceFileManualTest.removeNewLines(e.getMessage());
                fr.append("Error\t" + res + "\n");
                fr.close();
                SQLServerDatatypeImportSequenceFileManualTest.fail((String)res);
            }
            catch (Exception e2) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e2));
                SQLServerDatatypeImportSequenceFileManualTest.fail((String)e2.toString());
            }
        }
    }

    @Override
    public void tearDown() {
        try {
            super.tearDown();
        }
        catch (Exception e) {
            try {
                FileWriter fr = new FileWriter(this.getResportFileName(), true);
                String res = SQLServerDatatypeImportSequenceFileManualTest.removeNewLines(e.getMessage());
                fr.append("Error\t" + res + "\n");
                fr.close();
            }
            catch (Exception e2) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e2));
                SQLServerDatatypeImportSequenceFileManualTest.fail((String)e2.toString());
            }
        }
        catch (Error e) {
            try {
                FileWriter fr = new FileWriter(this.getResportFileName(), true);
                String res = SQLServerDatatypeImportSequenceFileManualTest.removeNewLines(e.getMessage());
                fr.append("Error\t" + res + "\n");
                fr.close();
                SQLServerDatatypeImportSequenceFileManualTest.fail((String)res);
            }
            catch (Exception e2) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e2));
                SQLServerDatatypeImportSequenceFileManualTest.fail((String)e2.toString());
            }
        }
    }

    @Override
    protected boolean supportsBoolean() {
        return true;
    }

    @Test
    public void testBit() {
        if (!this.supportsBoolean()) {
            this.skipped = true;
            return;
        }
        this.verifyType("BIT", this.getTrueBoolNumericSqlInput(), this.getTrueBoolSeqOutput());
    }

    @Test
    public void testBit2() {
        if (!this.supportsBoolean()) {
            this.skipped = true;
            return;
        }
        this.verifyType("BIT", this.getFalseBoolNumericSqlInput(), this.getFalseBoolSeqOutput());
    }

    @Test
    public void testBit3() {
        if (!this.supportsBoolean()) {
            this.skipped = true;
            return;
        }
        this.verifyType("BIT", this.getFalseBoolLiteralSqlInput(), this.getFalseBoolSeqOutput());
    }

    @Override
    public void testBoolean() {
        try {
            super.testBoolean();
            SQLServerDatatypeImportSequenceFileManualTest.assertTrue((String)"This test should not pass on sql server", (boolean)false);
        }
        catch (AssertionError a) {
            System.out.println("Test failed, this was expected");
        }
    }

    @Override
    public void testBoolean2() {
        try {
            super.testBoolean2();
            SQLServerDatatypeImportSequenceFileManualTest.assertTrue((String)"This test should not pass on sql server", (boolean)false);
        }
        catch (AssertionError a) {
            System.out.println("Test failed, this was expected");
        }
    }

    @Override
    public void testBoolean3() {
        try {
            super.testBoolean3();
            SQLServerDatatypeImportSequenceFileManualTest.assertTrue((String)"This test should not pass on sql server", (boolean)false);
        }
        catch (AssertionError a) {
            System.out.println("Test failed, this was expected");
        }
    }

    @Override
    public void testDouble1() {
        try {
            super.testDouble1();
            SQLServerDatatypeImportSequenceFileManualTest.assertTrue((String)"This test should not pass on sql server", (boolean)false);
        }
        catch (AssertionError a) {
            System.out.println("Test failed, this was expected");
        }
    }

    @Override
    @Test
    public void testDouble2() {
        try {
            super.testDouble2();
            SQLServerDatatypeImportSequenceFileManualTest.assertTrue((String)"This test should not pass on sql server", (boolean)false);
        }
        catch (AssertionError a) {
            System.out.println("Test failed, this was expected");
        }
    }

    @Override
    public void testClob1() {
        try {
            super.testClob1();
            SQLServerDatatypeImportSequenceFileManualTest.assertTrue((String)"This test should not pass on sql server", (boolean)false);
        }
        catch (AssertionError a) {
            System.out.println("Test failed, this was expected");
        }
    }

    @Override
    public void testBlob1() {
        try {
            super.testBlob1();
            SQLServerDatatypeImportSequenceFileManualTest.assertTrue((String)"This test should not pass on sql server", (boolean)false);
        }
        catch (AssertionError a) {
            System.out.println("Test failed, this was expected");
        }
    }

    @Override
    public void testLongVarChar() {
        try {
            super.testLongVarChar();
            SQLServerDatatypeImportSequenceFileManualTest.assertTrue((String)"This test should not pass on sql server", (boolean)false);
        }
        catch (AssertionError a) {
            System.out.println("Test failed, this was expected");
        }
    }

    @Override
    public void testTimestamp1() {
        try {
            super.testTimestamp1();
            SQLServerDatatypeImportSequenceFileManualTest.assertTrue((String)"This test should not pass on sql server", (boolean)false);
        }
        catch (AssertionError a) {
            System.out.println("Test failed, this was expected");
        }
    }

    @Override
    public void testTimestamp2() {
        try {
            super.testTimestamp2();
            SQLServerDatatypeImportSequenceFileManualTest.assertTrue((String)"This test should not pass on sql server", (boolean)false);
        }
        catch (AssertionError a) {
            System.out.println("Test failed, this was expected");
        }
    }

    @Override
    public void testTimestamp3() {
        try {
            super.testTimestamp3();
            SQLServerDatatypeImportSequenceFileManualTest.assertTrue((String)"This test should not pass on sql server", (boolean)false);
        }
        catch (AssertionError a) {
            System.out.println("Test failed, this was expected");
        }
    }

    @Override
    public void testVarBinary() {
        if (!this.supportsVarBinary()) {
            return;
        }
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.VARBINARY);
    }

    public void testTime() {
        if (!this.supportsTime()) {
            this.skipped = true;
            return;
        }
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.TIME);
    }

    @Test
    public void testSmalldatetime() {
        if (!this.supportsTime()) {
            this.skipped = true;
            return;
        }
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.SMALLDATETIME);
    }

    @Test
    public void testdatetime2() {
        if (!this.supportsTime()) {
            this.skipped = true;
            return;
        }
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.DATETIME2);
    }

    @Test
    public void testdatetime() {
        if (!this.supportsTime()) {
            this.skipped = true;
            return;
        }
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.DATETIME);
    }

    @Test
    public void testdatetimeoffset() {
        if (!this.supportsTime()) {
            this.skipped = true;
            return;
        }
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.DATETIMEOFFSET);
    }

    public void testDecimal() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.DECIMAL);
    }

    public void testNumeric() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.NUMERIC);
    }

    @Override
    public void testNumeric1() {
    }

    @Override
    public void testNumeric2() {
    }

    @Override
    public void testDecimal1() {
    }

    @Override
    public void testDecimal2() {
    }

    @Test
    public void testBigInt() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.BIGINT);
    }

    @Override
    @Test
    public void testBigInt1() {
    }

    @Override
    @Test
    public void testInt() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.INT);
    }

    @Test
    public void testSmallInt() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.SMALLINT);
    }

    @Override
    @Test
    public void testSmallInt1() {
    }

    @Override
    @Test
    public void testSmallInt2() {
    }

    @Test
    public void testTinyint() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.TINYINT);
    }

    @Override
    @Test
    public void testTinyInt1() {
    }

    @Override
    @Test
    public void testTinyInt2() {
    }

    @Test
    public void testFloat() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.FLOAT);
    }

    @Test
    public void testReal() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.REAL);
    }

    @Test
    public void testDate() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.DATE);
    }

    public void testMoney() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.MONEY);
    }

    @Test
    public void testSmallMoney() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.SMALLMONEY);
    }

    @Test
    public void testText() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.TEXT);
    }

    @Test
    public void testVarchar() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.VARCHAR);
    }

    @Test
    public void testChar() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.CHAR);
    }

    @Test
    public void testNText() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.NTEXT);
    }

    @Test
    public void testNChar() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.NCHAR);
    }

    @Test
    public void testNVarchar() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.NVARCHAR);
    }

    public void testImage() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.IMAGE);
    }

    public void testBinary() {
        this.dataTypeTest(MSSQLTestDataFileParser.DATATYPES.BINARY);
    }

    @Override
    @Test
    public void testTime1() {
    }

    @Override
    @Test
    public void testTime2() {
    }

    @Override
    @Test
    public void testTime3() {
    }

    @Override
    @Test
    public void testTime4() {
    }

    @Override
    @Test
    public void testStringCol1() {
    }

    @Override
    @Test
    public void testStringCol2() {
    }

    @Override
    @Test
    public void testEmptyStringCol() {
    }

    @Override
    @Test
    public void testNullStringCol() {
    }

    @Override
    @Test
    public void testNullInt() {
    }

    @Override
    @Test
    public void testReal1() {
    }

    @Override
    @Test
    public void testReal2() {
    }

    @Override
    @Test
    public void testFloat1() {
    }

    @Override
    @Test
    public void testFloat2() {
    }

    @Override
    @Test
    public void testDate1() {
    }

    @Override
    @Test
    public void testDate2() {
    }

    @Override
    @Test
    public void testNumeric3() {
    }

    @Override
    @Test
    public void testNumeric4() {
    }

    @Override
    @Test
    public void testNumeric5() {
    }

    @Override
    @Test
    public void testNumeric6() {
    }

    @Override
    @Test
    public void testDecimal3() {
    }

    @Override
    @Test
    public void testDecimal4() {
    }

    @Override
    @Test
    public void testDecimal5() {
    }

    @Override
    @Test
    public void testDecimal6() {
    }

    public String getTrueBoolDbOutput() {
        return "1";
    }

    public String getFalseBoolDbOutput() {
        return "0";
    }

    @Override
    protected String getFalseBoolSeqOutput() {
        return "false";
    }

    @Override
    protected String getFalseBoolLiteralSqlInput() {
        return "0";
    }

    @Override
    protected String getFixedCharSeqOut(int len, String val) {
        return val + this.nSpace(len - val.length());
    }

    protected String getFixedCharDbOut(int len, String val) {
        return val + this.nSpace(len - val.length());
    }

    public String nSpace(int n) {
        String tmp = "";
        for (int i = 0; i < n; ++i) {
            tmp = tmp + " ";
        }
        return tmp;
    }

    public String nZeros(int n) {
        String tmp = "";
        for (int i = 0; i < n; ++i) {
            tmp = tmp + "0";
        }
        return tmp;
    }

    public void dataTypeTest(MSSQLTestDataFileParser.DATATYPES datatype) {
        int exceptionCount = 0;
        List testdata = tdfs.getTestdata(datatype);
        for (MSSQLTestData current : testdata) {
            System.out.println("Testing with : \n" + current);
            try {
                if (datatype == MSSQLTestDataFileParser.DATATYPES.DECIMAL || datatype == MSSQLTestDataFileParser.DATATYPES.NUMERIC) {
                    this.verifyType(current.getDatatype() + "(" + current.getData(MSSQLTestData.KEY_STRINGS.SCALE) + "," + current.getData(MSSQLTestData.KEY_STRINGS.PREC) + ")", current.getData(MSSQLTestData.KEY_STRINGS.TO_INSERT), current.getData(MSSQLTestData.KEY_STRINGS.HDFS_READBACK));
                } else if (datatype == MSSQLTestDataFileParser.DATATYPES.TIME || datatype == MSSQLTestDataFileParser.DATATYPES.SMALLDATETIME || datatype == MSSQLTestDataFileParser.DATATYPES.DATETIME2 || datatype == MSSQLTestDataFileParser.DATATYPES.DATETIME || datatype == MSSQLTestDataFileParser.DATATYPES.DATETIMEOFFSET || datatype == MSSQLTestDataFileParser.DATATYPES.TEXT || datatype == MSSQLTestDataFileParser.DATATYPES.NTEXT || datatype == MSSQLTestDataFileParser.DATATYPES.DATE) {
                    this.verifyType(current.getDatatype(), "'" + current.getData(MSSQLTestData.KEY_STRINGS.TO_INSERT) + "'", current.getData(MSSQLTestData.KEY_STRINGS.HDFS_READBACK));
                } else if (datatype == MSSQLTestDataFileParser.DATATYPES.VARBINARY) {
                    this.verifyType(current.getDatatype() + "(" + current.getData(MSSQLTestData.KEY_STRINGS.SCALE) + ")", "cast('" + current.getData(MSSQLTestData.KEY_STRINGS.TO_INSERT) + "' as varbinary(" + current.getData(MSSQLTestData.KEY_STRINGS.SCALE) + "))", current.getData(MSSQLTestData.KEY_STRINGS.HDFS_READBACK));
                } else if (datatype == MSSQLTestDataFileParser.DATATYPES.BINARY) {
                    this.verifyType(current.getDatatype() + "(" + current.getData(MSSQLTestData.KEY_STRINGS.SCALE) + ")", "cast('" + current.getData(MSSQLTestData.KEY_STRINGS.TO_INSERT) + "' as binary(" + current.getData(MSSQLTestData.KEY_STRINGS.SCALE) + "))", current.getData(MSSQLTestData.KEY_STRINGS.HDFS_READBACK));
                } else if (datatype == MSSQLTestDataFileParser.DATATYPES.NCHAR || datatype == MSSQLTestDataFileParser.DATATYPES.VARCHAR || datatype == MSSQLTestDataFileParser.DATATYPES.CHAR || datatype == MSSQLTestDataFileParser.DATATYPES.NVARCHAR) {
                    System.out.println("------>" + current.getData(MSSQLTestData.KEY_STRINGS.DB_READBACK) + "<----");
                    this.verifyType(current.getDatatype() + "(" + current.getData(MSSQLTestData.KEY_STRINGS.SCALE) + ")", "'" + current.getData(MSSQLTestData.KEY_STRINGS.TO_INSERT) + "'", current.getData(MSSQLTestData.KEY_STRINGS.HDFS_READBACK));
                } else if (datatype == MSSQLTestDataFileParser.DATATYPES.IMAGE) {
                    this.verifyType(current.getDatatype(), "cast('" + current.getData(MSSQLTestData.KEY_STRINGS.TO_INSERT) + "' as image )", current.getData(MSSQLTestData.KEY_STRINGS.HDFS_READBACK));
                } else {
                    this.verifyType(current.getDatatype(), current.getData(MSSQLTestData.KEY_STRINGS.TO_INSERT), current.getData(MSSQLTestData.KEY_STRINGS.HDFS_READBACK));
                }
                this.addToReport(current, null);
            }
            catch (AssertionError ae) {
                if (current.getData(MSSQLTestData.KEY_STRINGS.NEG_POS_FLAG).equals("NEG")) {
                    System.out.println("failure was expected, PASS");
                    this.addToReport(current, null);
                    continue;
                }
                System.out.println("-----------------------------------------------------------");
                System.out.println("Failure for following Test Data :\n" + current.toString());
                System.out.println("-----------------------------------------------------------");
                System.out.println("Exception details : \n");
                System.out.println(((Throwable)((Object)ae)).getMessage());
                System.out.println("-----------------------------------------------------------");
                this.addToReport(current, ae);
                ++exceptionCount;
            }
            catch (Exception e) {
                this.addToReport(current, e);
                ++exceptionCount;
            }
        }
        if (exceptionCount > 0) {
            System.out.println("There were failures for :" + datatype.toString());
            System.out.println("Failed for " + exceptionCount + " test data samples\n");
            System.out.println("Sroll up for detailed errors");
            System.out.println("-----------------------------------------------------------");
            throw new AssertionError((Object)("Failed for " + exceptionCount + " test data sample"));
        }
    }

    public synchronized void addToReport(MSSQLTestData td, Object result) {
        System.out.println("called");
        try {
            FileWriter fr = new FileWriter(this.getResportFileName(), true);
            String offset = td.getData(MSSQLTestData.KEY_STRINGS.OFFSET);
            String res = "_";
            if (result == null) {
                res = "Success";
            } else {
                try {
                    res = "FAILED " + SQLServerDatatypeImportSequenceFileManualTest.removeNewLines(((Throwable)((Object)((AssertionError)result))).getMessage());
                }
                catch (Exception ae) {
                    res = result instanceof Exception && (Exception)result != null ? "FAILED " + SQLServerDatatypeImportSequenceFileManualTest.removeNewLines(((Exception)result).getMessage()) : "FAILED " + result.toString();
                }
            }
            fr.append(offset + "\t" + res + "\n");
            fr.close();
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
        }
    }

    public static String removeNewLines(String str) {
        String[] tmp = str.split("\n");
        String result = "";
        for (String a : tmp) {
            result = result + " " + a;
        }
        return result;
    }

    public String getResportFileName() {
        return ((Object)((Object)this)).getClass().toString() + ".txt";
    }

    static {
        try {
            String testfile = null;
            testfile = System.getProperty("test.data.dir") + "/" + System.getProperty("ms.datatype.test.data.file.import");
            String delim = System.getProperty("ms.datatype.test.data.file.delim", ",");
            System.out.println("Using data file : " + testfile);
            LOG.info((Object)("Using data file : " + testfile));
            tdfs = new MSSQLTestDataFileParser(testfile);
            tdfs.setDelim(delim);
            tdfs.parse();
            report = new HashMap();
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            System.out.println("Error with test data file, check stack trace for cause.\nTests cannont continue.");
            System.exit(0);
        }
    }
}

