/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.sqlserver;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;

public class MSSQLTestUtils {
    public static final Log LOG = LogFactory.getLog((String)MSSQLTestUtils.class.getName());
    static final String DATABASE_USER = System.getProperty("ms.sqlserver.username", "SQOOPUSER");
    static final String DATABASE_PASSWORD = System.getProperty("ms.sqlserver.password", "PASSWORD");
    public static final String HOST_URL = System.getProperty("sqoop.test.sqlserver.connectstring.host_url", "jdbc:sqlserver://sqlserverhost:1433");
    public static final String CREATE_TALBE_LINEITEM = "CREATE TABLE TPCH1M_LINEITEM( [L_ORDERKEY] [int] NULL, [L_PARTKEY] [int] NULL, [L_SUPPKEY] [int] NULL, [L_LINENUMBER] [int] NULL, [L_QUANTITY] [int] NULL, [L_EXTENDEDPRICE] [decimal](15, 2) NULL, [L_DISCOUNT] [decimal](15, 2) NULL, [L_TAX] [decimal](15, 2) NULL, [L_RETURNFLAG] [varchar](max) NULL, [L_LINESTATUS] [varchar](max) NULL, [L_SHIPDATE] [varchar](max) NULL, [L_COMMITDATE] [varchar](max) NULL, [L_RECEIPTDATE] [varchar](max) NULL, [L_SHIPINSTRUCT] [varchar](max) NULL, [L_SHIPMODE] [varchar](max) NULL, [L_COMMENT] [varchar](max) NULL) ";
    private Connection conn = null;

    private Connection getConnection() {
        if (this.conn == null) {
            try {
                Connection con;
                this.conn = con = DriverManager.getConnection(HOST_URL, DATABASE_USER, DATABASE_PASSWORD);
                return con;
            }
            catch (SQLException e) {
                LOG.error((Object)("Get SQLException during setting up connection: " + StringUtils.stringifyException((Throwable)e)));
                return null;
            }
        }
        return this.conn;
    }

    public void createTableFromSQL(String sql) throws SQLException {
        Connection dbcon = this.getConnection();
        System.out.println("SQL : " + sql);
        this.dropTableIfExists("TPCH1M_LINEITEM");
        try {
            Statement st = dbcon.createStatement();
            int res = st.executeUpdate(sql);
            System.out.println("Result : " + res);
        }
        catch (SQLException e) {
            LOG.error((Object)("Got SQLException during creating table: " + StringUtils.stringifyException((Throwable)e)));
        }
    }

    public void populateLineItem() {
        String sql = "insert into tpch1m_lineitem values (1,2,3,4,5,6,7,8,'AB','CD','abcd','efgh','hijk','dothis','likethis','nocomments')";
        String sql2 = "insert into tpch1m_lineitem values (2,3,4,5,6,7,8,9,'AB','CD','abcd','efgh','hijk','dothis','likethis','nocomments')";
        String sql3 = "insert into tpch1m_lineitem values (3,4,5,6,7,8,9,10,'AB','CD','abcd','efgh','hijk','dothis','likethis','nocomments')";
        String sql4 = "insert into tpch1m_lineitem values (4,5,6,7,8,9,10,11,'AB','CD','abcd','efgh','hijk','dothis','likethis','nocomments')";
        Connection dbcon = this.getConnection();
        try {
            Statement st = dbcon.createStatement();
            st.addBatch(sql);
            st.addBatch(sql2);
            st.addBatch(sql3);
            st.addBatch(sql4);
            int[] res = st.executeBatch();
            System.out.println(res);
        }
        catch (SQLException e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
        }
    }

    public void metadataStuff(String table) {
        Connection dbcon = this.getConnection();
        String sql = "select top 1 * from " + table;
        try {
            Statement st = dbcon.createStatement();
            ResultSet rs = st.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                System.out.println(rsmd.getColumnName(i) + "\t" + rsmd.getColumnClassName(i) + "\t" + rsmd.getColumnType(i) + "\t" + rsmd.getColumnTypeName(i) + "\n");
            }
        }
        catch (SQLException e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
        }
    }

    public static String getDBUserName() {
        return DATABASE_USER;
    }

    public static String getDBPassWord() {
        return DATABASE_PASSWORD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTableIfExists(String table) throws SQLException {
        this.conn = this.getConnection();
        System.out.println("Dropping table : " + table);
        String sqlStmt = "IF OBJECT_ID('" + table + "') IS NOT NULL  DROP TABLE " + table;
        PreparedStatement statement = this.conn.prepareStatement(sqlStmt, 1003, 1007);
        try {
            statement.executeUpdate();
            this.conn.commit();
        }
        finally {
            statement.close();
        }
    }

    public static String[] getColumns() {
        return new String[]{"L_ORDERKEY", "L_PARTKEY", "L_SUPPKEY", "L_LINENUMBER", "L_QUANTITY", "L_EXTENDEDPRICE", "L_DISCOUNT", "L_TAX", "L_RETURNFLAG", "L_LINESTATUS", "L_SHIPDATE", "L_COMMITDATE", "L_RECEIPTDATE", "L_SHIPINSTRUCT", "L_SHIPMODE", "L_COMMENT"};
    }
}

