/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.OracleUtils;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;

public class OracleIncrementalImportTest
extends ImportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)OracleIncrementalImportTest.class.getName());
    private List<String> tableNames;

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getConnectString() {
        return OracleUtils.CONNECT_STRING;
    }

    @Override
    protected SqoopOptions getSqoopOptions(Configuration conf) {
        SqoopOptions opts = new SqoopOptions(conf);
        OracleUtils.setOracleAuth(opts);
        return opts;
    }

    @Override
    protected void dropTableIfExists(String table) throws SQLException {
        OracleUtils.dropTable(table, this.getManager());
    }

    @Override
    public void tearDown() {
        for (String tableName : this.tableNames) {
            try {
                this.dropTableIfExists(tableName);
            }
            catch (SQLException e) {
                LOG.warn((Object)("Error trying to drop table '" + tableName + "' on tearDown: " + e));
            }
        }
        super.tearDown();
    }

    protected String[] getArgv(String tableName, String connPropsFileName, String checkColumnName) {
        ArrayList<String> args = new ArrayList<String>();
        CommonArgs.addHadoopFlags(args);
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--target-dir");
        args.add(this.getWarehouseDir());
        args.add("--num-mappers");
        args.add("1");
        args.add("--table");
        args.add(tableName);
        args.add("--incremental");
        args.add("lastmodified");
        args.add("--check-column");
        args.add(checkColumnName);
        args.add("--last-value");
        args.add("2000-01-01 01:01:01.0");
        args.add("--connection-param-file");
        args.add(connPropsFileName);
        return args.toArray(new String[0]);
    }

    public void testIncrementalImportWithLastModified() throws IOException {
        this.tableNames = new ArrayList<String>();
        String[] types = new String[]{"INT", "VARCHAR(10)", "DATE"};
        String[] vals = new String[]{"1", "'old_data'", "TO_DATE('1999-01-01 11:11:11', 'YYYY-MM-DD HH24:MI:SS')", "2", "'new_data'", "TO_DATE('2000-11-11 23:23:23', 'YYYY-MM-DD HH24:MI:SS')"};
        String tableName = this.getTableName();
        this.tableNames.add(tableName);
        this.createTableWithColTypes(types, vals);
        String connPropsFileName = "connection.properties";
        this.createFileWithContent(connPropsFileName, "oracle.jdbc.mapDateToTimestamp=false");
        String[] args = this.getArgv(tableName, connPropsFileName, this.getColName(2));
        this.runImport(args);
        Path warehousePath = new Path(this.getWarehouseDir());
        Path filePath = new Path(warehousePath, "part-m-00000");
        String output = this.readLineFromPath(filePath);
        String expectedVal = "2,new_data,2000-11-11";
        OracleIncrementalImportTest.assertEquals((String)"Incremental import result expected a different string", (String)expectedVal, (String)output);
    }

    private void createFileWithContent(String connPropsFileName, String fileContent) throws IOException {
        File file = new File(connPropsFileName);
        if (file.exists()) {
            file.delete();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(connPropsFileName));
        writer.write(fileContent);
        ((Writer)writer).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLineFromPath(Path filePath) throws IOException {
        BufferedReader reader = null;
        if (!OracleIncrementalImportTest.isOnPhysicalCluster()) {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(filePath.toString()))));
        } else {
            FileSystem dfs = FileSystem.get((Configuration)this.getConf());
            FSDataInputStream dis = dfs.open(filePath);
            reader = new BufferedReader(new InputStreamReader((InputStream)dis));
        }
        String line = null;
        try {
            line = reader.readLine();
        }
        finally {
            IOUtils.closeStream((Closeable)reader);
        }
        return line;
    }
}

