/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.OracleUtils;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ExportJobTestCase;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class OracleCallExportTest
extends ExportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)OracleCallExportTest.class.getName());
    private final String tableName = "ORACLE_CALL_EXPORT_BASE_TABLE";
    private final String procName = "ORACLE_CALL_EXPORT_PROC";

    @Override
    public void setUp() {
        super.setUp();
        this.createObjects();
    }

    private String[] getArgv(String ... extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        CommonArgs.addHadoopFlags(args);
        args.add("--call");
        args.add("ORACLE_CALL_EXPORT_PROC");
        args.add("--export-dir");
        args.add(this.getWarehouseDir());
        args.add("--fields-terminated-by");
        args.add(",");
        args.add("--lines-terminated-by");
        args.add("\\n");
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--username");
        args.add("SQOOPTEST");
        args.add("--password");
        args.add("12345");
        args.add("-m");
        args.add("1");
        for (String arg : extraArgs) {
            args.add(arg);
        }
        return args.toArray(new String[0]);
    }

    private void createObjects() {
        String createTableSql = "CREATE TABLE ORACLE_CALL_EXPORT_BASE_TABLE ( id  INT NOT NULL PRIMARY KEY, msg VARCHAR(24) NOT NULL, d DATE, f FLOAT, vc VARCHAR(32))";
        String createProcSql = "CREATE PROCEDURE ORACLE_CALL_EXPORT_PROC ( id IN INT,msg IN VARCHAR,d IN DATE,f IN FLOAT) IS BEGIN INSERT INTO ORACLE_CALL_EXPORT_BASE_TABLE VALUES(id,msg,d,f,msg || '_2'); END;";
        try {
            this.dropTableIfExists("ORACLE_CALL_EXPORT_BASE_TABLE");
            this.dropProcedureIfExists("ORACLE_CALL_EXPORT_PROC");
        }
        catch (SQLException sqle) {
            throw new AssertionError((Object)sqle.getMessage());
        }
        Connection conn = this.getConnection();
        try {
            Statement st = conn.createStatement();
            st.executeUpdate(createTableSql);
            LOG.debug((Object)"Successfully created table ORACLE_CALL_EXPORT_BASE_TABLE");
            st.executeUpdate(createProcSql);
            LOG.debug((Object)"Successfully created procedure ORACLE_CALL_EXPORT_PROC");
            st.close();
        }
        catch (SQLException sqle) {
            throw new AssertionError((Object)sqle.getMessage());
        }
    }

    @Override
    protected Connection getConnection() {
        try {
            return this.getManager().getConnection();
        }
        catch (SQLException sqle) {
            throw new AssertionError((Object)sqle.getMessage());
        }
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getConnectString() {
        return OracleUtils.CONNECT_STRING;
    }

    @Override
    protected SqoopOptions getSqoopOptions(Configuration conf) {
        SqoopOptions opts = new SqoopOptions(conf);
        opts.setUsername("SQOOPTEST");
        opts.setPassword("12345");
        return opts;
    }

    @Override
    protected String getTableName() {
        return "ORACLE_CALL_EXPORT_BASE_TABLE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTableIfExists(String table) throws SQLException {
        Connection conn = this.getManager().getConnection();
        PreparedStatement statement = conn.prepareStatement("DROP TABLE " + table, 1003, 1007);
        try {
            try {
                statement.executeUpdate();
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropProcedureIfExists(String proc) throws SQLException {
        Connection conn = this.getManager().getConnection();
        PreparedStatement statement = conn.prepareStatement("DROP PROCEDURE " + proc, 1003, 1007);
        try {
            try {
                statement.executeUpdate();
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    public void testExportUsingProcedure() throws IOException, SQLException {
        String[] lines = new String[]{"0,textfield0,2002-12-29 08:40:00,3300", "1,textfield1,2007-06-04 13:15:10,4400"};
        new File(this.getWarehouseDir()).mkdirs();
        File file = new File(this.getWarehouseDir() + "/part-00000");
        BufferedWriter output = new BufferedWriter(new FileWriter(file));
        for (String line : lines) {
            output.write(line);
            output.write("\n");
        }
        ((Writer)output).close();
        this.runExport(this.getArgv(new String[0]));
        this.verifyExport(2, this.getConnection());
    }
}

