/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hcat;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.tool.ExportTool;
import com.cloudera.sqoop.tool.ImportTool;
import junit.framework.TestCase;
import org.junit.Before;

public class TestHCatalogBasic
extends TestCase {
    private static ImportTool importTool;
    private static ExportTool exportTool;

    @Before
    public void setUp() {
        importTool = new ImportTool();
        exportTool = new ExportTool();
    }

    private SqoopOptions parseImportArgs(String[] argv) throws Exception {
        SqoopOptions opts = importTool.parseArguments(argv, null, null, false);
        return opts;
    }

    private SqoopOptions parseExportArgs(String[] argv) throws Exception {
        SqoopOptions opts = exportTool.parseArguments(argv, null, null, false);
        return opts;
    }

    public void testHCatalogHomeWithImport() throws Exception {
        String[] args = new String[]{"--hcatalog-home", "/usr/lib/hcatalog"};
        SqoopOptions opts = this.parseImportArgs(args);
    }

    public void testHCatalogHomeWithExport() throws Exception {
        String[] args = new String[]{"--hcatalog-home", "/usr/lib/hcatalog"};
        SqoopOptions opts = this.parseExportArgs(args);
    }

    public void testHCatalogImport() throws Exception {
        String[] args = new String[]{"--hcatalog-table", "table"};
        SqoopOptions opts = this.parseImportArgs(args);
    }

    public void testHCatalogExport() throws Exception {
        String[] args = new String[]{"--hcatalog-table", "table"};
        SqoopOptions opts = this.parseExportArgs(args);
    }

    public void testHCatImportWithTargetDir() throws Exception {
        String[] args = new String[]{"--connect", "jdbc:db:url", "--table", "dbtable", "--hcatalog-table", "table", "--target-dir", "/target/dir"};
        try {
            SqoopOptions opts = this.parseImportArgs(args);
            importTool.validateOptions(opts);
            TestHCatalogBasic.fail((String)"Expected InvalidOptionsException");
        }
        catch (SqoopOptions.InvalidOptionsException invalidOptionsException) {
            // empty catch block
        }
    }

    public void testHCatImportWithWarehouseDir() throws Exception {
        String[] args = new String[]{"--connect", "jdbc:db:url", "--table", "dbtable", "--hcatalog-table", "table", "--warehouse-dir", "/target/dir"};
        try {
            SqoopOptions opts = this.parseImportArgs(args);
            importTool.validateOptions(opts);
            TestHCatalogBasic.fail((String)"Expected InvalidOptionsException");
        }
        catch (SqoopOptions.InvalidOptionsException invalidOptionsException) {
            // empty catch block
        }
    }

    public void testHCatImportWithHiveImport() throws Exception {
        String[] args = new String[]{"--connect", "jdbc:db:url", "--table", "dbtable", "--hcatalog-table", "table", "--hive-import"};
        try {
            SqoopOptions opts = this.parseImportArgs(args);
            importTool.validateOptions(opts);
            TestHCatalogBasic.fail((String)"Expected InvalidOptionsException");
        }
        catch (SqoopOptions.InvalidOptionsException invalidOptionsException) {
            // empty catch block
        }
    }

    public void testHCatExportWithExportDir() throws Exception {
        String[] args = new String[]{"--connect", "jdbc:db:url", "--table", "dbtable", "--hcatalog-table", "table", "--export-dir", "/export/dir"};
        try {
            SqoopOptions opts = this.parseExportArgs(args);
            exportTool.validateOptions(opts);
            TestHCatalogBasic.fail((String)"Expected InvalidOptionsException");
        }
        catch (SqoopOptions.InvalidOptionsException invalidOptionsException) {
            // empty catch block
        }
    }

    public void testHCatImportWithDirect() throws Exception {
        String[] args = new String[]{"--connect", "jdbc:db:url", "--table", "dbtable", "--hcatalog-table", "table", "--direct"};
        try {
            SqoopOptions opts = this.parseImportArgs(args);
            importTool.validateOptions(opts);
            TestHCatalogBasic.fail((String)"Expected InvalidOptionsException");
        }
        catch (SqoopOptions.InvalidOptionsException invalidOptionsException) {
            // empty catch block
        }
    }

    public void testHCatImportWithSequenceFile() throws Exception {
        String[] args = new String[]{"--connect", "jdbc:db:url", "--table", "dbtable", "--hcatalog-table", "table", "--as-sequencefile"};
        try {
            SqoopOptions opts = this.parseImportArgs(args);
            importTool.validateOptions(opts);
            TestHCatalogBasic.fail((String)"Expected InvalidOptionsException");
        }
        catch (SqoopOptions.InvalidOptionsException invalidOptionsException) {
            // empty catch block
        }
    }

    public void testHCatImportWithAvroFile() throws Exception {
        String[] args = new String[]{"--connect", "jdbc:db:url", "--table", "dbtable", "--hcatalog-table", "table", "--as-avrofile"};
        try {
            SqoopOptions opts = this.parseImportArgs(args);
            importTool.validateOptions(opts);
            TestHCatalogBasic.fail((String)"Expected InvalidOptionsException");
        }
        catch (SqoopOptions.InvalidOptionsException invalidOptionsException) {
            // empty catch block
        }
    }

    public void testHCatImportWithCreateTable() throws Exception {
        String[] args = new String[]{"--hcatalog-table", "table", "--create-hcatalog-table"};
        SqoopOptions opts = this.parseImportArgs(args);
    }

    public void testHCatImportWithStorageStanza() throws Exception {
        String[] args = new String[]{"--hcatalog-table", "table", "--hcatalog-storage-stanza", "stored as textfile"};
        SqoopOptions opts = this.parseImportArgs(args);
    }

    public void testHCatImportWithDatabase() throws Exception {
        String[] args = new String[]{"--hcatalog-table", "table", "--hcatalog-database", "default"};
        SqoopOptions opts = this.parseImportArgs(args);
    }
}

