/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NetezzaTestUtils {
    public static final Log LOG = LogFactory.getLog((String)NetezzaTestUtils.class.getName());
    public static final String NZ_HOST = System.getProperty("sqoop.test.netezza.host", "nz-host");
    public static final String NZ_PORT = System.getProperty("sqoop.test.netezza.port", "5480");
    public static final String NZ_JDBC_URL_PREFIX = "jdbc:netezza:";
    public static final String NZ_DB_USER = System.getProperty("sqoop.test.netezza.username", "ADMIN");
    public static final String NZ_DB_PASSWORD = System.getProperty("sqoop.test.netezza.password", "password");
    public static final String NZ_DB_NAME = System.getProperty("sqoop.test.netezza.db.name", "SQOOP");
    public static final String TABLE_NAME = System.getProperty("sqoop.test.netezza.table.name", "EMPNZ");

    private NetezzaTestUtils() {
    }

    public static String getNZUser() {
        String nzUser = System.getenv("NZ_USER");
        if (nzUser == null) {
            nzUser = NZ_DB_USER;
        }
        return nzUser;
    }

    public static String getNZPassword() {
        String nzPass = System.getenv("NZ_PASSWORD");
        if (nzPass == null) {
            nzPass = NZ_DB_PASSWORD;
        }
        return nzPass;
    }

    public static String getNZConnectString() {
        String nzDB;
        String nzPort;
        String nzHost = System.getenv("NZ_HOST");
        if (nzHost == null) {
            nzHost = NZ_HOST;
        }
        if ((nzPort = System.getenv("NZ_PORT")) == null) {
            nzPort = NZ_PORT;
        }
        if ((nzDB = System.getenv("NZ_DB_NAME")) == null) {
            nzDB = NZ_DB_NAME;
        }
        StringBuilder url = new StringBuilder(NZ_JDBC_URL_PREFIX);
        url.append("//").append(nzHost).append(':').append(nzPort);
        url.append('/').append(nzDB);
        LOG.info((Object)("NZ Connect string generated : " + url.toString()));
        return url.toString();
    }
}

