/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.DirectMySQLManager;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySQLAuthTest
extends ImportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)MySQLAuthTest.class.getName());
    static final String HOST_URL = System.getProperty("sqoop.test.mysql.connectstring.host_url", "jdbc:mysql://localhost/");
    static final String AUTH_TEST_DATABASE = "sqooppasstest";
    static final String AUTH_TEST_USER = "sqooptest";
    static final String AUTH_TEST_PASS = "12345";
    static final String AUTH_TABLE_NAME = "authtest";
    static final String AUTH_CONNECT_STRING = HOST_URL + "sqooppasstest";
    private DirectMySQLManager manager;

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() {
        super.setUp();
        SqoopOptions options = new SqoopOptions(AUTH_CONNECT_STRING, AUTH_TABLE_NAME);
        options.setUsername(AUTH_TEST_USER);
        options.setPassword(AUTH_TEST_PASS);
        LOG.debug((Object)("Setting up another MySQLAuthTest: " + AUTH_CONNECT_STRING));
        this.manager = new DirectMySQLManager(options);
        Connection connection = null;
        Statement st = null;
        try {
            connection = this.manager.getConnection();
            connection.setAutoCommit(false);
            st = connection.createStatement();
            st.executeUpdate("DROP TABLE IF EXISTS authtest");
            st.executeUpdate("CREATE TABLE authtest (id INT NOT NULL PRIMARY KEY AUTO_INCREMENT, name VARCHAR(24) NOT NULL)");
            st.executeUpdate("INSERT INTO authtest VALUES(NULL,'Aaron')");
            connection.commit();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Encountered SQL Exception: " + sqlE));
            sqlE.printStackTrace();
            MySQLAuthTest.fail((String)("SQLException when running test setUp(): " + sqlE));
        }
        finally {
            try {
                if (null != st) {
                    st.close();
                }
                if (null != connection) {
                    connection.close();
                }
            }
            catch (SQLException sqlE) {
                LOG.warn((Object)("Got SQLException when closing connection: " + sqlE));
            }
        }
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        try {
            this.manager.close();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            MySQLAuthTest.fail((String)("Got SQLException: " + sqlE.toString()));
        }
    }

    private String[] getArgv(boolean includeHadoopFlags, boolean useDirect, String connectString, String tableName) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--table");
        args.add(tableName);
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(connectString);
        if (useDirect) {
            args.add("--direct");
        }
        args.add("--username");
        args.add(AUTH_TEST_USER);
        args.add("--password");
        args.add(AUTH_TEST_PASS);
        args.add("--mysql-delimiters");
        args.add("--num-mappers");
        args.add("1");
        return args.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthAccess() {
        String[] argv = this.getArgv(true, true, AUTH_CONNECT_STRING, AUTH_TABLE_NAME);
        try {
            this.runImport(argv);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Got IOException during import: " + ioe.toString()));
            ioe.printStackTrace();
            MySQLAuthTest.fail((String)ioe.toString());
        }
        Path warehousePath = new Path(this.getWarehouseDir());
        Path tablePath = new Path(warehousePath, AUTH_TABLE_NAME);
        Path filePath = new Path(tablePath, "part-m-00000");
        File f = new File(filePath.toString());
        MySQLAuthTest.assertTrue((String)"Could not find imported data file", (boolean)f.exists());
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            MySQLAuthTest.assertEquals((String)"1,'Aaron'", (String)r.readLine());
        }
        catch (IOException ioe) {
            try {
                LOG.error((Object)("Got IOException verifying results: " + ioe.toString()));
                ioe.printStackTrace();
                MySQLAuthTest.fail((String)ioe.toString());
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(r);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)r);
        }
        IOUtils.closeStream((Closeable)r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZeroTimestamp() throws IOException, SQLException {
        try {
            this.doZeroTimestampTest(0, true, AUTH_CONNECT_STRING);
            this.doZeroTimestampTest(1, true, AUTH_CONNECT_STRING + "?");
            this.doZeroTimestampTest(2, true, AUTH_CONNECT_STRING + "?connectTimeout=0");
            this.doZeroTimestampTest(3, true, AUTH_CONNECT_STRING + "?connectTimeout=0&");
            this.doZeroTimestampTest(4, true, AUTH_CONNECT_STRING + "?zeroDateTimeBehavior=convertToNull");
            this.doZeroTimestampTest(5, false, AUTH_CONNECT_STRING + "?zeroDateTimeBehavior=exception");
        }
        finally {
            this.dropTimestampTables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTimestampTables() throws SQLException {
        SqoopOptions options = new SqoopOptions(AUTH_CONNECT_STRING, null);
        options.setUsername(AUTH_TEST_USER);
        options.setPassword(AUTH_TEST_PASS);
        this.manager = new DirectMySQLManager(options);
        Connection connection = null;
        Statement st = null;
        connection = this.manager.getConnection();
        connection.setAutoCommit(false);
        st = connection.createStatement();
        try {
            st.executeUpdate("DROP TABLE IF EXISTS mysqlTimestampTable0");
            st.executeUpdate("DROP TABLE IF EXISTS mysqlTimestampTable1");
            st.executeUpdate("DROP TABLE IF EXISTS mysqlTimestampTable2");
            st.executeUpdate("DROP TABLE IF EXISTS mysqlTimestampTable3");
            st.executeUpdate("DROP TABLE IF EXISTS mysqlTimestampTable4");
            st.executeUpdate("DROP TABLE IF EXISTS mysqlTimestampTable5");
            connection.commit();
        }
        finally {
            st.close();
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doZeroTimestampTest(int testNum, boolean expectSuccess, String connectString) throws IOException, SQLException {
        LOG.info((Object)("Beginning zero-timestamp test #" + testNum));
        try {
            String TABLE_NAME = "mysqlTimestampTable" + Integer.toString(testNum);
            SqoopOptions options = new SqoopOptions(connectString, TABLE_NAME);
            options.setUsername(AUTH_TEST_USER);
            options.setPassword(AUTH_TEST_PASS);
            this.manager = new DirectMySQLManager(options);
            Connection connection = null;
            Statement st = null;
            connection = this.manager.getConnection();
            connection.setAutoCommit(false);
            st = connection.createStatement();
            st.executeUpdate("DROP TABLE IF EXISTS " + TABLE_NAME);
            st.executeUpdate("CREATE TABLE " + TABLE_NAME + " (" + "id INT NOT NULL PRIMARY KEY AUTO_INCREMENT, " + "ts TIMESTAMP NOT NULL)");
            st.executeUpdate("INSERT INTO " + TABLE_NAME + " VALUES(" + "NULL,'0000-00-00 00:00:00.0')");
            connection.commit();
            st.close();
            connection.close();
            String[] argv = this.getArgv(true, false, connectString, TABLE_NAME);
            try {
                this.runImport(argv);
            }
            catch (Exception e) {
                if (expectSuccess) {
                    throw new RuntimeException(e);
                }
                LOG.info((Object)("Got exception running import (expected). msg: " + e));
            }
            Path warehousePath = new Path(this.getWarehouseDir());
            Path tablePath = new Path(warehousePath, TABLE_NAME);
            Path filePath = new Path(tablePath, "part-m-00000");
            File f = new File(filePath.toString());
            if (expectSuccess) {
                MySQLAuthTest.assertTrue((String)"Could not find imported data file", (boolean)f.exists());
                BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                MySQLAuthTest.assertEquals((String)"1,null", (String)r.readLine());
                IOUtils.closeStream((Closeable)r);
            } else {
                MySQLAuthTest.assertFalse((String)"Imported data when expected failure", (boolean)f.exists());
            }
        }
        finally {
            LOG.info((Object)("Finished zero timestamp test #" + testNum));
        }
    }
}

