/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation;

import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.validation.AbsoluteValidationThreshold;

public class RowCountValidatorImportTest
extends ImportJobTestCase {
    @Override
    protected List<String> getExtraArgs(Configuration conf) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("--validate");
        return list;
    }

    public void testAbsoluteValidationThreshold() {
        AbsoluteValidationThreshold validationThreshold = new AbsoluteValidationThreshold();
        RowCountValidatorImportTest.assertTrue((boolean)validationThreshold.compare((Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(100)));
        RowCountValidatorImportTest.assertFalse((boolean)validationThreshold.compare((Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(90)));
        RowCountValidatorImportTest.assertFalse((boolean)validationThreshold.compare((Comparable)Integer.valueOf(90), (Comparable)Integer.valueOf(100)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidateOptionIsEnabled() throws Exception {
        String[] types = new String[]{"INT NOT NULL PRIMARY KEY", "VARCHAR(32)", "VARCHAR(32)"};
        String[] insertVals = new String[]{"1", "'Bob'", "'sales'"};
        try {
            this.createTableWithColTypes(types, insertVals);
            String[] args = this.getArgv(true, null, this.getConf());
            ArrayList argsList = new ArrayList();
            Collections.addAll(argsList, args);
            RowCountValidatorImportTest.assertTrue((String)"Validate option missing.", (boolean)argsList.contains("--validate"));
        }
        finally {
            this.dropTableIfExists(this.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidatorForImportTable() throws Exception {
        String[] types = new String[]{"INT NOT NULL PRIMARY KEY", "VARCHAR(32)", "VARCHAR(32)"};
        String[] insertVals = new String[]{"1", "'Bob'", "'sales'"};
        String validateLine = "1,Bob,sales";
        try {
            this.createTableWithColTypes(types, insertVals);
            this.verifyImport(validateLine, null);
            LOG.debug((Object)("Verified input line as " + validateLine + " -- ok!"));
        }
        finally {
            this.dropTableIfExists(this.getTableName());
        }
    }
}

