/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce;

import com.cloudera.sqoop.Sqoop;
import com.cloudera.sqoop.manager.ManagerFactory;
import com.cloudera.sqoop.mapreduce.AutoProgressMapper;
import com.cloudera.sqoop.mapreduce.ImportJobBase;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.testutil.InjectableManagerFactory;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.tool.SqoopTool;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import junit.framework.Assert;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class TestImportJob
extends ImportJobTestCase {
    public void testFailedImportDueToIOException() throws IOException {
        this.createTableForColType("VARCHAR(32)", "'meep'");
        Configuration conf = new Configuration();
        LogFactory.getLog(((Object)((Object)this)).getClass()).info((Object)(" getWarehouseDir() " + this.getWarehouseDir()));
        Path outputPath = new Path(new Path(this.getWarehouseDir()), this.getTableName());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        fs.mkdirs(outputPath);
        TestImportJob.assertTrue((boolean)fs.exists(outputPath));
        String[] argv = this.getArgv(true, new String[]{"DATA_COL0"}, conf);
        Sqoop importer = new Sqoop((SqoopTool)new ImportTool());
        try {
            int ret = Sqoop.runSqoop((Sqoop)importer, (String[])argv);
            TestImportJob.assertTrue((String)"Expected ImportException running this job.", (1 == ret ? 1 : 0) != 0);
        }
        catch (Exception e) {
            LOG.info((Object)("Got exceptional return (expected: ok). msg is: " + e));
        }
    }

    public void testFailedImportDueToJobFail() throws IOException {
        this.createTableForColType("VARCHAR(32)", "'meep2'");
        Configuration conf = new Configuration();
        conf.setClass("sqoop.connection.factories", InjectableManagerFactory.class, ManagerFactory.class);
        String[] argv = this.getArgv(true, new String[]{"DATA_COL0"}, conf);
        conf.setClass("sqoop.inject.mapper.class", NullDereferenceMapper.class, Mapper.class);
        conf.setClass("sqoop.inject.import.job.class", DummyImportJob.class, ImportJobBase.class);
        Sqoop importer = new Sqoop((SqoopTool)new ImportTool(), conf);
        try {
            int ret = Sqoop.runSqoop((Sqoop)importer, (String[])argv);
            TestImportJob.assertTrue((String)"Expected ImportException running this job.", (1 == ret ? 1 : 0) != 0);
        }
        catch (Exception e) {
            LOG.info((Object)("Got exceptional return (expected: ok). msg is: " + e));
        }
    }

    public void testFailedNoColumns() throws IOException {
        this.createTableForColType("VARCHAR(32)", "'meep'");
        Configuration conf = new Configuration();
        Path outputPath = new Path(new Path(this.getWarehouseDir()), this.getTableName());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        fs.mkdirs(outputPath);
        TestImportJob.assertTrue((boolean)fs.exists(outputPath));
        String[] argv = this.getArgv(true, new String[]{""}, conf);
        Sqoop importer = new Sqoop((SqoopTool)new ImportTool());
        try {
            int ret = Sqoop.runSqoop((Sqoop)importer, (String[])argv);
            TestImportJob.assertTrue((String)"Expected job to fail due to no colnames.", (1 == ret ? 1 : 0) != 0);
        }
        catch (Exception e) {
            LOG.info((Object)("Got exceptional return (expected: ok). msg is: " + e));
        }
    }

    public void testFailedIllegalColumns() throws IOException {
        this.createTableForColType("VARCHAR(32)", "'meep'");
        Configuration conf = new Configuration();
        Path outputPath = new Path(new Path(this.getWarehouseDir()), this.getTableName());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        fs.mkdirs(outputPath);
        TestImportJob.assertTrue((boolean)fs.exists(outputPath));
        String[] argv = this.getArgv(true, new String[]{"DATA_COL0", "zyzzyva"}, conf);
        Sqoop importer = new Sqoop((SqoopTool)new ImportTool());
        try {
            int ret = Sqoop.runSqoop((Sqoop)importer, (String[])argv);
            TestImportJob.assertTrue((String)"Expected job to fail due bad colname.", (1 == ret ? 1 : 0) != 0);
        }
        catch (Exception e) {
            LOG.info((Object)("Got exceptional return (expected: ok). msg is: " + e));
        }
    }

    public void testDuplicateColumns() throws IOException {
        this.createTableForColType("VARCHAR(32)", "'meep'");
        Configuration conf = new Configuration();
        Path outputPath = new Path(new Path(this.getWarehouseDir()), this.getTableName());
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        fs.mkdirs(outputPath);
        TestImportJob.assertTrue((boolean)fs.exists(outputPath));
        String[] argv = this.getArgv(true, new String[]{"DATA_COL0,DATA_COL0"}, conf);
        Sqoop importer = new Sqoop((SqoopTool)new ImportTool());
        try {
            int ret = Sqoop.runSqoop((Sqoop)importer, (String[])argv);
            TestImportJob.assertTrue((String)"Expected job to fail!", (1 == ret ? 1 : 0) != 0);
        }
        catch (Exception e) {
            LOG.info((Object)("Got exceptional return (expected: ok). msg is: " + e));
        }
    }

    public static class DummyImportJob
    extends ImportJobBase {
        public void configureInputFormat(Job job, String tableName, String tableClassName, String splitByCol) throws ClassNotFoundException, IOException {
            Path dir = new Path(this.options.getTempDir());
            Path p = new Path(dir, "sqoop-dummy-import-job-file.txt");
            LocalFileSystem fs = FileSystem.getLocal((Configuration)this.options.getConf());
            if (fs.exists(p)) {
                boolean result = fs.delete(p, false);
                Assert.assertTrue((String)"Couldn't delete temp file!", (boolean)result);
            }
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(p)));
            w.append("This is a line!");
            w.close();
            FileInputFormat.addInputPath((Job)job, (Path)p);
            super.configureInputFormat(job, tableName, tableClassName, splitByCol);
        }
    }

    public static class NullDereferenceMapper
    extends AutoProgressMapper<Object, Object, Text, NullWritable> {
        public void map(Object key, Object val, Mapper.Context c) throws IOException, InterruptedException {
            String s = null;
            s.length();
        }
    }
}

