/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.PostgresqlManager;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.util.FileListing;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.junit.Before;
import org.junit.Test;

public class PostgresqlImportTest
extends ImportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)PostgresqlImportTest.class.getName());
    static final String HOST_URL = System.getProperty("sqoop.test.postgresql.connectstring.host_url", "jdbc:postgresql://localhost/");
    static final String DATABASE_USER = "sqooptest";
    static final String DATABASE_NAME = "sqooptest";
    static final String TABLE_NAME = "EMPLOYEES_PG";
    static final String NULL_TABLE_NAME = "NULL_EMPLOYEES_PG";
    static final String SPECIAL_TABLE_NAME = "EMPLOYEES_PG's";
    static final String DIFFERENT_TABLE_NAME = "DIFFERENT_TABLE";
    static final String SCHEMA_PUBLIC = "public";
    static final String SCHEMA_SPECIAL = "special";
    static final String CONNECT_STRING = HOST_URL + "sqooptest";

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        LOG.debug((Object)("Setting up another postgresql test: " + CONNECT_STRING));
        this.setUpData(TABLE_NAME, SCHEMA_PUBLIC, false);
        this.setUpData(NULL_TABLE_NAME, SCHEMA_PUBLIC, true);
        this.setUpData(SPECIAL_TABLE_NAME, SCHEMA_PUBLIC, false);
        this.setUpData(DIFFERENT_TABLE_NAME, SCHEMA_SPECIAL, false);
        LOG.debug((Object)"setUp complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpData(String tableName, String schema, boolean nullEntry) {
        SqoopOptions options = new SqoopOptions(CONNECT_STRING, tableName);
        options.setUsername("sqooptest");
        PostgresqlManager manager = null;
        Connection connection = null;
        Statement st = null;
        try {
            manager = new PostgresqlManager(options);
            connection = manager.getConnection();
            connection.setAutoCommit(false);
            st = connection.createStatement();
            try {
                st.executeUpdate("CREATE SCHEMA " + manager.escapeTableName(schema));
                connection.commit();
            }
            catch (SQLException e) {
                LOG.info((Object)("Couldn't create schema " + schema + " (is o.k. as long as" + "the schema already exists."), (Throwable)e);
                connection.rollback();
            }
            String fullTableName = manager.escapeTableName(schema) + "." + manager.escapeTableName(tableName);
            try {
                st.executeUpdate("DROP TABLE " + fullTableName);
            }
            catch (SQLException e) {
                LOG.info((Object)("Couldn't drop table " + schema + "." + tableName + " (ok)"), (Throwable)e);
                connection.rollback();
            }
            st.executeUpdate("CREATE TABLE " + fullTableName + " (" + manager.escapeColName("id") + " INT NOT NULL PRIMARY KEY, " + manager.escapeColName("name") + " VARCHAR(24) NOT NULL, " + manager.escapeColName("start_date") + " DATE, " + manager.escapeColName("Salary") + " FLOAT, " + manager.escapeColName("dept") + " VARCHAR(32))");
            st.executeUpdate("INSERT INTO " + fullTableName + " VALUES(1,'Aaron','2009-05-14',1000000.00,'engineering')");
            st.executeUpdate("INSERT INTO " + fullTableName + " VALUES(2,'Bob','2009-04-20',400.00,'sales')");
            st.executeUpdate("INSERT INTO " + fullTableName + " VALUES(3,'Fred','2009-01-23',15.00,'marketing')");
            if (nullEntry) {
                st.executeUpdate("INSERT INTO " + fullTableName + " VALUES(4,'Mike',NULL,NULL,NULL)");
            }
            connection.commit();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Encountered SQL Exception: " + sqlE));
            sqlE.printStackTrace();
            PostgresqlImportTest.fail((String)("SQLException when running test setUp(): " + sqlE));
        }
        finally {
            try {
                if (null != st) {
                    st.close();
                }
                if (null != manager) {
                    manager.close();
                }
            }
            catch (SQLException sqlE) {
                LOG.warn((Object)("Got SQLException when closing connection: " + sqlE));
            }
        }
        LOG.debug((Object)"setUp complete.");
    }

    private String[] getArgv(boolean isDirect, String tableName, String ... extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        CommonArgs.addHadoopFlags(args);
        args.add("--table");
        args.add(tableName);
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(CONNECT_STRING);
        args.add("--username");
        args.add("sqooptest");
        args.add("--where");
        args.add("id > 1");
        if (isDirect) {
            args.add("--direct");
        }
        for (String arg : extraArgs) {
            args.add(arg);
        }
        return args.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImportAndVerify(boolean isDirect, String[] expectedResults, String tableName, String ... extraArgs) throws IOException {
        Path warehousePath = new Path(this.getWarehouseDir());
        Path tablePath = new Path(warehousePath, tableName);
        Path filePath = isDirect ? new Path(tablePath, "data-00000") : new Path(tablePath, "part-m-00000");
        File tableFile = new File(tablePath.toString());
        if (tableFile.exists() && tableFile.isDirectory()) {
            FileListing.recursiveDeleteDir((File)tableFile);
        }
        String[] argv = this.getArgv(isDirect, tableName, extraArgs);
        try {
            this.runImport(argv);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Got IOException during import: " + ioe.toString()));
            ioe.printStackTrace();
            PostgresqlImportTest.fail((String)ioe.toString());
        }
        File f = new File(filePath.toString());
        PostgresqlImportTest.assertTrue((String)("Could not find imported data file, " + f), (boolean)f.exists());
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            for (String expectedLine : expectedResults) {
                PostgresqlImportTest.assertEquals((String)expectedLine, (String)r.readLine());
            }
        }
        catch (IOException ioe) {
            try {
                LOG.error((Object)("Got IOException verifying results: " + ioe.toString()));
                ioe.printStackTrace();
                PostgresqlImportTest.fail((String)ioe.toString());
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(r);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)r);
        }
        IOUtils.closeStream((Closeable)r);
    }

    @Test
    public void testJdbcBasedImport() throws IOException {
        String[] expectedResults = new String[]{"2,Bob,2009-04-20,400.0,sales", "3,Fred,2009-01-23,15.0,marketing"};
        this.doImportAndVerify(false, expectedResults, TABLE_NAME, new String[0]);
    }

    @Test
    public void testDirectImport() throws IOException {
        String[] expectedResults = new String[]{"2,Bob,2009-04-20,400,sales", "3,Fred,2009-01-23,15,marketing"};
        this.doImportAndVerify(true, expectedResults, TABLE_NAME, new String[0]);
    }

    @Test
    public void testListTables() throws IOException {
        SqoopOptions options = new SqoopOptions(new Configuration());
        options.setConnectString(CONNECT_STRING);
        options.setUsername("sqooptest");
        PostgresqlManager mgr = new PostgresqlManager(options);
        Object[] tables = mgr.listTables();
        Arrays.sort(tables);
        PostgresqlImportTest.assertTrue((String)"EMPLOYEES_PG is not found!", (Arrays.binarySearch(tables, TABLE_NAME) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTableNameWithSpecialCharacter() throws IOException {
        String[] expectedResults = new String[]{"2,Bob,2009-04-20,400.0,sales", "3,Fred,2009-01-23,15.0,marketing"};
        this.doImportAndVerify(false, expectedResults, SPECIAL_TABLE_NAME, new String[0]);
    }

    @Test
    public void testIncrementalImport() throws IOException {
        String[] expectedResults = new String[]{};
        String[] extraArgs = new String[]{"--incremental", "lastmodified", "--check-column", "start_date"};
        this.doImportAndVerify(false, expectedResults, TABLE_NAME, extraArgs);
    }

    @Test
    public void testDifferentSchemaImport() throws IOException {
        String[] expectedResults = new String[]{"2,Bob,2009-04-20,400.0,sales", "3,Fred,2009-01-23,15.0,marketing"};
        String[] extraArgs = new String[]{"--", "--schema", SCHEMA_SPECIAL};
        this.doImportAndVerify(false, expectedResults, DIFFERENT_TABLE_NAME, extraArgs);
    }

    @Test
    public void testDifferentSchemaImportDirect() throws IOException {
        String[] expectedResults = new String[]{"2,Bob,2009-04-20,400,sales", "3,Fred,2009-01-23,15,marketing"};
        String[] extraArgs = new String[]{"--", "--schema", SCHEMA_SPECIAL};
        this.doImportAndVerify(true, expectedResults, DIFFERENT_TABLE_NAME, extraArgs);
    }

    @Test
    public void testNullEscapeCharacters() throws Exception {
        String[] expectedResults = new String[]{"2,Bob,2009-04-20,400,sales", "3,Fred,2009-01-23,15,marketing", "4,Mike,\\N,\\N,\\N"};
        String[] extraArgs = new String[]{"--null-string", "\\\\\\\\N", "--null-non-string", "\\\\\\\\N"};
        this.doImportAndVerify(true, expectedResults, NULL_TABLE_NAME, extraArgs);
    }
}

