/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.TestExport;
import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class PGBulkloadManagerManualTest
extends TestExport {
    public static final Log LOG = LogFactory.getLog((String)PGBulkloadManagerManualTest.class.getName());
    private DBConfiguration dbConf;

    public PGBulkloadManagerManualTest() {
        Configuration conf = this.getConf();
        DBConfiguration.configureDB((Configuration)conf, (String)"org.postgresql.Driver", (String)this.getConnectString(), (String)this.getUserName(), (String)null, (Integer)null);
        this.dbConf = new DBConfiguration(conf);
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getConnectString() {
        return "jdbc:postgresql://localhost:5432/sqooptest";
    }

    protected String getUserName() {
        return "sqooptest";
    }

    @Override
    protected String getTablePrefix() {
        return super.getTablePrefix().toLowerCase();
    }

    @Override
    protected String getTableName() {
        return super.getTableName().toLowerCase();
    }

    @Override
    public String getStagingTableName() {
        return super.getStagingTableName().toLowerCase();
    }

    @Override
    protected Connection getConnection() {
        try {
            Connection conn = this.dbConf.getConnection();
            conn.setAutoCommit(false);
            PreparedStatement stmt = conn.prepareStatement("SET extra_float_digits TO 0");
            stmt.executeUpdate();
            conn.commit();
            return conn;
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Could not get connection to test server: " + sqlE));
            return null;
        }
        catch (ClassNotFoundException cnfE) {
            LOG.error((Object)("Could not find driver class: " + cnfE));
            return null;
        }
    }

    @Override
    protected String getDropTableStatement(String tableName) {
        return "DROP TABLE IF EXISTS " + tableName;
    }

    @Override
    protected String[] getArgv(boolean includeHadoopFlags, int rowsPerStatement, int statementsPerTx, String ... additionalArgv) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(additionalArgv));
        args.add("--username");
        args.add(this.getUserName());
        args.add("--connection-manager");
        args.add("org.apache.sqoop.manager.PGBulkloadManager");
        args.add("--staging-table");
        args.add("dummy");
        args.add("--clear-staging-table");
        return super.getArgv(includeHadoopFlags, rowsPerStatement, statementsPerTx, args.toArray(new String[0]));
    }

    @Override
    protected String[] getCodeGenArgv(String ... extraArgs) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(extraArgs));
        args.add("--username");
        args.add(this.getUserName());
        return super.getCodeGenArgv(args.toArray(new String[0]));
    }

    @Override
    public void testColumnsExport() throws IOException, SQLException {
    }

    public void testMultiReduceExport() throws IOException, SQLException {
        String[] genericargs = this.newStrArray(null, "-Dmapred.reduce.tasks=2");
        this.multiFileTestWithGenericArgs(2, 10, 2, genericargs, new String[0]);
    }

    public void testExportWithTablespace() throws IOException, SQLException {
        String[] genericargs = this.newStrArray(null, "-Dpgbulkload.staging.tablespace=sqooptest");
        this.multiFileTestWithGenericArgs(1, 10, 1, genericargs, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void multiFileTestWithGenericArgs(int numFiles, int recordsPerMap, int numMaps, String[] genericargs, String ... argv) throws IOException, SQLException {
        int TOTAL_RECORDS = numFiles * recordsPerMap;
        try {
            LOG.info((Object)("Beginning test: numFiles=" + numFiles + "; recordsPerMap=" + recordsPerMap + "; numMaps=" + numMaps));
            LOG.info((Object)"  with genericargs: ");
            for (String arg : genericargs) {
                LOG.info((Object)("    " + arg));
            }
            for (int i = 0; i < numFiles; ++i) {
                this.createTextFile(i, recordsPerMap, false, new TestExport.ColumnGenerator[0]);
            }
            this.createTable(new TestExport.ColumnGenerator[0]);
            this.runExport(this.getArgv(true, 10, 10, this.newStrArray(this.newStrArray(genericargs, argv), "-m", "" + numMaps)));
            this.verifyExport(TOTAL_RECORDS);
        }
        finally {
            LOG.info((Object)"multi-reduce test complete");
        }
    }
}

