/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.OracleManager;
import com.cloudera.sqoop.manager.OracleUtils;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.util.FileListing;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OracleManagerTest
extends ImportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)OracleManagerTest.class.getName());
    static final String TABLE_NAME = "EMPLOYEES";
    static final String SECONDARY_TABLE_NAME = "CUSTOMER";
    static final String QUALIFIED_SECONDARY_TABLE_NAME = "SQOOPTEST2.CUSTOMER";
    private static final String[] MAIN_TABLE_SQL_STMTS = new String[]{"CREATE TABLE EMPLOYEES (id INT NOT NULL, name VARCHAR2(24) NOT NULL, start_date DATE, salary FLOAT, dept VARCHAR2(32), timestamp_tz TIMESTAMP WITH TIME ZONE, timestamp_ltz TIMESTAMP WITH LOCAL TIME ZONE, PRIMARY KEY (id))", "INSERT INTO EMPLOYEES VALUES(1,'Aaron',to_date('2009-05-14','yyyy-mm-dd'),1000000.00,'engineering','29-DEC-09 12.00.00.000000000 PM','29-DEC-09 12.00.00.000000000 PM')", "INSERT INTO EMPLOYEES VALUES(2,'Bob',to_date('2009-04-20','yyyy-mm-dd'),400.00,'sales','30-DEC-09 12.00.00.000000000 PM','30-DEC-09 12.00.00.000000000 PM')", "INSERT INTO EMPLOYEES VALUES(3,'Fred',to_date('2009-01-23','yyyy-mm-dd'),15.00,'marketing','31-DEC-09 12.00.00.000000000 PM','31-DEC-09 12.00.00.000000000 PM')"};
    private static final String[] SECONDARY_TABLE_SQL_STMTS = new String[]{"CREATE TABLE CUSTOMER (id INT NOT NULL, name VARCHAR2(24) NOT NULL, PRIMARY KEY (id))", "INSERT INTO CUSTOMER VALUES(1,'MercuryCorp')", "INSERT INTO CUSTOMER VALUES(2,'VenusCorp')", "INSERT INTO CUSTOMER VALUES(3,'EarthCorp')", "INSERT INTO CUSTOMER VALUES(4,'MarsCorp')", "INSERT INTO CUSTOMER VALUES(5,'JupiterCorp')", "INSERT INTO CUSTOMER VALUES(6,'SaturnCorp')", "GRANT SELECT, INSERT ON CUSTOMER TO SQOOPTEST"};
    private OracleManager manager;

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdates(OracleManager mgr, String[] sqlStmts) {
        Connection connection = null;
        Statement st = null;
        try {
            connection = mgr.getConnection();
            connection.setAutoCommit(false);
            st = connection.createStatement();
            for (String sql : sqlStmts) {
                st.executeUpdate(sql);
            }
            connection.commit();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Encountered SQL Exception: " + sqlE));
            sqlE.printStackTrace();
            OracleManagerTest.fail((String)("SQLException when running test setUp(): " + sqlE));
        }
        finally {
            try {
                if (null != st) {
                    st.close();
                }
                if (null != connection) {
                    connection.close();
                }
            }
            catch (SQLException sqlE) {
                LOG.warn((Object)("Got SQLException when closing connection: " + sqlE));
            }
        }
    }

    private void provisionSecondaryTable() {
        SqoopOptions options = new SqoopOptions(OracleUtils.CONNECT_STRING, SECONDARY_TABLE_NAME);
        OracleUtils.setOracleSecondaryUserAuth(options);
        OracleManager mgr = new OracleManager(options);
        try {
            OracleUtils.dropTable(SECONDARY_TABLE_NAME, (ConnManager)mgr);
        }
        catch (SQLException sqlE) {
            OracleManagerTest.fail((String)("Could not drop table CUSTOMER: " + sqlE));
        }
        this.executeUpdates(mgr, SECONDARY_TABLE_SQL_STMTS);
        try {
            mgr.close();
        }
        catch (SQLException sqlE) {
            OracleManagerTest.fail((String)("Failed to close secondary manager instance : " + sqlE));
        }
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.provisionSecondaryTable();
        SqoopOptions options = new SqoopOptions(OracleUtils.CONNECT_STRING, TABLE_NAME);
        OracleUtils.setOracleAuth(options);
        this.manager = new OracleManager(options);
        options.getConf().set("oracle.sessionTimeZone", "US/Pacific");
        try {
            OracleUtils.dropTable(TABLE_NAME, (ConnManager)this.manager);
        }
        catch (SQLException sqlE) {
            OracleManagerTest.fail((String)("Could not drop table EMPLOYEES: " + sqlE));
        }
        this.executeUpdates(this.manager, MAIN_TABLE_SQL_STMTS);
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        try {
            this.manager.close();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            OracleManagerTest.fail((String)("Got SQLException: " + sqlE.toString()));
        }
    }

    private String[] getArgv() {
        return this.getArgv(TABLE_NAME);
    }

    private String[] getArgv(String tableName) {
        ArrayList<String> args = new ArrayList<String>();
        CommonArgs.addHadoopFlags(args);
        args.add("-D");
        args.add("oracle.sessionTimeZone=US/Pacific");
        args.add("--table");
        args.add(tableName);
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(OracleUtils.CONNECT_STRING);
        args.add("--username");
        args.add("SQOOPTEST");
        args.add("--password");
        args.add("12345");
        args.add("--num-mappers");
        args.add("1");
        return args.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSecondaryTableTest(String[] expectedResults) throws IOException {
        Path warehousePath = new Path(this.getWarehouseDir());
        Path tablePath = new Path(warehousePath, QUALIFIED_SECONDARY_TABLE_NAME);
        Path filePath = new Path(tablePath, "part-m-00000");
        File tableFile = new File(tablePath.toString());
        if (tableFile.exists() && tableFile.isDirectory()) {
            FileListing.recursiveDeleteDir((File)tableFile);
        }
        String[] argv = this.getArgv(QUALIFIED_SECONDARY_TABLE_NAME);
        try {
            this.runImport(argv);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Got IOException during import: " + ioe.toString()));
            ioe.printStackTrace();
            OracleManagerTest.fail((String)ioe.toString());
        }
        File f = new File(filePath.toString());
        OracleManagerTest.assertTrue((String)"Could not find imported data file", (boolean)f.exists());
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            for (String expectedLine : expectedResults) {
                this.compareRecords(expectedLine, r.readLine());
            }
        }
        catch (IOException ioe) {
            try {
                LOG.error((Object)("Got IOException verifying results: " + ioe.toString()));
                ioe.printStackTrace();
                OracleManagerTest.fail((String)ioe.toString());
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(r);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)r);
        }
        IOUtils.closeStream((Closeable)r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOracleTest(String[] expectedResults) throws IOException {
        Path warehousePath = new Path(this.getWarehouseDir());
        Path tablePath = new Path(warehousePath, TABLE_NAME);
        Path filePath = new Path(tablePath, "part-m-00000");
        File tableFile = new File(tablePath.toString());
        if (tableFile.exists() && tableFile.isDirectory()) {
            FileListing.recursiveDeleteDir((File)tableFile);
        }
        String[] argv = this.getArgv();
        try {
            this.runImport(argv);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Got IOException during import: " + ioe.toString()));
            ioe.printStackTrace();
            OracleManagerTest.fail((String)ioe.toString());
        }
        File f = new File(filePath.toString());
        OracleManagerTest.assertTrue((String)"Could not find imported data file", (boolean)f.exists());
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            for (String expectedLine : expectedResults) {
                this.compareRecords(expectedLine, r.readLine());
            }
        }
        catch (IOException ioe) {
            try {
                LOG.error((Object)("Got IOException verifying results: " + ioe.toString()));
                ioe.printStackTrace();
                OracleManagerTest.fail((String)ioe.toString());
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(r);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)r);
        }
        IOUtils.closeStream((Closeable)r);
    }

    @Test
    public void testOracleImport() throws IOException {
        String[] expectedResults = new String[]{"1,Aaron,2009-05-14 00:00:00.0,1000000,engineering,2009-12-29 12:00:00.0,2009-12-29 12:00:00.0", "2,Bob,2009-04-20 00:00:00.0,400,sales,2009-12-30 12:00:00.0,2009-12-30 12:00:00.0", "3,Fred,2009-01-23 00:00:00.0,15,marketing,2009-12-31 12:00:00.0,2009-12-31 12:00:00.0"};
        this.runOracleTest(expectedResults);
    }

    @Test
    public void testSecondaryTableImport() throws IOException {
        String[] expectedResults = new String[]{"1,MercuryCorp", "2,VenusCorp", "3,EarthCorp", "4,MarsCorp", "5,JupiterCorp", "6,SaturnCorp"};
        this.runSecondaryTableTest(expectedResults);
    }

    private void compareRecords(String expectedLine, String receivedLine) throws IOException {
        if (expectedLine == null || receivedLine == null) {
            return;
        }
        if (expectedLine.equals(receivedLine)) {
            return;
        }
        String[] expectedValues = expectedLine.split(",");
        String[] receivedValues = receivedLine.split(",");
        if (expectedValues.length != 7 || receivedValues.length != 7) {
            LOG.error((Object)"Number of expected fields did not match number of received fields");
            throw new IOException("Number of expected fields did not match number of received fields");
        }
        boolean mismatch = false;
        for (int i = 0; !mismatch && i < 5; ++i) {
            mismatch = !expectedValues[i].equals(receivedValues[i]);
        }
        if (mismatch) {
            throw new IOException("Expected:<" + expectedLine + "> but was:<" + receivedLine + ">");
        }
        Date expectedDate = null;
        Date receivedDate = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        int offset = TimeZone.getDefault().getOffset(System.currentTimeMillis()) / 3600000;
        for (int i = 5; i < 7; ++i) {
            try {
                expectedDate = df.parse(expectedValues[i]);
            }
            catch (ParseException ex) {
                LOG.error((Object)("Could not parse expected timestamp: " + expectedValues[i]));
                throw new IOException("Could not parse expected timestamp: " + expectedValues[i]);
            }
            try {
                receivedDate = df.parse(receivedValues[i]);
            }
            catch (ParseException ex) {
                LOG.error((Object)("Could not parse received timestamp: " + receivedValues[i]));
                throw new IOException("Could not parse received timestamp: " + receivedValues[i]);
            }
            Calendar expectedCal = Calendar.getInstance();
            expectedCal.setTime(expectedDate);
            expectedCal.add(10, offset);
            Calendar receivedCal = Calendar.getInstance();
            receivedCal.setTime(receivedDate);
            if (expectedCal.equals(receivedCal)) continue;
            throw new IOException("Expected:<" + expectedLine + "> but was:<" + receivedLine + ">, while timezone offset is: " + offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPurgeClosedConnections() throws Exception {
        SqoopOptions options = new SqoopOptions(OracleUtils.CONNECT_STRING, TABLE_NAME);
        OracleUtils.setOracleAuth(options);
        OracleManager m1 = new OracleManager(options);
        Connection c1 = m1.getConnection();
        PreparedStatement s = c1.prepareStatement("SELECT 1 FROM dual", 1003, 1007);
        ResultSet rs = null;
        try {
            rs = s.executeQuery();
            rs.close();
        }
        finally {
            s.close();
        }
        OracleManager m2 = new OracleManager(options);
        Connection c2 = m2.getConnection();
        m1.close();
        s = c2.prepareStatement("SELECT 2 FROM dual", 1003, 1007);
        try {
            rs = s.executeQuery();
            rs.close();
        }
        finally {
            s.close();
        }
        m2.close();
        Connection c2a = m2.getConnection();
        OracleManagerTest.assertFalse((boolean)c1.isClosed());
        OracleManagerTest.assertTrue((boolean)c2.isClosed());
        OracleManagerTest.assertFalse((boolean)c2a.isClosed());
        s = c2a.prepareStatement("SELECT 3 FROM dual", 1003, 1007);
        try {
            rs = s.executeQuery();
            rs.close();
        }
        finally {
            s.close();
        }
        m2.close();
    }
}

