/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.TestExport;
import com.cloudera.sqoop.manager.OracleManager;
import com.cloudera.sqoop.manager.OracleUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.AssertionFailedError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.junit.After;
import org.junit.Before;

public class OracleExportTest
extends TestExport {
    public static final Log LOG = LogFactory.getLog((String)OracleExportTest.class.getName());
    static final String TABLE_PREFIX = "EXPORT_ORACLE_";
    private OracleManager manager;
    private Connection conn;

    @Override
    protected Connection getConnection() {
        return this.conn;
    }

    @Override
    protected int getMaxRowsPerStatement() {
        return 1000;
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getConnectString() {
        return OracleUtils.CONNECT_STRING;
    }

    @Override
    protected String getTablePrefix() {
        return TABLE_PREFIX;
    }

    @Override
    protected String getDropTableStatement(String tableName) {
        return OracleUtils.getDropTableStatement(tableName);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        SqoopOptions options = new SqoopOptions(OracleUtils.CONNECT_STRING, this.getTableName());
        OracleUtils.setOracleAuth(options);
        this.manager = new OracleManager(options);
        try {
            this.conn = this.manager.getConnection();
            this.conn.setAutoCommit(false);
        }
        catch (SQLException sqlE) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)sqlE));
            OracleExportTest.fail((String)("Failed with sql exception in setup: " + sqlE));
        }
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        if (null != this.conn) {
            try {
                this.conn.close();
            }
            catch (SQLException sqlE) {
                LOG.error((Object)("Got SQLException closing conn: " + sqlE.toString()));
            }
        }
        if (null != this.manager) {
            try {
                this.manager.close();
                this.manager = null;
            }
            catch (SQLException sqlE) {
                LOG.error((Object)("Got SQLException: " + sqlE.toString()));
                OracleExportTest.fail((String)("Got SQLException: " + sqlE.toString()));
            }
        }
    }

    @Override
    protected String[] getCodeGenArgv(String ... extraArgs) {
        String[] moreArgs = new String[extraArgs.length + 4];
        int i = 0;
        for (i = 0; i < extraArgs.length; ++i) {
            moreArgs[i] = extraArgs[i];
        }
        moreArgs[i++] = "--username";
        moreArgs[i++] = "SQOOPTEST";
        moreArgs[i++] = "--password";
        moreArgs[i++] = "12345";
        return super.getCodeGenArgv(moreArgs);
    }

    @Override
    protected String[] getArgv(boolean includeHadoopFlags, int rowsPerStatement, int statementsPerTx, String ... additionalArgv) {
        String[] subArgv = this.newStrArray(additionalArgv, "--username", "SQOOPTEST", "--password", "12345");
        return super.getArgv(includeHadoopFlags, rowsPerStatement, statementsPerTx, subArgv);
    }

    @Override
    protected TestExport.ColumnGenerator getDateColumnGenerator() {
        return new TestExport.ColumnGenerator(){

            @Override
            public String getExportText(int rowNum) {
                int day = rowNum + 1;
                return "2009-10-" + OracleExportTest.this.pad(day) + " 00:00:00.0";
            }

            @Override
            public String getVerifyText(int rowNum) {
                int day = rowNum + 1;
                return "2009-10-" + day + " 0:0:0. 0";
            }

            @Override
            public String getType() {
                return "TIMESTAMP";
            }
        };
    }

    @Override
    protected TestExport.ColumnGenerator getTimeColumnGenerator() {
        return new TestExport.ColumnGenerator(){

            @Override
            public String getExportText(int rowNum) {
                return "1970-01-01 10:01:" + OracleExportTest.this.pad(rowNum) + ".0";
            }

            @Override
            public String getVerifyText(int rowNum) {
                return "1970-1-1 10:1:" + rowNum + ". 0";
            }

            @Override
            public String getType() {
                return "TIMESTAMP";
            }
        };
    }

    protected TestExport.ColumnGenerator getNewDateColGenerator() {
        return new TestExport.ColumnGenerator(){

            @Override
            public String getExportText(int rowNum) {
                int day = rowNum + 1;
                return "2009-10-" + OracleExportTest.this.pad(day) + " 00:00:00.0";
            }

            @Override
            public String getVerifyText(int rowNum) {
                int day = rowNum + 1;
                return "2009-10-" + OracleExportTest.this.pad(day) + " 00:00:00";
            }

            @Override
            public String getType() {
                return "TIMESTAMP";
            }
        };
    }

    protected TestExport.ColumnGenerator getNewTimeColGenerator() {
        return new TestExport.ColumnGenerator(){

            @Override
            public String getExportText(int rowNum) {
                return "1970-01-01 10:01:" + OracleExportTest.this.pad(rowNum) + ".0";
            }

            @Override
            public String getVerifyText(int rowNum) {
                return "1970-01-01 10:01:" + OracleExportTest.this.pad(rowNum);
            }

            @Override
            public String getType() {
                return "TIMESTAMP";
            }
        };
    }

    @Override
    protected String getBigIntType() {
        return "NUMERIC(12,0)";
    }

    @Override
    public void testDatesAndTimes() throws IOException, SQLException {
        int TOTAL_RECORDS = 10;
        TestExport.ColumnGenerator genDate = this.getDateColumnGenerator();
        TestExport.ColumnGenerator genTime = this.getTimeColumnGenerator();
        try {
            this.createTextFile(0, 10, false, genDate, genTime);
            this.createTable(genDate, genTime);
            this.runExport(this.getArgv(true, 10, 10, new String[0]));
            this.verifyExport(10);
            this.assertColMinAndMax(this.forIdx(0), genDate);
            this.assertColMinAndMax(this.forIdx(1), genTime);
        }
        catch (AssertionFailedError afe) {
            genDate = this.getNewDateColGenerator();
            genTime = this.getNewTimeColGenerator();
            this.createTextFile(0, 10, false, genDate, genTime);
            this.createTable(genDate, genTime);
            this.runExport(this.getArgv(true, 10, 10, new String[0]));
            this.verifyExport(10);
            this.assertColMinAndMax(this.forIdx(0), genDate);
            this.assertColMinAndMax(this.forIdx(1), genTime);
        }
    }

    public void testUpsertTextExport() throws IOException, SQLException {
        int TOTAL_RECORDS = 10;
        this.createTextFile(0, 10, false, new TestExport.ColumnGenerator[0]);
        this.createTable(new TestExport.ColumnGenerator[0]);
        this.runExport(this.getArgv(true, 10, 10, this.newStrArray(null, "--update-key", "ID", "--update-mode", "allowinsert")));
        this.runExport(this.getArgv(true, 10, 10, this.newStrArray(null, "--update-key", "ID", "--update-mode", "allowinsert")));
        this.verifyExport(10);
    }
}

