/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.TestExport;
import com.cloudera.sqoop.manager.MySQLManager;
import com.cloudera.sqoop.manager.MySQLTestUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.junit.After;
import org.junit.Before;

public class JdbcMySQLExportTest
extends TestExport {
    public static final Log LOG = LogFactory.getLog((String)JdbcMySQLExportTest.class.getName());
    static final String TABLE_PREFIX = "EXPORT_MYSQL_J_";
    private MySQLManager manager;
    private Connection conn;

    @Override
    protected Connection getConnection() {
        return this.conn;
    }

    @Override
    protected int getMaxRowsPerStatement() {
        return 1000;
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getConnectString() {
        return MySQLTestUtils.CONNECT_STRING;
    }

    @Override
    protected String getTablePrefix() {
        return TABLE_PREFIX;
    }

    @Override
    protected String getDropTableStatement(String tableName) {
        return "DROP TABLE IF EXISTS " + tableName;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        SqoopOptions options = new SqoopOptions(MySQLTestUtils.CONNECT_STRING, this.getTableName());
        options.setUsername(MySQLTestUtils.getCurrentUser());
        this.manager = new MySQLManager(options);
        try {
            this.conn = this.manager.getConnection();
            this.conn.setAutoCommit(false);
        }
        catch (SQLException sqlE) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)sqlE));
            JdbcMySQLExportTest.fail((String)("Failed with sql exception in setup: " + sqlE));
        }
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        if (null != this.conn) {
            try {
                this.conn.close();
            }
            catch (SQLException sqlE) {
                LOG.error((Object)("Got SQLException closing conn: " + sqlE.toString()));
            }
        }
        if (null != this.manager) {
            try {
                this.manager.close();
                this.manager = null;
            }
            catch (SQLException sqlE) {
                LOG.error((Object)("Got SQLException: " + sqlE.toString()));
                JdbcMySQLExportTest.fail((String)("Got SQLException: " + sqlE.toString()));
            }
        }
    }

    @Override
    protected String[] getCodeGenArgv(String ... extraArgs) {
        String[] moreArgs = new String[extraArgs.length + 2];
        int i = 0;
        for (i = 0; i < extraArgs.length; ++i) {
            moreArgs[i] = extraArgs[i];
        }
        moreArgs[i++] = "--username";
        moreArgs[i++] = MySQLTestUtils.getCurrentUser();
        return super.getCodeGenArgv(moreArgs);
    }

    @Override
    protected String[] getArgv(boolean includeHadoopFlags, int rowsPerStatement, int statementsPerTx, String ... additionalArgv) {
        String[] subArgv = this.newStrArray(additionalArgv, "--username", MySQLTestUtils.getCurrentUser());
        return super.getArgv(includeHadoopFlags, rowsPerStatement, statementsPerTx, subArgv);
    }

    public void testIntColInBatchMode() throws IOException, SQLException {
        int TOTAL_RECORDS = 10;
        TestExport.ColumnGenerator gen = new TestExport.ColumnGenerator(){

            @Override
            public String getExportText(int rowNum) {
                return "" + rowNum;
            }

            @Override
            public String getVerifyText(int rowNum) {
                return "" + rowNum;
            }

            @Override
            public String getType() {
                return "INTEGER";
            }
        };
        this.createTextFile(0, 10, false, gen);
        this.createTable(gen);
        this.runExport(this.getArgv(true, 10, 10, "--batch"));
        this.verifyExport(10);
        this.assertColMinAndMax(this.forIdx(0), gen);
    }

    public void testUpsert() throws IOException, SQLException {
        int TOTAL_RECORDS = 10;
        this.createTextFile(0, 10, false, new TestExport.ColumnGenerator[0]);
        this.createTable(new TestExport.ColumnGenerator[0]);
        this.runExport(this.getArgv(true, 10, 10, "--update-key", "id", "--update-mode", "allowinsert"));
        this.verifyExport(10);
        this.runExport(this.getArgv(true, 10, 10, "--update-key", "id", "--update-mode", "allowinsert"));
        this.verifyExport(10);
        this.createTextFile(0, 20, false, new TestExport.ColumnGenerator[0]);
        this.runExport(this.getArgv(true, 10, 10, "--update-key", "id", "--update-mode", "allowinsert"));
        this.verifyExport(20);
    }
}

