/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.Db2Manager;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.util.FileListing;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DB2ManagerImportManualTest
extends ImportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)DB2ManagerImportManualTest.class.getName());
    static final String HOST_URL = System.getProperty("sqoop.test.db2.connectstring.host_url", "jdbc:db2://db2host:50000");
    static final String DATABASE_NAME = "SQOOP";
    static final String DATABASE_USER = "SQOOP";
    static final String DATABASE_PASSWORD = "PASSWORD";
    static final String TABLE_NAME = "EMPLOYEES_DB2";
    static final String QUALIFIED_TABLE_NAME = "PREFIX.EMPLOYEES_DB2";
    static final String CONNECT_STRING = HOST_URL + "/" + "SQOOP" + ":currentSchema=" + "SQOOP" + ";";
    private Db2Manager manager;
    private boolean useQualifiedTableName;
    private boolean useDefaultConnectManager;

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getTableName() {
        return this.useQualifiedTableName ? QUALIFIED_TABLE_NAME : TABLE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() {
        super.setUp();
        SqoopOptions options = new SqoopOptions(CONNECT_STRING, this.getTableName());
        options.setUsername("SQOOP");
        options.setPassword(DATABASE_PASSWORD);
        this.manager = new Db2Manager(options);
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.manager.getConnection();
            stmt = conn.createStatement();
            stmt.execute("DROP TABLE " + this.getTableName());
        }
        catch (SQLException sqlE) {
            LOG.info((Object)("Table was not dropped: " + sqlE.getMessage()));
        }
        finally {
            try {
                if (null != stmt) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while closing stmt", (Throwable)ex);
            }
        }
        try {
            conn = this.manager.getConnection();
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            stmt.executeUpdate("CREATE TABLE " + this.getTableName() + " (" + "id INT NOT NULL, " + "name VARCHAR(24) NOT NULL, " + "salary FLOAT, " + "dept VARCHAR(32), " + "PRIMARY KEY (id))");
            stmt.executeUpdate("INSERT INTO " + this.getTableName() + " VALUES(" + "1,'Aaron', " + "1000000.00,'engineering')");
            stmt.executeUpdate("INSERT INTO " + this.getTableName() + " VALUES(" + "2,'Bob', " + "400.00,'sales')");
            stmt.executeUpdate("INSERT INTO " + this.getTableName() + " VALUES(" + "3,'Fred', 15.00," + "'marketing')");
            conn.commit();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)"Encountered SQL Exception: ", (Throwable)sqlE);
            sqlE.printStackTrace();
            DB2ManagerImportManualTest.fail((String)("SQLException when running test setUp(): " + sqlE));
        }
        finally {
            try {
                if (null != stmt) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while closing connection/stmt", (Throwable)ex);
            }
        }
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        try {
            this.manager.close();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            DB2ManagerImportManualTest.fail((String)("Got SQLException: " + sqlE.toString()));
        }
    }

    @Test
    public void testDb2Import() throws IOException {
        this.useQualifiedTableName = false;
        this.useDefaultConnectManager = true;
        this.runDb2Test(this.getExpectedResults());
        this.useDefaultConnectManager = false;
        this.runDb2Test(this.getExpectedResults());
    }

    @Test
    public void testDb2ImportQualifiedTableName() throws IOException {
        this.useQualifiedTableName = true;
        this.useDefaultConnectManager = true;
        this.runDb2Test(this.getExpectedResults());
        this.useDefaultConnectManager = false;
        this.runDb2Test(this.getExpectedResults());
    }

    private String[] getExpectedResults() {
        return new String[]{"1,Aaron,1000000.0,engineering", "2,Bob,400.0,sales", "3,Fred,15.0,marketing"};
    }

    private String[] getArgv() {
        ArrayList<String> args = new ArrayList<String>();
        CommonArgs.addHadoopFlags(args);
        args.add("--table");
        args.add(this.getTableName());
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(CONNECT_STRING);
        args.add("--username");
        args.add("SQOOP");
        args.add("--password");
        args.add(DATABASE_PASSWORD);
        args.add("--num-mappers");
        args.add("1");
        if (this.useDefaultConnectManager) {
            args.add("--driver");
            args.add("com.ibm.db2.jcc.DB2Driver");
        }
        return args.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDb2Test(String[] expectedResults) throws IOException {
        Path warehousePath = new Path(this.getWarehouseDir());
        Path tablePath = new Path(warehousePath, this.getTableName());
        Path filePath = new Path(tablePath, "part-m-00000");
        File tableFile = new File(tablePath.toString());
        if (tableFile.exists() && tableFile.isDirectory()) {
            FileListing.recursiveDeleteDir((File)tableFile);
        }
        String[] argv = this.getArgv();
        try {
            this.runImport(argv);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Got IOException during import: " + ioe.toString()));
            ioe.printStackTrace();
            DB2ManagerImportManualTest.fail((String)ioe.toString());
        }
        File f = new File(filePath.toString());
        DB2ManagerImportManualTest.assertTrue((String)"Could not find imported data file", (boolean)f.exists());
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            for (String expectedLine : expectedResults) {
                DB2ManagerImportManualTest.assertEquals((String)expectedLine, (String)r.readLine());
            }
        }
        catch (IOException ioe) {
            try {
                LOG.error((Object)("Got IOException verifying results: " + ioe.toString()));
                ioe.printStackTrace();
                DB2ManagerImportManualTest.fail((String)ioe.toString());
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(r);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)r);
        }
        IOUtils.closeStream((Closeable)r);
    }
}

