/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.io;

import com.cloudera.sqoop.io.NamedFifo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;

public class TestNamedFifo
extends TestCase {
    public static final Log LOG = LogFactory.getLog((String)TestNamedFifo.class.getName());
    public static final Path TEMP_BASE_DIR;
    private Configuration conf;
    private FileSystem fs;
    static final String MSG = "THIS IS THE MESSAGE\n";
    static final String MSG2 = "Here is a follow-up.\n";

    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.set("fs.default.name", "file:///");
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.fs.mkdirs(TEMP_BASE_DIR);
    }

    public void testNamedFifo() throws Exception {
        File root = new File(TEMP_BASE_DIR.toString());
        File fifo = new File(root, "foo-fifo");
        NamedFifo nf = new NamedFifo(fifo);
        nf.create();
        File returned = nf.getFile();
        TestNamedFifo.assertEquals((Object)fifo, (Object)returned);
        ReaderThread rt = new ReaderThread(returned);
        WriterThread wt = new WriterThread(returned);
        rt.start();
        wt.start();
        rt.join();
        wt.join();
        IOException rex = rt.getException();
        IOException wex = wt.getException();
        if (null != rex) {
            LOG.error((Object)("reader exception: " + StringUtils.stringifyException((Throwable)rex)));
        }
        if (null != wex) {
            LOG.error((Object)("writer exception: " + StringUtils.stringifyException((Throwable)wex)));
        }
        TestNamedFifo.assertNull((Object)rex);
        TestNamedFifo.assertNull((Object)wex);
    }

    static {
        String tmpDir = System.getProperty("test.build.data", "/tmp/");
        if (!tmpDir.endsWith(File.separator)) {
            tmpDir = tmpDir + File.separator;
        }
        TEMP_BASE_DIR = new Path(new Path(tmpDir), "namedfifo");
    }

    private static class WriterThread
    extends Thread {
        private File file;
        private IOException exception;

        public WriterThread(File f) {
            this.file = f;
        }

        public IOException getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedWriter w = null;
            try {
                w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.file)));
                w.write(TestNamedFifo.MSG);
                w.flush();
                w.write(TestNamedFifo.MSG2);
            }
            catch (IOException ioe) {
                this.exception = ioe;
            }
            finally {
                if (null != w) {
                    try {
                        w.close();
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("Error closing writer: " + ioe));
                    }
                }
            }
        }
    }

    private static class ReaderThread
    extends Thread {
        private File file;
        private IOException exception;

        public ReaderThread(File f) {
            this.file = f;
        }

        public IOException getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader r = null;
            try {
                r = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
                String line = r.readLine();
                if (!TestNamedFifo.MSG.trim().equals(line)) {
                    throw new IOException("Expected " + TestNamedFifo.MSG.trim() + " but got " + line);
                }
                line = r.readLine();
                if (null == line) {
                    throw new IOException("line2 was null");
                }
                if (!TestNamedFifo.MSG2.trim().equals(line)) {
                    throw new IOException("Expected " + TestNamedFifo.MSG2.trim() + " but got " + line);
                }
            }
            catch (IOException ioe) {
                this.exception = ioe;
            }
            finally {
                if (null != r) {
                    try {
                        r.close();
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)("Error closing reader: " + ioe));
                    }
                }
            }
        }
    }
}

