/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.hive;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.hive.TableDefWriter;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.tool.ImportTool;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.util.SqlTypeMap;

public class TestTableDefWriter
extends TestCase {
    public static final Log LOG = LogFactory.getLog((String)TestTableDefWriter.class.getName());

    private void expectExceptionInCharCode(int charCode) {
        try {
            TableDefWriter.getHiveOctalCharCode((int)charCode);
            TestTableDefWriter.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testHiveOctalCharCode() {
        TestTableDefWriter.assertEquals((String)"\\000", (String)TableDefWriter.getHiveOctalCharCode((int)0));
        TestTableDefWriter.assertEquals((String)"\\001", (String)TableDefWriter.getHiveOctalCharCode((int)1));
        TestTableDefWriter.assertEquals((String)"\\012", (String)TableDefWriter.getHiveOctalCharCode((int)10));
        TestTableDefWriter.assertEquals((String)"\\177", (String)TableDefWriter.getHiveOctalCharCode((int)127));
        this.expectExceptionInCharCode(4096);
        this.expectExceptionInCharCode(128);
        this.expectExceptionInCharCode(254);
    }

    public void testDifferentTableNames() throws Exception {
        Configuration conf = new Configuration();
        SqoopOptions options = new SqoopOptions();
        TableDefWriter writer = new TableDefWriter(options, null, "inputTable", "outputTable", conf, false);
        SqlTypeMap colTypes = new SqlTypeMap();
        writer.setColumnTypes((Map)colTypes);
        String createTable = writer.getCreateTableStmt();
        String loadData = writer.getLoadDataStmt();
        LOG.debug((Object)("Create table stmt: " + createTable));
        LOG.debug((Object)("Load data stmt: " + loadData));
        TestTableDefWriter.assertTrue((createTable.indexOf("CREATE TABLE IF NOT EXISTS `outputTable`") != -1 ? 1 : 0) != 0);
        TestTableDefWriter.assertTrue((loadData.indexOf("INTO TABLE `outputTable`") != -1 ? 1 : 0) != 0);
        TestTableDefWriter.assertTrue((loadData.indexOf("/inputTable'") != -1 ? 1 : 0) != 0);
    }

    public void testDifferentTargetDirs() throws Exception {
        String targetDir = "targetDir";
        String inputTable = "inputTable";
        String outputTable = "outputTable";
        Configuration conf = new Configuration();
        SqoopOptions options = new SqoopOptions();
        options.setTargetDir(targetDir);
        TableDefWriter writer = new TableDefWriter(options, null, inputTable, outputTable, conf, false);
        SqlTypeMap colTypes = new SqlTypeMap();
        writer.setColumnTypes((Map)colTypes);
        String createTable = writer.getCreateTableStmt();
        String loadData = writer.getLoadDataStmt();
        LOG.debug((Object)("Create table stmt: " + createTable));
        LOG.debug((Object)("Load data stmt: " + loadData));
        TestTableDefWriter.assertTrue((createTable.indexOf("CREATE TABLE IF NOT EXISTS `" + outputTable + "`") != -1 ? 1 : 0) != 0);
        TestTableDefWriter.assertTrue((loadData.indexOf("INTO TABLE `" + outputTable + "`") != -1 ? 1 : 0) != 0);
        TestTableDefWriter.assertTrue((loadData.indexOf("/" + targetDir + "'") != -1 ? 1 : 0) != 0);
    }

    public void testPartitions() throws Exception {
        String[] args = new String[]{"--hive-partition-key", "ds", "--hive-partition-value", "20110413"};
        Configuration conf = new Configuration();
        SqoopOptions options = new ImportTool().parseArguments(args, null, null, false);
        TableDefWriter writer = new TableDefWriter(options, null, "inputTable", "outputTable", conf, false);
        SqlTypeMap colTypes = new SqlTypeMap();
        writer.setColumnTypes((Map)colTypes);
        String createTable = writer.getCreateTableStmt();
        String loadData = writer.getLoadDataStmt();
        TestTableDefWriter.assertNotNull((Object)createTable);
        TestTableDefWriter.assertNotNull((Object)loadData);
        TestTableDefWriter.assertEquals((String)"CREATE TABLE IF NOT EXISTS `outputTable` ( ) PARTITIONED BY (ds STRING) ROW FORMAT DELIMITED FIELDS TERMINATED BY '\\054' LINES TERMINATED BY '\\012' STORED AS TEXTFILE", (String)createTable);
        TestTableDefWriter.assertTrue((boolean)loadData.endsWith(" PARTITION (ds='20110413')"));
    }

    public void testLzoSplitting() throws Exception {
        String[] args = new String[]{"--compress", "--compression-codec", "lzop"};
        Configuration conf = new Configuration();
        SqoopOptions options = new ImportTool().parseArguments(args, null, null, false);
        TableDefWriter writer = new TableDefWriter(options, null, "inputTable", "outputTable", conf, false);
        SqlTypeMap colTypes = new SqlTypeMap();
        writer.setColumnTypes((Map)colTypes);
        String createTable = writer.getCreateTableStmt();
        String loadData = writer.getLoadDataStmt();
        TestTableDefWriter.assertNotNull((Object)createTable);
        TestTableDefWriter.assertNotNull((Object)loadData);
        TestTableDefWriter.assertEquals((String)"CREATE TABLE IF NOT EXISTS `outputTable` ( ) ROW FORMAT DELIMITED FIELDS TERMINATED BY '\\054' LINES TERMINATED BY '\\012' STORED AS INPUTFORMAT 'com.hadoop.mapred.DeprecatedLzoTextInputFormat' OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'", (String)createTable);
    }

    public void testUserMapping() throws Exception {
        String[] args = new String[]{"--map-column-hive", "id=STRING,value=INTEGER"};
        Configuration conf = new Configuration();
        SqoopOptions options = new ImportTool().parseArguments(args, null, null, false);
        TableDefWriter writer = new TableDefWriter(options, null, HsqldbTestServer.getTableName(), "outputTable", conf, false);
        SqlTypeMap colTypes = new SqlTypeMap();
        colTypes.put("id", 4);
        colTypes.put("value", 12);
        writer.setColumnTypes((Map)colTypes);
        String createTable = writer.getCreateTableStmt();
        TestTableDefWriter.assertNotNull((Object)createTable);
        TestTableDefWriter.assertTrue((boolean)createTable.contains("`id` STRING"));
        TestTableDefWriter.assertTrue((boolean)createTable.contains("`value` INTEGER"));
        TestTableDefWriter.assertFalse((boolean)createTable.contains("`id` INTEGER"));
        TestTableDefWriter.assertFalse((boolean)createTable.contains("`value` STRING"));
    }

    public void testUserMappingFailWhenCantBeApplied() throws Exception {
        String[] args = new String[]{"--map-column-hive", "id=STRING,value=INTEGER"};
        Configuration conf = new Configuration();
        SqoopOptions options = new ImportTool().parseArguments(args, null, null, false);
        TableDefWriter writer = new TableDefWriter(options, null, HsqldbTestServer.getTableName(), "outputTable", conf, false);
        SqlTypeMap colTypes = new SqlTypeMap();
        colTypes.put("id", 4);
        writer.setColumnTypes((Map)colTypes);
        try {
            String createTable = writer.getCreateTableStmt();
            TestTableDefWriter.fail((String)"Expected failure on non applied mapping.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }
}

