/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.hbase;

import com.cloudera.sqoop.hbase.HBaseTestCase;
import com.cloudera.sqoop.hbase.HBaseUtil;
import java.io.IOException;
import org.junit.Test;

public class HBaseImportTest
extends HBaseTestCase {
    @Test
    public void testBasicUsage() throws IOException {
        String[] argv = this.getArgv(true, "BasicUsage", "BasicColFam", true, null);
        String[] types = new String[]{"INT", "INT"};
        String[] vals = new String[]{"0", "1"};
        this.createTableWithColTypes(types, vals);
        this.runImport(argv);
        this.verifyHBaseCell("BasicUsage", "0", "BasicColFam", this.getColName(1), "1");
    }

    @Test
    public void testMissingTableFails() throws IOException {
        String[] argv = this.getArgv(true, "MissingTable", "MissingFam", false, null);
        String[] types = new String[]{"INT", "INT"};
        String[] vals = new String[]{"0", "1"};
        this.createTableWithColTypes(types, vals);
        try {
            this.runImport(argv);
            HBaseImportTest.fail((String)"Expected IOException");
        }
        catch (IOException ioe) {
            LOG.info((Object)"Got exception -- ok; we expected that job to fail.");
        }
    }

    @Test
    public void testOverwriteSucceeds() throws IOException {
        String[] argv = this.getArgv(true, "OverwriteT", "OverwriteF", true, null);
        String[] types = new String[]{"INT", "INT"};
        String[] vals = new String[]{"0", "1"};
        this.createTableWithColTypes(types, vals);
        this.runImport(argv);
        this.verifyHBaseCell("OverwriteT", "0", "OverwriteF", this.getColName(1), "1");
        this.runImport(argv);
        this.verifyHBaseCell("OverwriteT", "0", "OverwriteF", this.getColName(1), "1");
    }

    @Test
    public void testStrings() throws IOException {
        String[] argv = this.getArgv(true, "stringT", "stringF", true, null);
        String[] types = new String[]{"INT", "VARCHAR(32)"};
        String[] vals = new String[]{"0", "'abc'"};
        this.createTableWithColTypes(types, vals);
        this.runImport(argv);
        this.verifyHBaseCell("stringT", "0", "stringF", this.getColName(1), "abc");
    }

    @Test
    public void testNulls() throws IOException {
        String[] argv = this.getArgv(true, "nullT", "nullF", true, null);
        String[] types = new String[]{"INT", "INT", "INT"};
        String[] vals = new String[]{"0", "42", "null"};
        this.createTableWithColTypes(types, vals);
        this.runImport(argv);
        this.verifyHBaseCell("nullT", "0", "nullF", this.getColName(1), "42");
        this.verifyHBaseCell("nullT", "0", "nullF", this.getColName(2), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExitFailure() throws IOException {
        String[] types = new String[]{"INT", "INT", "INT"};
        String[] vals = new String[]{"0", "42", "43"};
        this.createTableWithColTypes(types, vals);
        String[] argv = this.getArgv(true, "NoHBaseT", "NoHBaseF", true, null);
        try {
            HBaseUtil.setAlwaysNoHBaseJarMode((boolean)true);
            this.runImport(argv);
        }
        catch (IOException e) {
            return;
        }
        finally {
            HBaseUtil.setAlwaysNoHBaseJarMode((boolean)false);
        }
        HBaseImportTest.fail((String)"should have gotten exception");
    }

    @Test
    public void testNullRow() throws IOException {
        String[] argv = this.getArgv(true, "nullRowT", "nullRowF", true, null);
        String[] types = new String[]{"INT", "INT"};
        String[] vals = new String[]{"0", "null"};
        this.createTableWithColTypes(types, vals);
        this.runImport(argv);
        this.verifyHBaseCell("nullRowT", "0", "nullRowF", this.getColName(1), null);
        int rowCount = this.countHBaseTable("nullRowT", "nullRowF");
        HBaseImportTest.assertEquals((int)0, (int)rowCount);
    }

    @Test
    public void testAddRowKey() throws IOException {
        String[] types = new String[]{"INT", "INT"};
        String[] vals = new String[]{"0", "1"};
        this.createTableWithColTypes(types, vals);
        String[] otherArg = this.getArgv(true, "addRowKeyT", "addRowKeyF", true, null);
        String[] argv = new String[otherArg.length + 2];
        argv[0] = "-D";
        argv[1] = "sqoop.hbase.add.row.key=true";
        System.arraycopy(otherArg, 0, argv, 2, otherArg.length);
        this.runImport(argv);
        this.verifyHBaseCell("addRowKeyT", "0", "addRowKeyF", this.getColName(0), "0");
        this.verifyHBaseCell("addRowKeyT", "0", "addRowKeyF", this.getColName(1), "1");
    }

    @Test
    public void testAddRowKeyDefault() throws IOException {
        String[] types = new String[]{"INT", "INT"};
        String[] vals = new String[]{"0", "1"};
        this.createTableWithColTypes(types, vals);
        String[] argv = this.getArgv(true, "addRowKeyDfT", "addRowKeyDfF", true, null);
        this.runImport(argv);
        this.verifyHBaseCell("addRowKeyDfT", "0", "addRowKeyDfF", this.getColName(0), null);
        this.verifyHBaseCell("addRowKeyDfT", "0", "addRowKeyDfF", this.getColName(1), "1");
    }
}

