/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.Sqoop;
import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.HsqldbManager;
import com.cloudera.sqoop.manager.ManagerFactory;
import com.cloudera.sqoop.metastore.JobData;
import com.cloudera.sqoop.metastore.TestSavedJobs;
import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.tool.JobTool;
import com.cloudera.sqoop.tool.SqoopTool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;

public class TestIncrementalImport
extends TestCase {
    public static final Log LOG = LogFactory.getLog((String)TestIncrementalImport.class.getName());
    public static final String SOURCE_DB_URL = "jdbc:hsqldb:mem:incremental";

    public void setUp() throws Exception {
        TestSavedJobs.resetJobSchema();
        TestIncrementalImport.resetSourceDataSchema();
    }

    public static void resetSourceDataSchema() throws SQLException {
        SqoopOptions options = new SqoopOptions();
        options.setConnectString(SOURCE_DB_URL);
        TestSavedJobs.resetSchema(options);
    }

    public static Configuration newConf() {
        return TestSavedJobs.newConf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertRowCount(String table, int numRows) throws SQLException {
        SqoopOptions options = new SqoopOptions();
        options.setConnectString(SOURCE_DB_URL);
        HsqldbManager manager = new HsqldbManager(options);
        Connection c = manager.getConnection();
        Statement s = null;
        ResultSet rs = null;
        try {
            s = c.prepareStatement("SELECT COUNT(*) FROM " + table);
            rs = s.executeQuery();
            if (!rs.next()) {
                TestIncrementalImport.fail((String)"No resultset");
            }
            int realNumRows = rs.getInt(1);
            TestIncrementalImport.assertEquals((int)numRows, (int)realNumRows);
            LOG.info((Object)("Expected " + numRows + " rows -- ok."));
        }
        finally {
            if (null != s) {
                try {
                    s.close();
                }
                catch (SQLException sqlE) {
                    LOG.warn((Object)("exception: " + sqlE));
                }
            }
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException sqlE) {
                    LOG.warn((Object)("exception: " + sqlE));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIdRows(String tableName, int low, int hi) throws SQLException {
        SqoopOptions options = new SqoopOptions();
        options.setConnectString(SOURCE_DB_URL);
        HsqldbManager manager = new HsqldbManager(options);
        Connection c = manager.getConnection();
        Statement s = null;
        try {
            s = c.prepareStatement("INSERT INTO " + tableName + " VALUES(?)");
            for (int i = low; i < hi; ++i) {
                s.setInt(1, i);
                s.executeUpdate();
            }
            c.commit();
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIdTimestampRows(String tableName, int low, int hi, Timestamp ts) throws SQLException {
        LOG.info((Object)("Inserting id rows in [" + low + ", " + hi + ") @ " + ts));
        SqoopOptions options = new SqoopOptions();
        options.setConnectString(SOURCE_DB_URL);
        HsqldbManager manager = new HsqldbManager(options);
        Connection c = manager.getConnection();
        Statement s = null;
        try {
            s = c.prepareStatement("INSERT INTO " + tableName + " VALUES(?,?)");
            for (int i = low; i < hi; ++i) {
                s.setInt(1, i);
                s.setTimestamp(2, ts);
                s.executeUpdate();
            }
            c.commit();
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIdTable(String tableName, int insertRows) throws SQLException {
        SqoopOptions options = new SqoopOptions();
        options.setConnectString(SOURCE_DB_URL);
        HsqldbManager manager = new HsqldbManager(options);
        Connection c = manager.getConnection();
        Statement s = null;
        try {
            s = c.prepareStatement("CREATE TABLE " + tableName + "(id INT NOT NULL)");
            s.executeUpdate();
            c.commit();
            this.insertIdRows(tableName, 0, insertRows);
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTimestampTable(String tableName, int insertRows, Timestamp baseTime) throws SQLException {
        SqoopOptions options = new SqoopOptions();
        options.setConnectString(SOURCE_DB_URL);
        HsqldbManager manager = new HsqldbManager(options);
        Connection c = manager.getConnection();
        Statement s = null;
        try {
            s = c.prepareStatement("CREATE TABLE " + tableName + "(id INT NOT NULL, " + "last_modified TIMESTAMP)");
            s.executeUpdate();
            c.commit();
            this.insertIdTimestampRows(tableName, 0, insertRows, baseTime);
        }
        finally {
            s.close();
        }
    }

    public void clearDir(String tableName) {
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
            Path warehouse = new Path(BaseSqoopTestCase.LOCAL_WAREHOUSE_DIR);
            Path tableDir = new Path(warehouse, tableName);
            fs.delete(tableDir, true);
        }
        catch (Exception e) {
            TestIncrementalImport.fail((String)("Got unexpected exception: " + StringUtils.stringifyException((Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertDirOfNumbers(String tableName, int expectedNums) {
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
            Path warehouse = new Path(BaseSqoopTestCase.LOCAL_WAREHOUSE_DIR);
            Path tableDir = new Path(warehouse, tableName);
            FileStatus[] stats = fs.listStatus(tableDir);
            Object[] fileNames = new String[stats.length];
            for (int i = 0; i < stats.length; ++i) {
                fileNames[i] = stats[i].getPath().toString();
            }
            Arrays.sort(fileNames);
            ArrayList<String> receivedNums = new ArrayList<String>();
            block6: for (Object fileName : fileNames) {
                if (((String)fileName).startsWith("_") || ((String)fileName).startsWith(".")) continue;
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path((String)fileName))));
                try {
                    while (true) {
                        String s;
                        if (null == (s = r.readLine())) {
                            continue block6;
                        }
                        receivedNums.add(s.trim());
                    }
                }
                finally {
                    r.close();
                }
            }
            TestIncrementalImport.assertEquals((int)expectedNums, (int)receivedNums.size());
            for (int i = 0; i < expectedNums; ++i) {
                TestIncrementalImport.assertEquals((int)i, (int)Integer.valueOf((String)receivedNums.get(i)));
            }
        }
        catch (Exception e) {
            TestIncrementalImport.fail((String)("Got unexpected exception: " + StringUtils.stringifyException((Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertSpecificNumber(String tableName, int val) {
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
            Path warehouse = new Path(BaseSqoopTestCase.LOCAL_WAREHOUSE_DIR);
            Path tableDir = new Path(warehouse, tableName);
            FileStatus[] stats = fs.listStatus(tableDir);
            String[] filePaths = new String[stats.length];
            for (int i = 0; i < stats.length; ++i) {
                filePaths[i] = stats[i].getPath().toString();
            }
            boolean foundVal = false;
            for (String filePath : filePaths) {
                String fileName = new Path(filePath).getName();
                if (fileName.startsWith("_") || fileName.startsWith(".")) continue;
                if (foundVal) {
                    TestIncrementalImport.fail((String)"Got an extra data-containing file in this directory.");
                }
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(filePath))));
                try {
                    String s = r.readLine();
                    if (null == s) {
                        TestIncrementalImport.fail((String)("Unexpected empty file " + filePath + "."));
                    }
                    TestIncrementalImport.assertEquals((int)val, (int)Integer.valueOf(s.trim()));
                    String nextLine = r.readLine();
                    if (nextLine != null) {
                        TestIncrementalImport.fail((String)("Expected only one result, but got another line: " + nextLine));
                    }
                    foundVal = true;
                }
                finally {
                    r.close();
                }
            }
        }
        catch (IOException e) {
            TestIncrementalImport.fail((String)("Got unexpected exception: " + StringUtils.stringifyException((Throwable)e)));
        }
    }

    public void runImport(SqoopOptions options, List<String> args) {
        try {
            Sqoop importer = new Sqoop((SqoopTool)new ImportTool(), options.getConf(), options);
            int ret = Sqoop.runSqoop((Sqoop)importer, (String[])args.toArray(new String[0]));
            TestIncrementalImport.assertEquals((String)"Failure during job", (int)0, (int)ret);
        }
        catch (Exception e) {
            LOG.error((Object)("Got exception running Sqoop: " + StringUtils.stringifyException((Throwable)e)));
            throw new RuntimeException(e);
        }
    }

    private List<String> getArgListForTable(String tableName, boolean commonArgs, boolean isAppend) {
        return this.getArgListForTable(tableName, commonArgs, isAppend, false);
    }

    private List<String> getArgListForTable(String tableName, boolean commonArgs, boolean isAppend, boolean appendTimestamp) {
        ArrayList<String> args = new ArrayList<String>();
        if (commonArgs) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--connect");
        args.add(SOURCE_DB_URL);
        args.add("--table");
        args.add(tableName);
        args.add("--warehouse-dir");
        args.add(BaseSqoopTestCase.LOCAL_WAREHOUSE_DIR);
        if (isAppend) {
            args.add("--incremental");
            args.add("append");
            if (!appendTimestamp) {
                args.add("--check-column");
                args.add("id");
            } else {
                args.add("--check-column");
                args.add("last_modified");
            }
        } else {
            args.add("--incremental");
            args.add("lastmodified");
            args.add("--check-column");
            args.add("last_modified");
        }
        args.add("--columns");
        args.add("id");
        args.add("-m");
        args.add("1");
        return args;
    }

    private List<String> getArgListForQuery(String query, String directoryName, boolean commonArgs, boolean isAppend, boolean appendTimestamp) {
        ArrayList<String> args = new ArrayList<String>();
        if (commonArgs) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--connect");
        args.add(SOURCE_DB_URL);
        args.add("--query");
        args.add(query);
        args.add("--target-dir");
        args.add(BaseSqoopTestCase.LOCAL_WAREHOUSE_DIR + System.getProperty("file.separator") + directoryName);
        if (isAppend) {
            args.add("--incremental");
            args.add("append");
            if (!appendTimestamp) {
                args.add("--check-column");
                args.add("id");
            } else {
                args.add("--check-column");
                args.add("last_modified");
            }
        } else {
            args.add("--incremental");
            args.add("lastmodified");
            args.add("--check-column");
            args.add("last_modified");
        }
        args.add("-m");
        args.add("1");
        return args;
    }

    private void createJob(String jobName, List<String> jobArgs) {
        this.createJob(jobName, jobArgs, TestIncrementalImport.newConf());
    }

    private void createJob(String jobName, List<String> jobArgs, Configuration conf) {
        try {
            SqoopOptions options = new SqoopOptions();
            options.setConf(conf);
            Sqoop makeJob = new Sqoop((SqoopTool)new JobTool(), conf, options);
            ArrayList<String> args = new ArrayList<String>();
            args.add("--create");
            args.add(jobName);
            args.add("--");
            args.add("import");
            args.addAll(jobArgs);
            int ret = Sqoop.runSqoop((Sqoop)makeJob, (String[])args.toArray(new String[0]));
            TestIncrementalImport.assertEquals((String)"Failure to create job", (int)0, (int)ret);
        }
        catch (Exception e) {
            LOG.error((Object)("Got exception running Sqoop to create job: " + StringUtils.stringifyException((Throwable)e)));
            throw new RuntimeException(e);
        }
    }

    private void runJob(String jobName) {
        this.runJob(jobName, TestIncrementalImport.newConf());
    }

    private void runJob(String jobName, Configuration conf) {
        try {
            SqoopOptions options = new SqoopOptions();
            options.setConf(conf);
            Sqoop runJob = new Sqoop((SqoopTool)new JobTool(), conf, options);
            ArrayList<String> args = new ArrayList<String>();
            args.add("--exec");
            args.add(jobName);
            int ret = Sqoop.runSqoop((Sqoop)runJob, (String[])args.toArray(new String[0]));
            TestIncrementalImport.assertEquals((String)"Failure to run job", (int)0, (int)ret);
        }
        catch (Exception e) {
            LOG.error((Object)("Got exception running Sqoop to run job: " + StringUtils.stringifyException((Throwable)e)));
            throw new RuntimeException(e);
        }
    }

    public void testEmptyAppendImport() throws Exception {
        String TABLE_NAME = "emptyAppend1";
        this.createIdTable("emptyAppend1", 0);
        List<String> args = this.getArgListForTable("emptyAppend1", true, true);
        Configuration conf = TestIncrementalImport.newConf();
        SqoopOptions options = new SqoopOptions();
        options.setConf(conf);
        this.runImport(options, args);
        this.assertDirOfNumbers("emptyAppend1", 0);
    }

    public void testFullAppendImport() throws Exception {
        String TABLE_NAME = "fullAppend1";
        this.createIdTable("fullAppend1", 10);
        List<String> args = this.getArgListForTable("fullAppend1", true, true);
        Configuration conf = TestIncrementalImport.newConf();
        SqoopOptions options = new SqoopOptions();
        options.setConf(conf);
        this.runImport(options, args);
        this.assertDirOfNumbers("fullAppend1", 10);
    }

    public void testEmptyJobAppend() throws Exception {
        String TABLE_NAME = "emptyJob";
        this.createIdTable("emptyJob", 0);
        List<String> args = this.getArgListForTable("emptyJob", false, true);
        this.createJob("emptyJob", args);
        this.runJob("emptyJob");
        this.assertDirOfNumbers("emptyJob", 0);
        this.runJob("emptyJob");
        this.assertDirOfNumbers("emptyJob", 0);
    }

    public void testEmptyThenFullJobAppend() throws Exception {
        String TABLE_NAME = "emptyThenFull";
        this.createIdTable("emptyThenFull", 0);
        List<String> args = this.getArgListForTable("emptyThenFull", false, true);
        this.createJob("emptyThenFull", args);
        this.runJob("emptyThenFull");
        this.assertDirOfNumbers("emptyThenFull", 0);
        this.insertIdRows("emptyThenFull", 0, 10);
        this.runJob("emptyThenFull");
        this.assertDirOfNumbers("emptyThenFull", 10);
        this.insertIdRows("emptyThenFull", 10, 20);
        this.runJob("emptyThenFull");
        this.assertDirOfNumbers("emptyThenFull", 20);
    }

    public void testEmptyThenFullJobAppendWithQuery() throws Exception {
        String TABLE_NAME = "withQuery";
        this.createIdTable("withQuery", 0);
        this.clearDir("withQuery");
        String QUERY = "SELECT id FROM withQuery WHERE $CONDITIONS";
        List<String> args = this.getArgListForQuery("SELECT id FROM withQuery WHERE $CONDITIONS", "withQuery", false, true, false);
        this.createJob("withQuery", args);
        this.runJob("withQuery");
        this.assertDirOfNumbers("withQuery", 0);
        this.insertIdRows("withQuery", 0, 10);
        this.runJob("withQuery");
        this.assertDirOfNumbers("withQuery", 10);
        this.insertIdRows("withQuery", 10, 20);
        this.runJob("withQuery");
        this.assertDirOfNumbers("withQuery", 20);
    }

    public void testAppend() throws Exception {
        String TABLE_NAME = "append";
        this.createIdTable("append", 10);
        List<String> args = this.getArgListForTable("append", false, true);
        this.createJob("append", args);
        this.runJob("append");
        this.assertDirOfNumbers("append", 10);
        this.insertIdRows("append", 10, 20);
        this.runJob("append");
        this.assertDirOfNumbers("append", 20);
    }

    public void testEmptyLastModified() throws Exception {
        String TABLE_NAME = "emptyLastModified";
        this.createTimestampTable("emptyLastModified", 0, null);
        List<String> args = this.getArgListForTable("emptyLastModified", true, false);
        Configuration conf = TestIncrementalImport.newConf();
        SqoopOptions options = new SqoopOptions();
        options.setConf(conf);
        this.runImport(options, args);
        this.assertDirOfNumbers("emptyLastModified", 0);
    }

    public void testFullLastModifiedImport() throws Exception {
        String TABLE_NAME = "fullLastModified";
        Timestamp thePast = new Timestamp(System.currentTimeMillis() - 100L);
        this.createTimestampTable("fullLastModified", 10, thePast);
        List<String> args = this.getArgListForTable("fullLastModified", true, false);
        Configuration conf = TestIncrementalImport.newConf();
        SqoopOptions options = new SqoopOptions();
        options.setConf(conf);
        this.runImport(options, args);
        this.assertDirOfNumbers("fullLastModified", 10);
    }

    public void testNoImportFromTheFuture() throws Exception {
        String TABLE_NAME = "futureLastModified";
        Timestamp theFuture = new Timestamp(System.currentTimeMillis() + 1000000L);
        this.createTimestampTable("futureLastModified", 10, theFuture);
        List<String> args = this.getArgListForTable("futureLastModified", true, false);
        Configuration conf = TestIncrementalImport.newConf();
        SqoopOptions options = new SqoopOptions();
        options.setConf(conf);
        this.runImport(options, args);
        this.assertDirOfNumbers("futureLastModified", 0);
    }

    public void testEmptyJobLastMod() throws Exception {
        String TABLE_NAME = "emptyJobLastMod";
        this.createTimestampTable("emptyJobLastMod", 0, null);
        List<String> args = this.getArgListForTable("emptyJobLastMod", false, false);
        args.add("--append");
        this.createJob("emptyJobLastMod", args);
        this.runJob("emptyJobLastMod");
        this.assertDirOfNumbers("emptyJobLastMod", 0);
        this.runJob("emptyJobLastMod");
        this.assertDirOfNumbers("emptyJobLastMod", 0);
    }

    public void testEmptyThenFullJobLastMod() throws Exception {
        String TABLE_NAME = "emptyThenFullTimestamp";
        this.createTimestampTable("emptyThenFullTimestamp", 0, null);
        List<String> args = this.getArgListForTable("emptyThenFullTimestamp", false, false);
        args.add("--append");
        this.createJob("emptyThenFullTimestamp", args);
        this.runJob("emptyThenFullTimestamp");
        this.assertDirOfNumbers("emptyThenFullTimestamp", 0);
        long importWasBefore = System.currentTimeMillis();
        Thread.sleep(50L);
        long rowsAddedTime = System.currentTimeMillis() - 5L;
        TestIncrementalImport.assertTrue((rowsAddedTime > importWasBefore ? 1 : 0) != 0);
        TestIncrementalImport.assertTrue((rowsAddedTime < System.currentTimeMillis() ? 1 : 0) != 0);
        this.insertIdTimestampRows("emptyThenFullTimestamp", 0, 10, new Timestamp(rowsAddedTime));
        this.runJob("emptyThenFullTimestamp");
        this.assertDirOfNumbers("emptyThenFullTimestamp", 10);
        importWasBefore = System.currentTimeMillis();
        Thread.sleep(50L);
        rowsAddedTime = System.currentTimeMillis() - 5L;
        TestIncrementalImport.assertTrue((rowsAddedTime > importWasBefore ? 1 : 0) != 0);
        TestIncrementalImport.assertTrue((rowsAddedTime < System.currentTimeMillis() ? 1 : 0) != 0);
        this.insertIdTimestampRows("emptyThenFullTimestamp", 10, 20, new Timestamp(rowsAddedTime));
        this.runJob("emptyThenFullTimestamp");
        this.assertDirOfNumbers("emptyThenFullTimestamp", 20);
    }

    public void testAppendWithTimestamp() throws Exception {
        String TABLE_NAME = "appendTimestamp";
        Timestamp thePast = new Timestamp(System.currentTimeMillis() - 100L);
        this.createTimestampTable("appendTimestamp", 10, thePast);
        List<String> args = this.getArgListForTable("appendTimestamp", false, false);
        args.add("--append");
        this.createJob("appendTimestamp", args);
        this.runJob("appendTimestamp");
        this.assertDirOfNumbers("appendTimestamp", 10);
        long importWasBefore = System.currentTimeMillis();
        Thread.sleep(50L);
        long rowsAddedTime = System.currentTimeMillis() - 5L;
        TestIncrementalImport.assertTrue((rowsAddedTime > importWasBefore ? 1 : 0) != 0);
        TestIncrementalImport.assertTrue((rowsAddedTime < System.currentTimeMillis() ? 1 : 0) != 0);
        this.insertIdTimestampRows("appendTimestamp", 10, 20, new Timestamp(rowsAddedTime));
        this.runJob("appendTimestamp");
        this.assertDirOfNumbers("appendTimestamp", 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModifyWithTimestamp() throws Exception {
        String TABLE_NAME = "modifyTimestamp";
        Timestamp thePast = new Timestamp(System.currentTimeMillis() - 100L);
        this.createTimestampTable("modifyTimestamp", 10, thePast);
        List<String> args = this.getArgListForTable("modifyTimestamp", false, false);
        this.createJob("modifyTimestamp", args);
        this.runJob("modifyTimestamp");
        this.assertDirOfNumbers("modifyTimestamp", 10);
        long importWasBefore = System.currentTimeMillis();
        Thread.sleep(50L);
        long rowsAddedTime = System.currentTimeMillis() - 5L;
        TestIncrementalImport.assertTrue((rowsAddedTime > importWasBefore ? 1 : 0) != 0);
        TestIncrementalImport.assertTrue((rowsAddedTime < System.currentTimeMillis() ? 1 : 0) != 0);
        SqoopOptions options = new SqoopOptions();
        options.setConnectString(SOURCE_DB_URL);
        HsqldbManager manager = new HsqldbManager(options);
        Connection c = manager.getConnection();
        PreparedStatement s = null;
        try {
            s = c.prepareStatement("UPDATE modifyTimestamp SET id=?, last_modified=? WHERE id=?");
            s.setInt(1, 4000);
            s.setTimestamp(2, new Timestamp(rowsAddedTime));
            s.setInt(3, 0);
            s.executeUpdate();
            c.commit();
        }
        finally {
            s.close();
        }
        this.clearDir("modifyTimestamp");
        this.runJob("modifyTimestamp");
        this.assertSpecificNumber("modifyTimestamp", 4000);
    }

    public void testTimestampBoundary() throws Exception {
        long now = System.currentTimeMillis();
        String TABLE_NAME = "boundaryTimestamp";
        Timestamp thePast = new Timestamp(now - 100L);
        this.createTimestampTable("boundaryTimestamp", 10, thePast);
        Timestamp firstJobTime = new Timestamp(now);
        InstrumentHsqldbManager.setCurrentDbTimestamp(firstJobTime);
        Configuration conf = TestIncrementalImport.newConf();
        conf.set("sqoop.connection.factories", InstrumentHsqldbManagerFactory.class.getName());
        List<String> args = this.getArgListForTable("boundaryTimestamp", false, false);
        args.add("--append");
        this.createJob("boundaryTimestamp", args, conf);
        this.runJob("boundaryTimestamp");
        this.assertDirOfNumbers("boundaryTimestamp", 10);
        this.insertIdTimestampRows("boundaryTimestamp", 10, 20, firstJobTime);
        this.assertRowCount("boundaryTimestamp", 20);
        Timestamp secondJobTime = new Timestamp(now + 100L);
        InstrumentHsqldbManager.setCurrentDbTimestamp(secondJobTime);
        this.runJob("boundaryTimestamp");
        this.assertDirOfNumbers("boundaryTimestamp", 20);
    }

    public void testIncrementalAppendTimestamp() throws Exception {
        long now = System.currentTimeMillis();
        String TABLE_NAME = "incrementalAppendTimestamp";
        Timestamp thePast = new Timestamp(now - 100L);
        this.createTimestampTable("incrementalAppendTimestamp", 10, thePast);
        Timestamp firstJobTime = new Timestamp(now);
        InstrumentHsqldbManager.setCurrentDbTimestamp(firstJobTime);
        Configuration conf = TestIncrementalImport.newConf();
        conf.set("sqoop.connection.factories", InstrumentHsqldbManagerFactory.class.getName());
        List<String> args = this.getArgListForTable("incrementalAppendTimestamp", false, true, true);
        this.createJob("incrementalAppendTimestamp", args, conf);
        this.runJob("incrementalAppendTimestamp");
        this.assertDirOfNumbers("incrementalAppendTimestamp", 10);
        this.insertIdTimestampRows("incrementalAppendTimestamp", 10, 20, firstJobTime);
        this.assertRowCount("incrementalAppendTimestamp", 20);
        Timestamp secondJobTime = new Timestamp(now + 100L);
        InstrumentHsqldbManager.setCurrentDbTimestamp(secondJobTime);
        this.runJob("incrementalAppendTimestamp");
        this.assertDirOfNumbers("incrementalAppendTimestamp", 20);
    }

    public static class InstrumentHsqldbManager
    extends HsqldbManager {
        private static Timestamp curTimestamp;

        public InstrumentHsqldbManager(SqoopOptions options) {
            super(options);
        }

        public Timestamp getCurrentDbTimestamp() {
            return curTimestamp;
        }

        public static void setCurrentDbTimestamp(Timestamp t) {
            curTimestamp = t;
        }
    }

    public static class InstrumentHsqldbManagerFactory
    extends ManagerFactory {
        public ConnManager accept(JobData data) {
            LOG.info((Object)"Using instrumented manager");
            return new InstrumentHsqldbManager(data.getSqoopOptions());
        }
    }
}

