/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.orm.CompilationManager;
import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.testutil.SeqFileReader;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.util.ClassLoaderStack;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.util.ReflectionUtils;

public class TestCompression
extends ImportJobTestCase {
    protected String[] getArgv(boolean includeHadoopFlags, String[] colNames, CompressionCodec codec, String fileFormat) {
        String columnsString = "";
        for (String col : colNames) {
            columnsString = columnsString + col + ",";
        }
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--table");
        args.add(HsqldbTestServer.getTableName());
        args.add("--columns");
        args.add(columnsString);
        args.add("--compress");
        if (codec != null) {
            args.add("--compression-codec");
            args.add(codec.getClass().getName());
        }
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(HsqldbTestServer.getUrl());
        args.add(fileFormat);
        args.add("--num-mappers");
        args.add("1");
        return args.toArray(new String[0]);
    }

    @Override
    protected String getTableName() {
        return HsqldbTestServer.getTableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSequenceFileCompressionTest(CompressionCodec codec, int expectedNum) throws Exception {
        String[] columns = HsqldbTestServer.getFieldNames();
        ClassLoader prevClassLoader = null;
        SequenceFile.Reader reader = null;
        String[] argv = this.getArgv(true, columns, codec, "--as-sequencefile");
        this.runImport(argv);
        try {
            SqoopOptions opts = new ImportTool().parseArguments(this.getArgv(false, columns, codec, "--as-sequencefile"), null, null, true);
            CompilationManager compileMgr = new CompilationManager(opts);
            String jarFileName = compileMgr.getJarFilename();
            LOG.debug((Object)("Got jar from import job: " + jarFileName));
            prevClassLoader = ClassLoaderStack.addJarFile((String)jarFileName, (String)this.getTableName());
            reader = SeqFileReader.getSeqFileReader(this.getDataFilePath().toString());
            if (codec == null) {
                codec = new GzipCodec();
            }
            TestCompression.assertTrue((String)"Block compressed", (boolean)reader.isBlockCompressed());
            TestCompression.assertEquals(codec.getClass(), reader.getCompressionCodec().getClass());
            Configuration conf = new Configuration();
            Object key = ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Object val = ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            int numLines = 0;
            while (reader.next(key) != null) {
                reader.getCurrentValue(val);
                ++numLines;
            }
            TestCompression.assertEquals((int)expectedNum, (int)numLines);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(reader);
            if (null != prevClassLoader) {
                ClassLoaderStack.setCurrentClassLoader(prevClassLoader);
            }
            throw throwable;
        }
        IOUtils.closeStream((Closeable)reader);
        if (null != prevClassLoader) {
            ClassLoaderStack.setCurrentClassLoader((ClassLoader)prevClassLoader);
        }
    }

    public void runTextCompressionTest(CompressionCodec codec, int expectedNum) throws IOException {
        String ln;
        String[] columns = HsqldbTestServer.getFieldNames();
        String[] argv = this.getArgv(true, columns, codec, "--as-textfile");
        this.runImport(argv);
        Configuration conf = new Configuration();
        if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
            conf.set("fs.defaultfs.name", "file:///");
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (codec == null) {
            codec = new GzipCodec();
            ReflectionUtils.setConf((Object)codec, (Configuration)this.getConf());
        }
        Path p = new Path(this.getDataFilePath().toString() + codec.getDefaultExtension());
        CompressionInputStream is = codec.createInputStream((InputStream)fs.open(p));
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is));
        int numLines = 0;
        while ((ln = r.readLine()) != null) {
            ++numLines;
        }
        r.close();
        TestCompression.assertEquals((int)expectedNum, (int)numLines);
    }

    public void testDefaultTextCompression() throws IOException {
        this.runTextCompressionTest(null, 4);
    }

    public void testBzip2TextCompression() throws IOException {
        this.runTextCompressionTest((CompressionCodec)new BZip2Codec(), 4);
    }

    public void testBzip2SequenceFileCompression() throws Exception {
        this.runSequenceFileCompressionTest((CompressionCodec)new BZip2Codec(), 4);
    }
}

