/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell.utils;

import groovy.lang.MissingPropertyException;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.core.ShellError;

public class ThrowableDisplayer {
    public static void errorHook(Throwable t) {
        ShellEnvironment.println("@|red Exception has occurred during processing command |@");
        if (t instanceof SqoopException && ((SqoopException)t).getErrorCode() == ShellError.SHELL_0006) {
            ShellEnvironment.print("@|red Server has returned exception: |@");
            ThrowableDisplayer.printThrowable(t.getCause(), ShellEnvironment.isVerbose());
        } else if (t.getClass() == MissingPropertyException.class) {
            ShellEnvironment.print("@|red Unknown command: |@");
            ShellEnvironment.println(t.getMessage());
        } else {
            ThrowableDisplayer.printThrowable(t, ShellEnvironment.isVerbose());
        }
    }

    protected static void printThrowable(Throwable t, boolean verbose) {
        ShellEnvironment.print("@|red Exception: |@");
        ShellEnvironment.print(t.getClass().getName());
        ShellEnvironment.print(" @|red Message: |@");
        ShellEnvironment.print(t.getMessage());
        ShellEnvironment.println();
        if (verbose) {
            ShellEnvironment.println("Stack trace:");
            for (StackTraceElement e : t.getStackTrace()) {
                ShellEnvironment.print("\t @|bold at |@ ");
                ShellEnvironment.print(e.getClassName());
                ShellEnvironment.print(" (@|bold " + e.getFileName() + ":" + e.getLineNumber() + ") |@ ");
                ShellEnvironment.println();
            }
            Throwable cause = t.getCause();
            if (cause != null) {
                ShellEnvironment.print("Caused by: ");
                ThrowableDisplayer.printThrowable(cause, verbose);
            }
        }
    }

    private ThrowableDisplayer() {
    }
}

