/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell.utils;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.sqoop.shell.ShellEnvironment;

public class TableDisplayer {
    public static void display(List<String> headers, List<String> ... columns) {
        int i;
        assert (headers != null);
        assert (columns != null);
        assert (headers.size() == columns.length);
        int columnCount = headers.size();
        LinkedList<Integer> widths = new LinkedList<Integer>();
        for (i = 0; i < columnCount; ++i) {
            widths.add(TableDisplayer.getMaximalWidth(headers.get(i), columns[i]));
        }
        TableDisplayer.drawLine(widths);
        ShellEnvironment.print("| ");
        for (i = 0; i < columnCount; ++i) {
            ShellEnvironment.print(StringUtils.center((String)headers.get(i), (int)((Integer)widths.get(i)), (char)' '));
            ShellEnvironment.print(i == columnCount - 1 ? " |" : " | ");
        }
        ShellEnvironment.println();
        TableDisplayer.drawLine(widths);
        int rows = TableDisplayer.getMaximalRows(columns);
        for (int row = 0; row < rows; ++row) {
            ShellEnvironment.print("| ");
            for (int i2 = 0; i2 < columnCount; ++i2) {
                ShellEnvironment.print(StringUtils.rightPad((String)columns[i2].get(row), (int)((Integer)widths.get(i2)), (char)' '));
                ShellEnvironment.print(i2 == columnCount - 1 ? " |" : " | ");
            }
            ShellEnvironment.println();
        }
        TableDisplayer.drawLine(widths);
    }

    private static void drawLine(List<Integer> widths) {
        int last = widths.size() - 1;
        ShellEnvironment.print("+-");
        for (int i = 0; i < widths.size(); ++i) {
            ShellEnvironment.print(StringUtils.repeat((String)"-", (int)widths.get(i)));
            ShellEnvironment.print(i == last ? "-+" : "-+-");
        }
        ShellEnvironment.println();
    }

    private static int getMaximalWidth(String header, List<String> column) {
        assert (header != null);
        assert (column != null);
        int max = header.length();
        for (String value : column) {
            if (value == null || value.length() <= max) continue;
            max = value.length();
        }
        return max;
    }

    private static int getMaximalRows(List<String> ... columns) {
        int max = 0;
        for (List<String> column : columns) {
            if (column.size() <= max) continue;
            max = column.size();
        }
        return max;
    }

    private TableDisplayer() {
    }
}

