/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell.utils;

import java.text.SimpleDateFormat;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.submission.SubmissionStatus;
import org.apache.sqoop.submission.counter.Counter;
import org.apache.sqoop.submission.counter.CounterGroup;
import org.apache.sqoop.submission.counter.Counters;

public final class SubmissionDisplayer {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");

    public static void displayHeader(MSubmission submission) {
        ShellEnvironment.println("@|bold " + ShellEnvironment.resourceString("submission.submission_detail") + "|@");
        ShellEnvironment.print(ShellEnvironment.resourceString("submission.job_id") + ": ");
        ShellEnvironment.println(submission.getJobId());
        ShellEnvironment.print(ShellEnvironment.resourceString("submission.server_url") + ": ");
        ShellEnvironment.println(ShellEnvironment.getServerUrl());
        ShellEnvironment.print(ShellEnvironment.resourceString("submission.creation_user") + ": ");
        ShellEnvironment.println(submission.getCreationUser());
        ShellEnvironment.print(ShellEnvironment.resourceString("submission.creation_date") + ": ");
        ShellEnvironment.println(dateFormat.format(submission.getCreationDate()));
        ShellEnvironment.print(ShellEnvironment.resourceString("submission.update_user") + ": ");
        ShellEnvironment.println(submission.getLastUpdateUser());
        String externalId = submission.getExternalId();
        if (externalId != null) {
            ShellEnvironment.print(ShellEnvironment.resourceString("submission.external_id") + ": ");
            ShellEnvironment.println(externalId);
            String externalLink = submission.getExternalLink();
            if (externalLink != null) {
                ShellEnvironment.println("\t" + externalLink);
            }
        }
        if (ShellEnvironment.isVerbose() && submission.getConnectorSchema() != null) {
            ShellEnvironment.print(ShellEnvironment.resourceString("submission.connector_schema") + ": ");
            ShellEnvironment.println(submission.getConnectorSchema());
        }
        if (ShellEnvironment.isVerbose() && submission.getHioSchema() != null) {
            ShellEnvironment.print(ShellEnvironment.resourceString("submission.hio_schema") + ": ");
            ShellEnvironment.println(submission.getHioSchema());
        }
    }

    public static void displayProgress(MSubmission submission) {
        StringBuilder sb = new StringBuilder();
        if (submission.getStatus().isRunning()) {
            sb.append(dateFormat.format(submission.getLastUpdateDate()) + ": @|green " + submission.getStatus() + " |@");
            double progress = submission.getProgress();
            sb.append(" - ");
            if (progress == -1.0) {
                sb.append(ShellEnvironment.resourceString("submission.progress_not_available"));
            } else {
                sb.append(String.format("%.2f %%", progress * 100.0));
            }
        } else {
            sb.append(dateFormat.format(submission.getLastUpdateDate()) + ": " + submission.getStatus());
        }
        ShellEnvironment.println(sb.toString());
    }

    public static void displayFooter(MSubmission submission) {
        if (submission.getStatus().toString().equals(SubmissionStatus.SUCCEEDED.toString())) {
            ShellEnvironment.println(dateFormat.format(submission.getLastUpdateDate()) + ": @|green " + submission.getStatus() + " |@");
            Counters counters = submission.getCounters();
            if (counters != null) {
                ShellEnvironment.println(ShellEnvironment.resourceString("submission.counters") + ":");
                for (CounterGroup group : counters) {
                    ShellEnvironment.print("\t");
                    ShellEnvironment.println(group.getName());
                    for (Counter counter : group) {
                        ShellEnvironment.print("\t\t");
                        ShellEnvironment.print(counter.getName());
                        ShellEnvironment.print(": ");
                        ShellEnvironment.println(counter.getValue());
                    }
                }
                ShellEnvironment.println(ShellEnvironment.resourceString("submission.executed_success"));
            }
        } else {
            if (submission.getStatus().isFailure()) {
                ShellEnvironment.println(dateFormat.format(submission.getLastUpdateDate()) + ": @|red " + submission.getStatus() + " |@");
            } else {
                ShellEnvironment.println(dateFormat.format(submission.getLastUpdateDate()) + ": " + submission.getStatus());
            }
            if (submission.getExceptionInfo() != null) {
                ShellEnvironment.print("@|red Exception: |@");
                ShellEnvironment.println(submission.getExceptionInfo());
                if (ShellEnvironment.isVerbose() && submission.getExceptionStackTrace() != null) {
                    ShellEnvironment.print("@|bold Stack trace: |@");
                    ShellEnvironment.println(submission.getExceptionStackTrace());
                }
            }
        }
    }

    public static void displaySubmission(MSubmission submission) {
        if (submission.getStatus().isFailure() || submission.getStatus().equals((Object)SubmissionStatus.SUCCEEDED)) {
            SubmissionDisplayer.displayHeader(submission);
            SubmissionDisplayer.displayFooter(submission);
        } else {
            SubmissionDisplayer.displayHeader(submission);
            SubmissionDisplayer.displayProgress(submission);
        }
    }
}

