/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import jline.ConsoleReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.StringUtils;
import org.apache.sqoop.model.MBooleanInput;
import org.apache.sqoop.model.MConnection;
import org.apache.sqoop.model.MEnumInput;
import org.apache.sqoop.model.MForm;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MNamedElement;
import org.apache.sqoop.model.MStringInput;
import org.apache.sqoop.model.MValidatedElement;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.utils.FormOptions;

public final class FormFiller {
    private static MStringInput nameInput = new MStringInput("object-name", false, 25);

    public static boolean fillJob(CommandLine line, MJob job) throws IOException {
        job.setName(line.getOptionValue("name"));
        return FormFiller.fillForms(line, (List<MForm>)job.getConnectorPart().getForms(), job.getFrameworkPart().getForms());
    }

    public static boolean fillJob(ConsoleReader reader, MJob job, ResourceBundle connectorBundle, ResourceBundle frameworkBundle) throws IOException {
        job.setName(FormFiller.getName(reader, job.getName()));
        return FormFiller.fillForms(reader, job.getConnectorPart().getForms(), connectorBundle, job.getFrameworkPart().getForms(), frameworkBundle);
    }

    public static boolean fillConnection(CommandLine line, MConnection connection) throws IOException {
        connection.setName(line.getOptionValue("name"));
        return FormFiller.fillForms(line, (List<MForm>)connection.getConnectorPart().getForms(), connection.getFrameworkPart().getForms());
    }

    public static boolean fillConnection(ConsoleReader reader, MConnection connection, ResourceBundle connectorBundle, ResourceBundle frameworkBundle) throws IOException {
        connection.setName(FormFiller.getName(reader, connection.getName()));
        return FormFiller.fillForms(reader, connection.getConnectorPart().getForms(), connectorBundle, connection.getFrameworkPart().getForms(), frameworkBundle);
    }

    public static boolean fillForms(CommandLine line, List<MForm> connectorForms, List<MForm> frameworkForms) throws IOException {
        return FormFiller.fillForms("connector", connectorForms, line) && FormFiller.fillForms("framework", frameworkForms, line);
    }

    public static boolean fillForms(String prefix, List<MForm> forms, CommandLine line) throws IOException {
        for (MForm form : forms) {
            if (FormFiller.fillForm(prefix, form, line)) continue;
            return false;
        }
        return true;
    }

    public static boolean fillForm(String prefix, MForm form, CommandLine line) throws IOException {
        for (MInput input : form.getInputs()) {
            if (FormFiller.fillInput(prefix, input, line)) continue;
            return false;
        }
        return true;
    }

    public static boolean fillInput(String prefix, MInput input, CommandLine line) throws IOException {
        switch (input.getType()) {
            case STRING: {
                return FormFiller.fillInputString(prefix, (MStringInput)input, line);
            }
            case INTEGER: {
                return FormFiller.fillInputInteger(prefix, (MIntegerInput)input, line);
            }
            case BOOLEAN: {
                return FormFiller.fillInputBoolean(prefix, (MBooleanInput)input, line);
            }
            case MAP: {
                return FormFiller.fillInputMap(prefix, (MMapInput)input, line);
            }
            case ENUM: {
                return FormFiller.fillInputEnum(prefix, (MEnumInput)input, line);
            }
        }
        ShellEnvironment.println("Unsupported data type " + input.getType());
        return true;
    }

    private static boolean fillInputEnum(String prefix, MEnumInput input, CommandLine line) throws IOException {
        String opt = FormOptions.getOptionKey(prefix, (MInput)input);
        if (line.hasOption(opt)) {
            String value = line.getOptionValue(opt);
            int index = Arrays.asList(input.getValues()).indexOf(value);
            if (index < 0) {
                FormFiller.errorMessage((MNamedElement)input, String.format("Invalid option %s. Please use one of %s.", value, StringUtils.join((Object[])input.getValues(), (String)", ")));
                return false;
            }
            input.setValue(value);
        } else {
            input.setEmpty();
        }
        return true;
    }

    private static boolean fillInputMap(String prefix, MMapInput input, CommandLine line) throws IOException {
        String opt = FormOptions.getOptionKey(prefix, (MInput)input);
        if (line.hasOption(opt)) {
            String[] entries;
            String value = line.getOptionValue(opt);
            HashMap<String, String> values = new HashMap<String, String>();
            for (String entry : entries = value.split("&")) {
                if (!entry.contains("=")) {
                    FormFiller.errorMessage((MNamedElement)input, "Don't know what to do with " + entry);
                    return false;
                }
                String[] keyValue = entry.split("=");
                values.put(keyValue[0], keyValue[1]);
            }
            input.setValue(values);
        } else {
            input.setEmpty();
        }
        return true;
    }

    private static boolean fillInputInteger(String prefix, MIntegerInput input, CommandLine line) throws IOException {
        String opt = FormOptions.getOptionKey(prefix, (MInput)input);
        if (line.hasOption(opt)) {
            try {
                input.setValue((Object)Integer.valueOf(line.getOptionValue(FormOptions.getOptionKey(prefix, (MInput)input))));
            }
            catch (NumberFormatException ex) {
                FormFiller.errorMessage((MNamedElement)input, "Input is not valid integer number");
                return false;
            }
        } else {
            input.setEmpty();
        }
        return true;
    }

    public static boolean fillInputString(String prefix, MStringInput input, CommandLine line) throws IOException {
        String opt = FormOptions.getOptionKey(prefix, (MInput)input);
        if (line.hasOption(opt)) {
            String value = line.getOptionValue(FormOptions.getOptionKey(prefix, (MInput)input));
            if (value.length() > input.getMaxLength()) {
                FormFiller.errorMessage((MNamedElement)input, "Size of input exceeds allowance for this input field. Maximal allowed size is " + input.getMaxLength());
            }
            input.setValue((Object)value);
        } else {
            input.setEmpty();
        }
        return true;
    }

    public static boolean fillInputBoolean(String prefix, MBooleanInput input, CommandLine line) throws IOException {
        String opt = FormOptions.getOptionKey(prefix, (MInput)input);
        if (line.hasOption(opt)) {
            input.setValue((Object)Boolean.valueOf(line.getOptionValue(FormOptions.getOptionKey(prefix, (MInput)input))));
        } else {
            input.setEmpty();
        }
        return true;
    }

    public static boolean fillForms(ConsoleReader reader, List<MForm> connectorForms, ResourceBundle connectorBundle, List<MForm> frameworkForms, ResourceBundle frameworkBundle) throws IOException {
        if (!FormFiller.fillForms(connectorForms, reader, connectorBundle)) {
            return false;
        }
        return FormFiller.fillForms(frameworkForms, reader, frameworkBundle);
    }

    public static boolean fillForms(List<MForm> forms, ConsoleReader reader, ResourceBundle bundle) throws IOException {
        for (MForm form : forms) {
            if (FormFiller.fillForm(form, reader, bundle)) continue;
            return false;
        }
        return true;
    }

    public static boolean fillForm(MForm form, ConsoleReader reader, ResourceBundle bundle) throws IOException {
        ShellEnvironment.println("");
        ShellEnvironment.println(bundle.getString(form.getLabelKey()));
        FormFiller.printValidationMessage((MValidatedElement)form, false);
        ShellEnvironment.println("");
        for (MInput input : form.getInputs()) {
            if (FormFiller.fillInput(input, reader, bundle)) continue;
            return false;
        }
        return true;
    }

    public static boolean fillInput(MInput input, ConsoleReader reader, ResourceBundle bundle) throws IOException {
        FormFiller.printValidationMessage((MValidatedElement)input, false);
        switch (input.getType()) {
            case STRING: {
                return FormFiller.fillInputString((MStringInput)input, reader, bundle);
            }
            case INTEGER: {
                return FormFiller.fillInputInteger((MIntegerInput)input, reader, bundle);
            }
            case BOOLEAN: {
                return FormFiller.fillInputBoolean((MBooleanInput)input, reader, bundle);
            }
            case MAP: {
                return FormFiller.fillInputMap((MMapInput)input, reader, bundle);
            }
            case ENUM: {
                return FormFiller.fillInputEnum((MEnumInput)input, reader, bundle);
            }
        }
        ShellEnvironment.println("Unsupported data type " + input.getType());
        return true;
    }

    private static boolean fillInputEnum(MEnumInput input, ConsoleReader reader, ResourceBundle bundle) throws IOException {
        ShellEnvironment.println(bundle.getString(input.getLabelKey()) + ": ");
        int i = -1;
        int lastChoice = -1;
        for (String value : input.getValues()) {
            ShellEnvironment.println("  " + ++i + " : " + value);
            if (input.isEmpty() || !value.equals(input.getValue()) || input.isSensitive()) continue;
            lastChoice = i;
        }
        reader.printString("Choose: ");
        if (lastChoice != -1) {
            reader.putString(Integer.toString(lastChoice));
        }
        reader.flushConsole();
        String userTyped = input.isSensitive() ? reader.readLine(Character.valueOf('*')) : reader.readLine();
        if (userTyped == null) {
            return false;
        }
        if (userTyped.isEmpty()) {
            input.setEmpty();
        } else {
            try {
                Integer index = Integer.valueOf(userTyped);
                if (index < 0 || index >= input.getValues().length) {
                    FormFiller.errorMessage("Invalid index");
                    return FormFiller.fillInputEnum(input, reader, bundle);
                }
                input.setValue(input.getValues()[index]);
            }
            catch (NumberFormatException ex) {
                FormFiller.errorMessage("Input is not valid integer number");
                return FormFiller.fillInputEnum(input, reader, bundle);
            }
        }
        return true;
    }

    private static boolean fillInputMap(MMapInput input, ConsoleReader reader, ResourceBundle bundle) throws IOException {
        ShellEnvironment.println(bundle.getString(input.getLabelKey()) + ": ");
        HashMap<String, String> values = (HashMap<String, String>)input.getValue();
        if (values == null) {
            values = new HashMap<String, String>();
        }
        while (true) {
            ShellEnvironment.println("There are currently " + values.size() + " values in the map:");
            if (!input.isSensitive()) {
                for (Map.Entry entry : values.entrySet()) {
                    ShellEnvironment.println((String)entry.getKey() + " = " + (String)entry.getValue());
                }
            }
            reader.printString("entry# ");
            reader.flushConsole();
            String userTyped = input.isSensitive() ? reader.readLine(Character.valueOf('*')) : reader.readLine();
            if (userTyped == null) {
                return false;
            }
            if (userTyped.isEmpty()) {
                if (values.size() == 0) {
                    input.setEmpty();
                } else {
                    input.setValue(values);
                }
                return true;
            }
            if (userTyped.contains("=")) {
                String[] keyValue = userTyped.split("=", 2);
                values.put(FormFiller.handleUserInput(keyValue[0]), FormFiller.handleUserInput(keyValue[1]));
                continue;
            }
            String key = FormFiller.handleUserInput(userTyped);
            if (values.containsKey(key)) {
                values.remove(key);
                continue;
            }
            FormFiller.errorMessage("Don't know what to do with " + userTyped);
        }
    }

    private static String handleUserInput(String input) {
        if (input == null) {
            return null;
        }
        if (input.isEmpty()) {
            return input;
        }
        input = input.trim();
        int lastIndex = input.length() - 1;
        char first = input.charAt(0);
        char last = input.charAt(lastIndex);
        if (first == '\'' && last == '\'') {
            input = input.substring(1, lastIndex);
        } else if (first == '\"' && last == '\"') {
            input = input.substring(1, lastIndex);
        }
        return input;
    }

    private static boolean fillInputInteger(MIntegerInput input, ConsoleReader reader, ResourceBundle bundle) throws IOException {
        String userTyped;
        FormFiller.generatePrompt(reader, bundle, (MInput)input);
        if (!input.isEmpty() && !input.isSensitive()) {
            reader.putString(((Integer)input.getValue()).toString());
        }
        if ((userTyped = input.isSensitive() ? reader.readLine(Character.valueOf('*')) : reader.readLine()) == null) {
            return false;
        }
        if (userTyped.isEmpty()) {
            input.setEmpty();
        } else {
            try {
                Integer value = Integer.valueOf(userTyped);
                input.setValue((Object)value);
            }
            catch (NumberFormatException ex) {
                FormFiller.errorMessage("Input is not valid integer number");
                return FormFiller.fillInputInteger(input, reader, bundle);
            }
            input.setValue((Object)Integer.valueOf(userTyped));
        }
        return true;
    }

    public static boolean fillInputString(MStringInput input, ConsoleReader reader, ResourceBundle bundle) throws IOException {
        String userTyped;
        FormFiller.generatePrompt(reader, bundle, (MInput)input);
        if (!input.isEmpty() && !input.isSensitive()) {
            reader.putString((String)input.getValue());
        }
        if ((userTyped = input.isSensitive() ? reader.readLine(Character.valueOf('*')) : reader.readLine()) == null) {
            return false;
        }
        if (userTyped.isEmpty()) {
            input.setEmpty();
        } else {
            input.setValue((Object)userTyped);
            if (userTyped.length() > input.getMaxLength()) {
                FormFiller.errorMessage("Size of input exceeds allowance for this input field. Maximal allowed size is " + input.getMaxLength());
                return FormFiller.fillInputString(input, reader, bundle);
            }
        }
        return true;
    }

    public static boolean fillInputBoolean(MBooleanInput input, ConsoleReader reader, ResourceBundle bundle) throws IOException {
        String userTyped;
        FormFiller.generatePrompt(reader, bundle, (MInput)input);
        if (!input.isEmpty() && !input.isSensitive()) {
            reader.putString(((Boolean)input.getValue()).toString());
        }
        if ((userTyped = input.isSensitive() ? reader.readLine(Character.valueOf('*')) : reader.readLine()) == null) {
            return false;
        }
        if (userTyped.isEmpty()) {
            input.setEmpty();
        } else {
            input.setValue((Object)Boolean.valueOf(userTyped));
        }
        return true;
    }

    public static void generatePrompt(ConsoleReader reader, ResourceBundle bundle, MInput input) throws IOException {
        reader.printString(bundle.getString(input.getLabelKey()) + ": ");
        reader.flushConsole();
    }

    public static String getName(ConsoleReader reader, String name) throws IOException {
        if (name == null) {
            nameInput.setEmpty();
        } else {
            nameInput.setValue((Object)name);
        }
        FormFiller.fillInputString(nameInput, reader, ShellEnvironment.getResourceBundle());
        return (String)nameInput.getValue();
    }

    public static void printValidationMessage(MValidatedElement element, boolean includeInputPrefix) {
        switch (element.getValidationStatus()) {
            case UNACCEPTABLE: {
                if (includeInputPrefix) {
                    FormFiller.errorMessage((MNamedElement)element, element.getValidationMessage());
                    break;
                }
                FormFiller.errorMessage(element.getValidationMessage());
                break;
            }
            case ACCEPTABLE: {
                if (includeInputPrefix) {
                    FormFiller.warningMessage((MNamedElement)element, element.getValidationMessage());
                    break;
                }
                FormFiller.warningMessage(element.getValidationMessage());
                break;
            }
        }
    }

    public static void errorMessage(String message) {
        ShellEnvironment.println("Error message: @|red " + message + " |@");
    }

    public static void errorMessage(MNamedElement input, String message) {
        ShellEnvironment.print(input.getName());
        ShellEnvironment.print(": ");
        FormFiller.errorMessage(message);
    }

    public static void warningMessage(String message) {
        ShellEnvironment.println("Warning message: @|yellow " + message + " |@");
    }

    public static void warningMessage(MNamedElement input, String message) {
        ShellEnvironment.print(input.getName());
        ShellEnvironment.print(": ");
        FormFiller.warningMessage(message);
    }

    public static void errorIntroduction() {
        ShellEnvironment.println();
        ShellEnvironment.println("@|red There are issues with entered data, please revise your input:|@");
    }

    public static void printConnectionValidationMessages(MConnection connection) {
        for (MForm form : connection.getConnectorPart().getForms()) {
            for (MInput input : form.getInputs()) {
                FormFiller.printValidationMessage((MValidatedElement)input, true);
            }
        }
        for (MForm form : connection.getFrameworkPart().getForms()) {
            for (MInput input : form.getInputs()) {
                FormFiller.printValidationMessage((MValidatedElement)input, true);
            }
        }
    }

    public static void printJobValidationMessages(MJob job) {
        for (MForm form : job.getConnectorPart().getForms()) {
            for (MInput input : form.getInputs()) {
                FormFiller.printValidationMessage((MValidatedElement)input, true);
            }
        }
        for (MForm form : job.getFrameworkPart().getForms()) {
            for (MInput input : form.getInputs()) {
                FormFiller.printValidationMessage((MValidatedElement)input, true);
            }
        }
    }

    private FormFiller() {
    }
}

