/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.sqoop.model.MAccountableEntity;
import org.apache.sqoop.model.MBooleanInput;
import org.apache.sqoop.model.MConnection;
import org.apache.sqoop.model.MEnumInput;
import org.apache.sqoop.model.MForm;
import org.apache.sqoop.model.MFramework;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MJobForms;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.utils.FormFiller;
import org.apache.sqoop.validation.Status;

public final class FormDisplayer {
    public static void displayFormMetadataDetails(MFramework framework, ResourceBundle bundle) {
        ShellEnvironment.print("  %s: ", ShellEnvironment.resourceString("formdisplayer.supported_job_types"));
        ShellEnvironment.println(framework.getAllJobsForms().keySet().toString());
        FormDisplayer.displayFormsMetadata(framework.getConnectionForms().getForms(), ShellEnvironment.resourceString("formdisplayer.connection"), bundle);
        for (MJobForms jobForms : framework.getAllJobsForms().values()) {
            ShellEnvironment.print("  %s ", ShellEnvironment.resourceString("formdisplayer.forms_jobtype"));
            ShellEnvironment.print(jobForms.getType().name());
            ShellEnvironment.println(":");
            FormDisplayer.displayFormsMetadata(jobForms.getForms(), ShellEnvironment.resourceString("formdisplayer.job"), bundle);
        }
    }

    public static void displayFormsMetadata(List<MForm> forms, String type, ResourceBundle bundle) {
        Iterator<MForm> fiter = forms.iterator();
        int findx = 1;
        while (fiter.hasNext()) {
            ShellEnvironment.print("    ");
            ShellEnvironment.print(type);
            ShellEnvironment.print(" %s ", ShellEnvironment.resourceString("formdisplayer.form"));
            ShellEnvironment.print(findx++);
            ShellEnvironment.println(":");
            MForm form = fiter.next();
            ShellEnvironment.print("      %s: ", ShellEnvironment.resourceString("formdisplayer.name"));
            ShellEnvironment.println(form.getName());
            ShellEnvironment.print("      %s: ", ShellEnvironment.resourceString("formdisplayer.label"));
            ShellEnvironment.println(bundle.getString(form.getLabelKey()));
            ShellEnvironment.print("      %s: ", ShellEnvironment.resourceString("formdisplayer.help"));
            ShellEnvironment.println(bundle.getString(form.getHelpKey()));
            List inputs = form.getInputs();
            Iterator iiter = inputs.iterator();
            int iindx = 1;
            while (iiter.hasNext()) {
                ShellEnvironment.print("      %s ", ShellEnvironment.resourceString("formdisplayer.input"));
                ShellEnvironment.print(iindx++);
                ShellEnvironment.println(":");
                MInput input = (MInput)iiter.next();
                ShellEnvironment.print("        %s: ", ShellEnvironment.resourceString("formdisplayer.name"));
                ShellEnvironment.println(input.getName());
                ShellEnvironment.print("        %s: ", ShellEnvironment.resourceString("formdisplayer.label"));
                ShellEnvironment.println(bundle.getString(input.getLabelKey()));
                ShellEnvironment.print("        %s: ", ShellEnvironment.resourceString("formdisplayer.help"));
                ShellEnvironment.println(bundle.getString(input.getHelpKey()));
                ShellEnvironment.print("        %s: ", ShellEnvironment.resourceString("formdisplayer.type"));
                ShellEnvironment.println(input.getType());
                ShellEnvironment.print("        %s: ", ShellEnvironment.resourceString("formdisplayer.sensitive"));
                ShellEnvironment.println(input.isSensitive());
                if (input.getType() == MInputType.STRING) {
                    ShellEnvironment.print("        %s: ", ShellEnvironment.resourceString("formdisplayer.size"));
                    ShellEnvironment.println(((MStringInput)input).getMaxLength());
                    continue;
                }
                if (input.getType() != MInputType.ENUM) continue;
                ShellEnvironment.print("        %s: ", ShellEnvironment.resourceString("formdisplayer.possible_values"));
                ShellEnvironment.println(StringUtils.join((Object[])((MEnumInput)input).getValues(), (String)","));
            }
        }
    }

    public static void displayForms(List<MForm> forms, ResourceBundle bundle) {
        for (MForm form : forms) {
            FormDisplayer.displayForm(form, bundle);
        }
    }

    public static void displayFormWarning(MAccountableEntity entity) {
        ArrayList formList = new ArrayList();
        boolean showMessage = true;
        if (entity instanceof MConnection) {
            MConnection connection = (MConnection)entity;
            formList.addAll(connection.getConnectorPart().getForms());
            formList.addAll(connection.getFrameworkPart().getForms());
        } else if (entity instanceof MJob) {
            MJob job = (MJob)entity;
            formList.addAll(job.getConnectorPart().getForms());
            formList.addAll(job.getFrameworkPart().getForms());
        }
        for (MForm form : formList) {
            if (form.getValidationStatus() != Status.ACCEPTABLE) continue;
            if (showMessage) {
                ShellEnvironment.print("\n@|yellow %s|@\n", ShellEnvironment.resourceString("formdisplayer.warning_message"));
                showMessage = false;
            }
            FormFiller.warningMessage(form.getValidationMessage());
        }
    }

    private static void displayForm(MForm form, ResourceBundle bundle) {
        ShellEnvironment.print("  ");
        ShellEnvironment.println(bundle.getString(form.getLabelKey()));
        for (MInput input : form.getInputs()) {
            ShellEnvironment.print("    ");
            ShellEnvironment.print(bundle.getString(input.getLabelKey()));
            ShellEnvironment.print(": ");
            if (!input.isEmpty()) {
                if (input.isSensitive()) {
                    ShellEnvironment.print("(%s)", ShellEnvironment.resourceString("formdisplayer.input_sensitive"));
                } else {
                    switch (input.getType()) {
                        case STRING: {
                            FormDisplayer.displayInputString((MStringInput)input);
                            break;
                        }
                        case INTEGER: {
                            FormDisplayer.displayInputInteger((MIntegerInput)input);
                            break;
                        }
                        case BOOLEAN: {
                            FormDisplayer.displayInputBoolean((MBooleanInput)input);
                            break;
                        }
                        case MAP: {
                            FormDisplayer.displayInputMap((MMapInput)input);
                            break;
                        }
                        case ENUM: {
                            FormDisplayer.displayInputEnum((MEnumInput)input);
                            break;
                        }
                        default: {
                            ShellEnvironment.print("\n%s " + input.getType(), ShellEnvironment.resourceString("formdisplayer.unsupported_datatype"));
                            return;
                        }
                    }
                }
            }
            ShellEnvironment.println("");
        }
    }

    private static void displayInputString(MStringInput input) {
        ShellEnvironment.print((String)input.getValue());
    }

    private static void displayInputInteger(MIntegerInput input) {
        ShellEnvironment.print(input.getValue());
    }

    private static void displayInputBoolean(MBooleanInput input) {
        ShellEnvironment.print(input.getValue());
    }

    private static void displayInputMap(MMapInput input) {
        for (Map.Entry entry : ((Map)input.getValue()).entrySet()) {
            ShellEnvironment.println();
            ShellEnvironment.print("      ");
            ShellEnvironment.print((String)entry.getKey());
            ShellEnvironment.print(" = ");
            ShellEnvironment.print((String)entry.getValue());
        }
    }

    private static void displayInputEnum(MEnumInput input) {
        ShellEnvironment.print((String)input.getValue());
    }

    private FormDisplayer() {
    }
}

