/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import jline.ConsoleReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.sqoop.model.MAccountableEntity;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.shell.utils.FormDisplayer;
import org.apache.sqoop.shell.utils.FormFiller;
import org.apache.sqoop.shell.utils.FormOptions;
import org.apache.sqoop.shell.utils.JobDynamicFormOptions;
import org.apache.sqoop.validation.Status;

public class UpdateJobFunction
extends SqoopFunction {
    public UpdateJobFunction() {
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("prompt.job_id"));
        OptionBuilder.withLongOpt((String)"jid");
        OptionBuilder.hasArg();
        this.addOption(OptionBuilder.create((char)'j'));
    }

    @Override
    public boolean validateArgs(CommandLine line) {
        if (!line.hasOption("jid")) {
            ShellEnvironment.printlnResource("args.jid_missing");
            return false;
        }
        return true;
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) throws IOException {
        return this.updateJob(this.getLong(line, "jid"), line.getArgList(), isInteractive);
    }

    private Status updateJob(Long jobId, List<String> args, boolean isInteractive) throws IOException {
        ShellEnvironment.printlnResource("update.job", jobId);
        ConsoleReader reader = new ConsoleReader();
        MJob job = ShellEnvironment.client.getJob(jobId.longValue());
        ResourceBundle connectorBundle = ShellEnvironment.client.getResourceBundle(job.getConnectorId());
        ResourceBundle frameworkBundle = ShellEnvironment.client.getFrameworkResourceBundle();
        Status status = Status.FINE;
        if (isInteractive) {
            ShellEnvironment.printlnResource("prompt.update_job_metadata");
            do {
                if (!status.canProceed()) {
                    FormFiller.errorIntroduction();
                }
                if (FormFiller.fillJob(reader, job, connectorBundle, frameworkBundle)) continue;
                return status;
            } while (!(status = ShellEnvironment.client.updateJob(job)).canProceed());
        } else {
            JobDynamicFormOptions options = new JobDynamicFormOptions();
            options.prepareOptions(job);
            CommandLine line = FormOptions.parseOptions(options, 0, args, false);
            if (FormFiller.fillJob(line, job)) {
                status = ShellEnvironment.client.updateJob(job);
                if (!status.canProceed()) {
                    FormFiller.printJobValidationMessages(job);
                    return status;
                }
            } else {
                FormFiller.printJobValidationMessages(job);
                return null;
            }
        }
        FormDisplayer.displayFormWarning((MAccountableEntity)job);
        ShellEnvironment.printlnResource("update.job_successful", status.name());
        return status;
    }
}

