/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import jline.ConsoleReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.sqoop.model.MAccountableEntity;
import org.apache.sqoop.model.MConnection;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.shell.utils.ConnectionDynamicFormOptions;
import org.apache.sqoop.shell.utils.FormDisplayer;
import org.apache.sqoop.shell.utils.FormFiller;
import org.apache.sqoop.shell.utils.FormOptions;
import org.apache.sqoop.validation.Status;

public class UpdateConnectionFunction
extends SqoopFunction {
    public UpdateConnectionFunction() {
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("prompt.conn_id"));
        OptionBuilder.withLongOpt((String)"xid");
        OptionBuilder.hasArg();
        this.addOption(OptionBuilder.create((char)'x'));
    }

    @Override
    public boolean validateArgs(CommandLine line) {
        if (!line.hasOption("xid")) {
            ShellEnvironment.printlnResource("args.xid_missing");
            return false;
        }
        return true;
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) throws IOException {
        return this.updateConnection(this.getLong(line, "xid"), line.getArgList(), isInteractive);
    }

    private Status updateConnection(Long connectionId, List<String> args, boolean isInteractive) throws IOException {
        ShellEnvironment.printlnResource("update.conn", connectionId);
        ConsoleReader reader = new ConsoleReader();
        MConnection connection = ShellEnvironment.client.getConnection(connectionId.longValue());
        ResourceBundle connectorBundle = ShellEnvironment.client.getResourceBundle(connection.getConnectorId());
        ResourceBundle frameworkBundle = ShellEnvironment.client.getFrameworkResourceBundle();
        Status status = Status.FINE;
        if (isInteractive) {
            ShellEnvironment.printlnResource("prompt.update_conn_metadata");
            do {
                if (!status.canProceed()) {
                    FormFiller.errorIntroduction();
                }
                if (FormFiller.fillConnection(reader, connection, connectorBundle, frameworkBundle)) continue;
                return null;
            } while (!(status = ShellEnvironment.client.updateConnection(connection)).canProceed());
        } else {
            ConnectionDynamicFormOptions options = new ConnectionDynamicFormOptions();
            options.prepareOptions(connection);
            CommandLine line = FormOptions.parseOptions(options, 0, args, false);
            if (FormFiller.fillConnection(line, connection)) {
                status = ShellEnvironment.client.updateConnection(connection);
                if (!status.canProceed()) {
                    FormFiller.printConnectionValidationMessages(connection);
                    return null;
                }
            } else {
                FormFiller.printConnectionValidationMessages(connection);
                return null;
            }
        }
        FormDisplayer.displayFormWarning((MAccountableEntity)connection);
        ShellEnvironment.printlnResource("update.conn_successful", status.name());
        return status;
    }
}

