/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.sqoop.client.request.VersionRequest;
import org.apache.sqoop.common.VersionInfo;
import org.apache.sqoop.json.VersionBean;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.validation.Status;

public class ShowVersionFunction
extends SqoopFunction {
    private VersionRequest versionRequest;

    protected ShowVersionFunction() {
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("show.prompt_display_all_versions"));
        OptionBuilder.withLongOpt((String)"all");
        this.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("show.prompt_display_version_server"));
        OptionBuilder.withLongOpt((String)"server");
        this.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("show.prompt_display_version_client"));
        OptionBuilder.withLongOpt((String)"client");
        this.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("show.prompt_display_version_protocol"));
        OptionBuilder.withLongOpt((String)"protocol");
        this.addOption(OptionBuilder.create((char)'p'));
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) {
        if (line.getArgs().length == 1) {
            ShellEnvironment.printlnResource("show.version_usage");
            return null;
        }
        if (line.hasOption("all")) {
            this.showVersion(true, true, true);
        } else {
            boolean server = false;
            boolean client = false;
            boolean protocol = false;
            if (line.hasOption("server")) {
                server = true;
            }
            if (line.hasOption("client")) {
                client = true;
            }
            if (line.hasOption("protocol")) {
                protocol = true;
            }
            this.showVersion(server, client, protocol);
        }
        return Status.FINE;
    }

    private void showVersion(boolean server, boolean client, boolean protocol) {
        if (!(client || server || protocol)) {
            client = true;
        }
        if (client) {
            ShellEnvironment.printlnResource("show.prompt_version_client_server", "client", VersionInfo.getVersion(), VersionInfo.getRevision(), VersionInfo.getUser(), VersionInfo.getDate());
        }
        if (!server && !protocol) {
            return;
        }
        if (this.versionRequest == null) {
            this.versionRequest = new VersionRequest();
        }
        VersionBean versionBean = this.versionRequest.doGet(ShellEnvironment.getServerUrl());
        if (server) {
            ShellEnvironment.printlnResource("show.prompt_version_client_server", "server", versionBean.getVersion(), versionBean.getRevision(), versionBean.getUser(), versionBean.getDate());
        }
        if (protocol) {
            ShellEnvironment.printlnResource("show.prompt_version_protocol", Arrays.toString(versionBean.getProtocols()));
        }
    }
}

