/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.validation.Status;

public class ShowServerFunction
extends SqoopFunction {
    protected ShowServerFunction() {
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("show.prompt_display_all_servers"));
        OptionBuilder.withLongOpt((String)"all");
        this.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("show.prompt_display_server_host"));
        OptionBuilder.withLongOpt((String)"host");
        this.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("show.prompt_display_server_port"));
        OptionBuilder.withLongOpt((String)"port");
        this.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("show.prompt_display_server_webapp"));
        OptionBuilder.withLongOpt((String)"webapp");
        this.addOption(OptionBuilder.create((char)'w'));
    }

    @Override
    public boolean validateArgs(CommandLine line) {
        if (line.getArgs().length == 1) {
            ShellEnvironment.printlnResource("show.server_usage");
            return false;
        }
        return true;
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) {
        if (line.hasOption("all")) {
            this.showServer(true, true, true, true);
        } else {
            boolean host = false;
            boolean port = false;
            boolean webapp = false;
            boolean version = false;
            if (line.hasOption("host")) {
                host = true;
            }
            if (line.hasOption("port")) {
                port = true;
            }
            if (line.hasOption("webapp")) {
                webapp = true;
            }
            this.showServer(host, port, webapp, version);
        }
        return Status.FINE;
    }

    private void showServer(boolean host, boolean port, boolean webapp, boolean version) {
        if (host) {
            ShellEnvironment.printlnResource("show.prompt_server_host", ShellEnvironment.getServerHost());
        }
        if (port) {
            ShellEnvironment.printlnResource("show.prompt_server_port", ShellEnvironment.getServerPort());
        }
        if (webapp) {
            ShellEnvironment.printlnResource("show.prompt_server_webapp", ShellEnvironment.getServerWebapp());
        }
    }
}

