/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.validation.Status;

public class ShowOptionFunction
extends SqoopFunction {
    protected ShowOptionFunction() {
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.withDescription((String)ShellEnvironment.resource.getString("set.prompt_opt_name"));
        OptionBuilder.withLongOpt((String)"name");
        this.addOption(OptionBuilder.create((char)'n'));
    }

    @Override
    public boolean validateArgs(CommandLine line) {
        if (line.getArgs().length == 1) {
            this.printAllOptions();
            return false;
        }
        return true;
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) {
        if (line.hasOption("name")) {
            String optionName = line.getOptionValue("name");
            if (optionName.equals("verbose")) {
                this.printVerbose();
            }
            if (optionName.equals("poll-timeout")) {
                this.printPollTimeout();
            }
        } else {
            this.printAllOptions();
            return null;
        }
        return Status.FINE;
    }

    private void printAllOptions() {
        this.printVerbose();
        this.printPollTimeout();
    }

    private void printVerbose() {
        ShellEnvironment.print("Verbose = ");
        ShellEnvironment.println(String.valueOf(ShellEnvironment.isVerbose()));
    }

    private void printPollTimeout() {
        ShellEnvironment.print("Poll-timeout = ");
        ShellEnvironment.println(String.valueOf(ShellEnvironment.getPollTimeout()));
    }
}

