/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import java.text.DateFormat;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.shell.utils.FormDisplayer;
import org.apache.sqoop.shell.utils.TableDisplayer;
import org.apache.sqoop.validation.Status;

public class ShowJobFunction
extends SqoopFunction {
    protected ShowJobFunction() {
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("show.prompt_display_all_jobs"));
        OptionBuilder.withLongOpt((String)"all");
        this.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"jid");
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("show.prompt_display_job_jid"));
        OptionBuilder.withLongOpt((String)"jid");
        this.addOption(OptionBuilder.create((char)'j'));
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) {
        if (line.hasOption("all")) {
            this.showJobs();
        } else if (line.hasOption("jid")) {
            this.showJob(this.getLong(line, "jid"));
        } else {
            this.showSummary();
        }
        return Status.FINE;
    }

    private void showSummary() {
        List jobs = ShellEnvironment.client.getJobs();
        LinkedList<String> header = new LinkedList<String>();
        header.add(ShellEnvironment.resourceString("table.header.id"));
        header.add(ShellEnvironment.resourceString("table.header.name"));
        header.add(ShellEnvironment.resourceString("table.header.type"));
        header.add(ShellEnvironment.resourceString("table.header.connector"));
        header.add(ShellEnvironment.resourceString("table.header.enabled"));
        LinkedList<String> ids = new LinkedList<String>();
        LinkedList<String> names = new LinkedList<String>();
        LinkedList<String> types = new LinkedList<String>();
        LinkedList<String> connectors = new LinkedList<String>();
        LinkedList<String> availabilities = new LinkedList<String>();
        for (MJob job : jobs) {
            ids.add(String.valueOf(job.getPersistenceId()));
            names.add(job.getName());
            types.add(job.getType().toString());
            connectors.add(String.valueOf(job.getConnectorId()));
            availabilities.add(String.valueOf(job.getEnabled()));
        }
        TableDisplayer.display(header, ids, names, types, connectors, availabilities);
    }

    private void showJobs() {
        List jobs = ShellEnvironment.client.getJobs();
        ShellEnvironment.printlnResource("show.prompt_jobs_to_show", jobs.size());
        for (MJob job : jobs) {
            this.displayJob(job);
        }
    }

    private void showJob(Long jid) {
        MJob job = ShellEnvironment.client.getJob(jid.longValue());
        ShellEnvironment.printlnResource("show.prompt_jobs_to_show", 1);
        this.displayJob(job);
    }

    private void displayJob(MJob job) {
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 3);
        ShellEnvironment.printlnResource("show.prompt_job_info", job.getPersistenceId(), job.getName(), job.getEnabled(), job.getCreationUser(), formatter.format(job.getCreationDate()), job.getLastUpdateUser(), formatter.format(job.getLastUpdateDate()));
        ShellEnvironment.printlnResource("show.prompt_job_xid_cid_info", job.getConnectionId(), job.getConnectorId());
        FormDisplayer.displayForms(job.getConnectorPart().getForms(), ShellEnvironment.client.getResourceBundle(job.getConnectorId()));
        FormDisplayer.displayForms(job.getFrameworkPart().getForms(), ShellEnvironment.client.getFrameworkResourceBundle());
    }
}

