/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.sqoop.model.MFramework;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.shell.utils.FormDisplayer;
import org.apache.sqoop.validation.Status;

public class ShowFrameworkFunction
extends SqoopFunction {
    protected ShowFrameworkFunction() {
    }

    @Override
    public boolean validateArgs(CommandLine line) {
        if (line.getArgs().length != 0) {
            ShellEnvironment.printlnResource("show.framework_usage");
            return false;
        }
        return true;
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) {
        this.showFramework();
        return Status.FINE;
    }

    private void showFramework() {
        MFramework framework = ShellEnvironment.client.getFramework();
        ResourceBundle bundle = ShellEnvironment.client.getFrameworkResourceBundle();
        ShellEnvironment.printlnResource("show.prompt_framework_opts", framework.getPersistenceId());
        FormDisplayer.displayFormMetadataDetails(framework, bundle);
    }
}

