/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.model.MFramework;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.shell.utils.FormDisplayer;
import org.apache.sqoop.shell.utils.TableDisplayer;
import org.apache.sqoop.validation.Status;

public class ShowConnectorFunction
extends SqoopFunction {
    protected ShowConnectorFunction() {
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("show.prompt_display_all_connectors"));
        OptionBuilder.withLongOpt((String)"all");
        this.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"cid");
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("show.prompt_display_connector_cid"));
        OptionBuilder.withLongOpt((String)"cid");
        this.addOption(OptionBuilder.create((char)'c'));
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) {
        if (line.hasOption("all")) {
            this.showConnectors();
        } else if (line.hasOption("cid")) {
            this.showConnector(this.getLong(line, "cid"));
        } else {
            this.showSummary();
        }
        return Status.FINE;
    }

    private void showSummary() {
        Collection connectors = ShellEnvironment.client.getConnectors();
        LinkedList<String> header = new LinkedList<String>();
        header.add(ShellEnvironment.resourceString("table.header.id"));
        header.add(ShellEnvironment.resourceString("table.header.name"));
        header.add(ShellEnvironment.resourceString("table.header.version"));
        header.add(ShellEnvironment.resourceString("table.header.class"));
        LinkedList<String> ids = new LinkedList<String>();
        LinkedList<String> uniqueNames = new LinkedList<String>();
        LinkedList<String> versions = new LinkedList<String>();
        LinkedList<String> classes = new LinkedList<String>();
        for (MConnector connector : connectors) {
            ids.add(String.valueOf(connector.getPersistenceId()));
            uniqueNames.add(connector.getUniqueName());
            versions.add(connector.getVersion());
            classes.add(connector.getClassName());
        }
        TableDisplayer.display(header, ids, uniqueNames, versions, classes);
    }

    private void showConnectors() {
        Collection connectors = ShellEnvironment.client.getConnectors();
        ShellEnvironment.printlnResource("show.prompt_connectors_to_show", connectors.size());
        for (MConnector connector : connectors) {
            this.displayConnector(connector);
        }
    }

    private void showConnector(Long cid) {
        MConnector connector = ShellEnvironment.client.getConnector(cid.longValue());
        ShellEnvironment.printlnResource("show.prompt_connectors_to_show", 1);
        this.displayConnector(connector);
    }

    private void displayConnector(MConnector connector) {
        ShellEnvironment.printlnResource("show.prompt_connector_info", connector.getPersistenceId(), connector.getUniqueName(), connector.getClassName(), connector.getVersion());
        FormDisplayer.displayFormMetadataDetails((MFramework)connector, ShellEnvironment.client.getResourceBundle(connector.getPersistenceId()));
    }
}

