/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.sqoop.client.SqoopClient;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.shell.core.ShellError;
import org.codehaus.groovy.tools.shell.IO;

public final class ShellEnvironment {
    private static final long DEFAULT_POLL_TIMEOUT = 10000L;
    private static String DEFAULT_SERVER_HOST = ShellEnvironment.getEnv("SQOOP2_HOST", "localhost");
    private static String DEFAULT_SERVER_PORT = ShellEnvironment.getEnv("SQOOP2_PORT", "12000");
    private static String DEFAULT_SERVER_WEBAPP = ShellEnvironment.getEnv("SQOOP2_WEBAPP", "sqoop");
    private static String serverHost = DEFAULT_SERVER_HOST;
    private static String serverPort = DEFAULT_SERVER_PORT;
    private static String serverWebapp = DEFAULT_SERVER_WEBAPP;
    private static boolean verbose = false;
    private static boolean interactive = false;
    private static long pollTimeout = 10000L;
    static ResourceBundle resource = ResourceBundle.getBundle("shell-resource", Locale.getDefault());
    static SqoopClient client = new SqoopClient(ShellEnvironment.getServerUrl());
    static IO io;

    private ShellEnvironment() {
    }

    public static String getEnv(String variable, String defaultValue) {
        String value = System.getenv(variable);
        return value != null ? value : defaultValue;
    }

    public static SqoopClient getClient() {
        return client;
    }

    public static void setIo(IO ioObject) {
        io = ioObject;
    }

    public static IO getIo() {
        return io;
    }

    public static void setServerHost(String host) {
        serverHost = host;
        client.setServerUrl(ShellEnvironment.getServerUrl());
    }

    public static String getServerHost() {
        return serverHost;
    }

    public static void setServerPort(String port) {
        serverPort = port;
        client.setServerUrl(ShellEnvironment.getServerUrl());
    }

    public static String getServerPort() {
        return serverPort;
    }

    public static void setServerWebapp(String webapp) {
        serverWebapp = webapp;
        client.setServerUrl(ShellEnvironment.getServerUrl());
    }

    public static String getServerWebapp() {
        return serverWebapp;
    }

    public static void setServerUrl(String ustr) {
        try {
            int port;
            URL url = new URL(ustr);
            String host = url.getHost();
            if (host.length() > 0) {
                serverHost = host;
            }
            serverPort = (port = url.getPort()) != -1 ? Integer.toString(port) : DEFAULT_SERVER_PORT;
            String webapp = url.getFile();
            serverWebapp = webapp.length() > 1 ? webapp.substring(1) : DEFAULT_SERVER_WEBAPP;
            client.setServerUrl(ShellEnvironment.getServerUrl());
        }
        catch (MalformedURLException ex) {
            throw new SqoopException((ErrorCode)ShellError.SHELL_0003, (Throwable)ex);
        }
    }

    public static String getServerUrl() {
        return "http://" + serverHost + ":" + serverPort + "/" + serverWebapp + "/";
    }

    public static ResourceBundle getResourceBundle() {
        return resource;
    }

    public static void setVerbose(boolean newValue) {
        verbose = newValue;
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setInteractive(boolean newValue) {
        interactive = newValue;
    }

    public static boolean isInteractive() {
        return interactive;
    }

    public static void setPollTimeout(long timeout) {
        pollTimeout = timeout;
    }

    public static long getPollTimeout() {
        return pollTimeout;
    }

    public static String resourceString(String resourceName) {
        return resource.getString(resourceName);
    }

    public static void printlnResource(String resourceName) {
        ShellEnvironment.io.out.println(resource.getString(resourceName));
    }

    public static void printlnResource(String resourceName, Object ... values) {
        ShellEnvironment.io.out.println(MessageFormat.format(ShellEnvironment.resourceString(resourceName), values));
    }

    public static void println(String str, Object ... values) {
        ShellEnvironment.io.out.println(MessageFormat.format(str, values));
    }

    public static void println(String str) {
        ShellEnvironment.io.out.println(str);
    }

    public static void println(Object obj) {
        ShellEnvironment.io.out.println(obj);
    }

    public static void println() {
        ShellEnvironment.io.out.println();
    }

    public static void print(String str) {
        ShellEnvironment.io.out.print(str);
    }

    public static void print(Object obj) {
        ShellEnvironment.io.out.print(obj);
    }

    public static void print(String format, Object ... args) {
        ShellEnvironment.io.out.printf(format, args);
    }
}

