/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.core.ShellError;
import org.codehaus.groovy.tools.shell.Command;
import org.codehaus.groovy.tools.shell.CommandSupport;
import org.codehaus.groovy.tools.shell.Shell;
import org.codehaus.groovy.tools.shell.util.SimpleCompletor;

public class HelpCommand
extends CommandSupport {
    protected HelpCommand(Shell shell) {
        super(shell, "help", "\\h");
    }

    public String getDescription() {
        return ShellEnvironment.resourceString("help.description");
    }

    public String getUsage() {
        return ShellEnvironment.resourceString("help.usage");
    }

    public String getHelp() {
        return ShellEnvironment.resourceString("help.message");
    }

    public Object execute(List args) {
        if (args.size() == 0) {
            this.list();
        } else {
            this.help((String)args.get(0));
        }
        return null;
    }

    private void list() {
        int maxName = 0;
        int maxShortcut = 0;
        for (Command command : this.shell.getRegistry().commands()) {
            if (command.getHidden()) continue;
            if (command.getName().length() > maxName) {
                maxName = command.getName().length();
            }
            if (command.getShortcut().length() <= maxShortcut) continue;
            maxShortcut = command.getShortcut().length();
        }
        ShellEnvironment.printlnResource("help.info");
        ShellEnvironment.println();
        ShellEnvironment.printlnResource("help.avail_commands");
        for (Command command : this.shell.getRegistry().commands()) {
            if (command.getHidden()) continue;
            String paddedName = StringUtils.rightPad((String)command.getName(), (int)maxName);
            String paddedShortcut = StringUtils.rightPad((String)command.getShortcut(), (int)maxShortcut);
            String description = command.getDescription();
            StringBuilder sb = new StringBuilder();
            sb.append("  ").append(MessageFormat.format(ShellEnvironment.resource.getString("help.cmd_description"), paddedName, paddedShortcut, description));
            ShellEnvironment.println(sb.toString());
        }
        ShellEnvironment.println();
        ShellEnvironment.printlnResource("help.specific_cmd_info");
        ShellEnvironment.println();
    }

    private void help(String name) {
        Command command = this.shell.getRegistry().find(name);
        if (command == null) {
            String msg = MessageFormat.format(ShellEnvironment.resource.getString("unrecognized.cmd"), name);
            throw new SqoopException((ErrorCode)ShellError.SHELL_0001, msg);
        }
        ShellEnvironment.printlnResource("help.cmd_usage", command.getName(), command.getUsage());
        ShellEnvironment.println();
        ShellEnvironment.println(command.getHelp());
        ShellEnvironment.println();
    }

    protected List createCompletors() {
        SimpleCompletor completor = new SimpleCompletor();
        for (Command command : this.registry) {
            if (command.getHidden()) continue;
            completor.add(command.getName());
        }
        LinkedList<SimpleCompletor> completors = new LinkedList<SimpleCompletor>();
        completors.add(completor);
        return completors;
    }
}

