/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import jline.ConsoleReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.sqoop.model.MAccountableEntity;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.shell.utils.FormDisplayer;
import org.apache.sqoop.shell.utils.FormFiller;
import org.apache.sqoop.shell.utils.FormOptions;
import org.apache.sqoop.shell.utils.JobDynamicFormOptions;
import org.apache.sqoop.validation.Status;

public class CreateJobFunction
extends SqoopFunction {
    public CreateJobFunction() {
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("prompt.conn_id"));
        OptionBuilder.withLongOpt((String)"xid");
        OptionBuilder.hasArg();
        this.addOption(OptionBuilder.create((char)'x'));
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("prompt.job_type"));
        OptionBuilder.withLongOpt((String)"type");
        OptionBuilder.hasArg();
        this.addOption(OptionBuilder.create((char)'t'));
    }

    @Override
    public boolean validateArgs(CommandLine line) {
        if (!line.hasOption("xid")) {
            ShellEnvironment.printlnResource("args.xid_missing");
            return false;
        }
        if (!line.hasOption("type")) {
            ShellEnvironment.printlnResource("args.type_missing");
            return false;
        }
        return true;
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) throws IOException {
        return this.createJob(this.getLong(line, "xid"), line.getOptionValue("type"), line.getArgList(), isInteractive);
    }

    private Status createJob(Long connectionId, String type, List<String> args, boolean isInteractive) throws IOException {
        ShellEnvironment.printlnResource("create.creating_job", connectionId);
        ConsoleReader reader = new ConsoleReader();
        MJob job = ShellEnvironment.client.newJob(connectionId.longValue(), MJob.Type.valueOf((String)type.toUpperCase()));
        ResourceBundle connectorBundle = ShellEnvironment.client.getResourceBundle(job.getConnectorId());
        ResourceBundle frameworkBundle = ShellEnvironment.client.getFrameworkResourceBundle();
        Status status = Status.FINE;
        if (isInteractive) {
            ShellEnvironment.printlnResource("prompt.fill_job_metadata");
            do {
                if (!status.canProceed()) {
                    FormFiller.errorIntroduction();
                }
                if (FormFiller.fillJob(reader, job, connectorBundle, frameworkBundle)) continue;
                return null;
            } while (!(status = ShellEnvironment.client.createJob(job)).canProceed());
        } else {
            JobDynamicFormOptions options = new JobDynamicFormOptions();
            options.prepareOptions(job);
            CommandLine line = FormOptions.parseOptions(options, 0, args, false);
            if (FormFiller.fillJob(line, job)) {
                status = ShellEnvironment.client.createJob(job);
                if (!status.canProceed()) {
                    FormFiller.printJobValidationMessages(job);
                    return null;
                }
            } else {
                FormFiller.printJobValidationMessages(job);
                return null;
            }
        }
        FormDisplayer.displayFormWarning((MAccountableEntity)job);
        ShellEnvironment.printlnResource("create.job_successful", status.name(), job.getPersistenceId());
        return status;
    }
}

