/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell.utils;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MForm;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MInputType;
import org.apache.sqoop.shell.core.ShellError;

public class FormOptions {
    public static String getOptionKey(String prefix, MInput input) {
        return prefix + "-" + input.getName().replace('.', '-');
    }

    public static List<Option> getFormsOptions(String prefix, List<MForm> forms) {
        LinkedList<Option> options = new LinkedList<Option>();
        for (MForm form : forms) {
            List<Option> formOptions = FormOptions.getFormOptions(prefix, form);
            options.addAll(formOptions);
        }
        return options;
    }

    public static List<Option> getFormOptions(String prefix, MForm form) {
        LinkedList<Option> options = new LinkedList<Option>();
        for (MInput input : form.getInputs()) {
            if (input.getType().equals((Object)MInputType.BOOLEAN)) {
                OptionBuilder.withLongOpt((String)FormOptions.getOptionKey(prefix, input));
                options.add(OptionBuilder.create());
                continue;
            }
            OptionBuilder.withLongOpt((String)FormOptions.getOptionKey(prefix, input));
            OptionBuilder.hasArg();
            options.add(OptionBuilder.create());
        }
        return options;
    }

    public static CommandLine parseOptions(Options options, int start, List<String> arglist, boolean stopAtNonOption) {
        CommandLine line;
        String[] args = arglist.subList(start, arglist.size()).toArray(new String[arglist.size() - start]);
        GnuParser parser = new GnuParser();
        try {
            line = parser.parse(options, args, stopAtNonOption);
        }
        catch (ParseException e) {
            throw new SqoopException((ErrorCode)ShellError.SHELL_0003, e.getMessage(), (Throwable)e);
        }
        return line;
    }
}

