/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.shell.utils.SubmissionDisplayer;
import org.apache.sqoop.submission.SubmissionStatus;
import org.apache.sqoop.validation.Status;

public class StatusJobFunction
extends SqoopFunction {
    public StatusJobFunction() {
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"jid");
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("prompt.job_id"));
        OptionBuilder.withLongOpt((String)"jid");
        this.addOption(OptionBuilder.create((char)'j'));
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) {
        if (line.hasOption("jid")) {
            MSubmission submission = ShellEnvironment.client.getSubmissionStatus(this.getLong(line, "jid"));
            if (submission.getStatus().isFailure() || submission.getStatus().equals((Object)SubmissionStatus.SUCCEEDED)) {
                SubmissionDisplayer.displayHeader(submission);
                SubmissionDisplayer.displayFooter(submission);
            } else {
                SubmissionDisplayer.displayHeader(submission);
                SubmissionDisplayer.displayProgress(submission);
            }
        } else {
            return null;
        }
        return Status.FINE;
    }
}

