/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.log4j.Logger;
import org.apache.sqoop.client.SubmissionCallback;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.SqoopFunction;
import org.apache.sqoop.shell.core.ShellError;
import org.apache.sqoop.shell.utils.SubmissionDisplayer;
import org.apache.sqoop.validation.Status;

public class StartJobFunction
extends SqoopFunction {
    public static final Logger LOG = Logger.getLogger(StartJobFunction.class);

    public StartJobFunction() {
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"jid");
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("prompt.job_id"));
        OptionBuilder.withLongOpt((String)"jid");
        this.addOption(OptionBuilder.create((char)'j'));
        OptionBuilder.withDescription((String)ShellEnvironment.resourceString("start.prompt_synchronous"));
        OptionBuilder.withLongOpt((String)"synchronous");
        this.addOption(OptionBuilder.create((char)'s'));
    }

    @Override
    public Object executeFunction(CommandLine line, boolean isInteractive) {
        if (line.hasOption("synchronous") && line.hasOption("jid")) {
            long pollTimeout = ShellEnvironment.getPollTimeout();
            SubmissionCallback callback = new SubmissionCallback(){

                public void submitted(MSubmission submission) {
                    SubmissionDisplayer.displayHeader(submission);
                    SubmissionDisplayer.displayProgress(submission);
                }

                public void updated(MSubmission submission) {
                    SubmissionDisplayer.displayProgress(submission);
                }

                public void finished(MSubmission submission) {
                    SubmissionDisplayer.displayFooter(submission);
                }
            };
            try {
                ShellEnvironment.client.startSubmission(this.getLong(line, "jid"), callback, pollTimeout);
            }
            catch (InterruptedException e) {
                throw new SqoopException((ErrorCode)ShellError.SHELL_0007, (Throwable)e);
            }
        } else if (line.hasOption("jid")) {
            MSubmission submission = ShellEnvironment.client.startSubmission(this.getLong(line, "jid"));
            if (submission.getStatus().isFailure()) {
                SubmissionDisplayer.displayFooter(submission);
            } else {
                SubmissionDisplayer.displayHeader(submission);
                SubmissionDisplayer.displayProgress(submission);
            }
        } else {
            return null;
        }
        return Status.FINE;
    }
}

