/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import groovy.lang.Closure;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.sqoop.shell.CloneCommand;
import org.apache.sqoop.shell.CreateCommand;
import org.apache.sqoop.shell.DeleteCommand;
import org.apache.sqoop.shell.DisableCommand;
import org.apache.sqoop.shell.EnableCommand;
import org.apache.sqoop.shell.HelpCommand;
import org.apache.sqoop.shell.SetCommand;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.ShowCommand;
import org.apache.sqoop.shell.StartCommand;
import org.apache.sqoop.shell.StatusCommand;
import org.apache.sqoop.shell.StopCommand;
import org.apache.sqoop.shell.UpdateCommand;
import org.apache.sqoop.shell.utils.ThrowableDisplayer;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.tools.shell.Command;
import org.codehaus.groovy.tools.shell.CommandRegistry;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.codehaus.groovy.tools.shell.IO;
import org.codehaus.groovy.tools.shell.Shell;

public final class SqoopShell {
    private static final String RC_FILE = ".sqoop2rc";
    public static final HashSet<String> commandsToKeep = new HashSet();

    public static void main(String[] args) throws Exception {
        System.setProperty("groovysh.prompt", "sqoop");
        Groovysh shell = new Groovysh();
        shell.setErrorHook((Closure)new MethodClosure(ThrowableDisplayer.class, "errorHook"));
        CommandRegistry registry = shell.getRegistry();
        Iterator iterator = registry.iterator();
        while (iterator.hasNext()) {
            Command command = (Command)iterator.next();
            if (commandsToKeep.contains(command.getName())) continue;
            iterator.remove();
            registry.remove(command);
        }
        shell.register((Command)new HelpCommand((Shell)shell));
        shell.register((Command)new SetCommand((Shell)shell));
        shell.register((Command)new ShowCommand((Shell)shell));
        shell.register((Command)new CreateCommand((Shell)shell));
        shell.register((Command)new DeleteCommand((Shell)shell));
        shell.register((Command)new UpdateCommand((Shell)shell));
        shell.register((Command)new CloneCommand((Shell)shell));
        shell.register((Command)new StartCommand((Shell)shell));
        shell.register((Command)new StopCommand((Shell)shell));
        shell.register((Command)new StatusCommand((Shell)shell));
        shell.register((Command)new EnableCommand((Shell)shell));
        shell.register((Command)new DisableCommand((Shell)shell));
        ShellEnvironment.setIo(shell.getIo());
        ShellEnvironment.setInteractive(false);
        String homeDir = System.getProperty("user.home");
        File rcFile = new File(homeDir, RC_FILE);
        if (rcFile.exists()) {
            ShellEnvironment.printlnResource("sqoop.prompt_shell_loadrc", RC_FILE);
            SqoopShell.interpretFileContent(rcFile, shell);
            ShellEnvironment.printlnResource("sqoop.prompt_shell_loadedrc");
        }
        if (args.length == 0) {
            ShellEnvironment.getIo().setVerbosity(IO.Verbosity.QUIET);
            ShellEnvironment.printlnResource("sqoop.shell_banner");
            ShellEnvironment.println();
            ShellEnvironment.setInteractive(true);
            shell.run(args);
        } else {
            File script = new File(args[0]);
            if (!script.isAbsolute()) {
                String userDir = System.getProperty("user.dir");
                script = new File(userDir, args[0]);
            }
            SqoopShell.interpretFileContent(script, shell);
        }
    }

    private static void interpretFileContent(File script, Groovysh shell) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(script));
        while ((line = in.readLine()) != null) {
            if (line.isEmpty() || line.startsWith("#")) continue;
            ShellEnvironment.print(shell.renderPrompt());
            ShellEnvironment.println(line);
            Object result = shell.execute(line);
            if (result != null) continue;
            break;
        }
    }

    private SqoopShell() {
    }

    static {
        commandsToKeep.add("exit");
        commandsToKeep.add("history");
    }
}

