/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.shell.ShellEnvironment;
import org.apache.sqoop.shell.core.ShellError;
import org.apache.sqoop.shell.utils.FormOptions;

public abstract class SqoopFunction
extends Options {
    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printOptions(ShellEnvironment.getIo().out, formatter.getWidth(), (Options)this, 0, 4);
    }

    public abstract Object executeFunction(CommandLine var1, boolean var2) throws IOException;

    public boolean validateArgs(CommandLine line) {
        return true;
    }

    public Object execute(List<String> args) {
        CommandLine line = FormOptions.parseOptions(this, 1, args, true);
        try {
            if (this.validateArgs(line)) {
                return this.executeFunction(line, ShellEnvironment.isInteractive());
            }
            return null;
        }
        catch (IOException ex) {
            throw new SqoopException((ErrorCode)ShellError.SHELL_0005, (Throwable)ex);
        }
    }

    protected long getLong(CommandLine line, String parameterName) {
        return Long.parseLong(line.getOptionValue(parameterName));
    }
}

