/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.shell;

import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.shell.core.ShellError;
import org.codehaus.groovy.tools.shell.ComplexCommandSupport;
import org.codehaus.groovy.tools.shell.Shell;

public abstract class SqoopCommand
extends ComplexCommandSupport {
    private String descriptionPrefix;
    private String descriptionPostfix;
    private String description;
    private String usage;
    private String help;

    protected SqoopCommand(Shell shell, String name, String shortcut, String[] funcs, String descriptionPrefix, String descriptionPostfix) {
        super(shell, name, shortcut);
        this.functions = new LinkedList();
        for (String func : funcs) {
            this.functions.add(func);
        }
        this.descriptionPrefix = descriptionPrefix;
        this.descriptionPostfix = descriptionPostfix;
    }

    public String getDescription() {
        if (this.description == null) {
            StringBuilder sb = new StringBuilder();
            if (this.descriptionPrefix != null) {
                sb.append(this.descriptionPrefix);
                sb.append(" ");
            }
            Iterator iterator = this.functions.iterator();
            int size = this.functions.size();
            sb.append((String)iterator.next());
            if (size > 1) {
                for (int i = 1; i < size - 1; ++i) {
                    sb.append(", ");
                    sb.append((String)iterator.next());
                }
                sb.append(" or ");
                sb.append((String)iterator.next());
            }
            if (this.descriptionPostfix != null) {
                sb.append(" ");
                sb.append(this.descriptionPostfix);
            }
            this.description = sb.toString();
        }
        return this.description;
    }

    public String getUsage() {
        if (this.usage == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            Iterator iterator = this.functions.iterator();
            int size = this.functions.size();
            sb.append((String)iterator.next());
            for (int i = 1; i < size; ++i) {
                sb.append("|");
                sb.append((String)iterator.next());
            }
            sb.append("]");
            this.usage = sb.toString();
        }
        return this.usage;
    }

    public String getHelp() {
        if (this.help == null) {
            this.help = this.getDescription() + ".";
        }
        return this.help;
    }

    public Object execute(List args) {
        this.resolveVariables(args);
        return this.executeCommand(args);
    }

    public abstract Object executeCommand(List var1);

    protected void resolveVariables(List arg) {
        ArrayList<String> temp = new ArrayList<String>();
        GroovyShell gs = new GroovyShell(this.getBinding());
        for (Object obj : arg) {
            Script scr = gs.parse("\"" + (String)obj + "\"");
            try {
                temp.add(scr.run().toString());
            }
            catch (MissingPropertyException e) {
                throw new SqoopException((ErrorCode)ShellError.SHELL_0004, e.getMessage(), (Throwable)e);
            }
        }
        Collections.copy(arg, temp);
    }
}

